###############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
# Date Written: 2009/01/19
#
# Revision 1.0
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


import os
import sys
import commands


class SanityTest:


    def compileScripts(self, debug=0):
        """ Copies required files and Compiles Local Security Checks
            generated by Local Security Check Generator
        """
        try:
            print "Compiling Local Security Check..."
            ## Path where all required files will be copied.
            test_dir = self.build_path + 'sanity_test/plugins/'
            if debug:
                print "(%s), where required file will be copied : " %(test_dir)

            if not self.openvas_plugin_path.endswith('/'):
                openvas_plugin_path = self.openvas_plugin_path + '/'
            else:
                openvas_plugin_path = self.openvas_plugin_path

            msg = commands.getoutput("ls "+ openvas_plugin_path + 'revisions-lib.inc')
            if 'No such file or director' in msg:
                cmd = "grep plugins_folder `openvasd-config --sysconfdir`"+ \
                                                 "/openvas/openvasd.conf"
                msg = commands.getoutput(cmd)
                if ("plugins_folder" not in msg) and ("plugins" not in msg):
                    print "Error while executing command : ", cmd
                    sys.exit(msg)

                openvas_plugin_path = msg.split('=')[1].strip() + '/'

                if not openvas_plugin_path.endswith('/'):
                    openvas_plugin_path = openvas_plugin_path + '/'

            ## Required inc file
            req_files = [openvas_plugin_path + 'revisions-lib.inc',
                         openvas_plugin_path + 'pkg-lib-rpm.inc',
                         openvas_plugin_path + 'pkg-lib-deb.inc',
                         openvas_plugin_path + 'pkg-lib-hpux.inc',
                         openvas_plugin_path + 'pkg-lib-gentoo.inc',
                         openvas_plugin_path + 'solaris.inc']

            for i in self.os_list:
                req_files.append(self.build_path + i.title() + '/*.nasl')

            if debug:
                print "Copying all required files..."

            ## Copy all files
            for file in req_files:
                cmd = 'cp ' + file + " " + test_dir
                err_msg = commands.getoutput(cmd)
                if err_msg:
                    return err_msg

            try:
                os.chdir(test_dir)
            except Exception, msg:
                print "(%s) Path does not exists" %(test_dir)
                return msg

            if debug:
                print "Compiling Local Security Checks..."

            ## Compile all NASL scripts
            cmd = self.openvas_bin_path + ' -pLX ' + 'gb_*.nasl'
            err_msg = commands.getoutput(cmd)
            if err_msg:
                os.chdir(self.cwd)
                return err_msg

            print "Successfully compiled Local Security Check..."
    
            os.chdir(self.cwd)
            return None

        except Exception, msg:
            print 'Exception in : test -> compile -> compileScripts() method'
            sys.exit(msg)

