# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1167-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57335);
 script_cve_id("CVE-2006-3918", "CVE-2005-3352");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1167-1 (apache)";
 script_name(name);

 desc = "The remote host is missing an update to apache
announced via advisory DSA 1167-1.

Several remote vulnerabilities have been discovered in the Apache, the
worlds most popular webserver, which may lead to the execution of arbitrary
web script.  The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2005-3352

A cross-site scripting (XSS) flaw exists in the mod_imap component of
the Apache server.

CVE-2006-3918

Apache does not sanitize the Expect header from an HTTP request when
it is reflected back in an error message, which might allow cross-site
scripting (XSS) style attacks.

For the stable distribution (sarge) these problems have been fixed in
version 1.3.33-6sarge3.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.34-3.

We recommend that you upgrade your apache package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201167-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1167-1 (apache)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"apache-dev", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-doc", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-utils", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-common", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-dbg", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-perl", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache-ssl", ver:"1.3.33-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-perl", ver:"1.29.0.3-6sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
