# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1579-1 (netpbm-free)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61032);
 script_cve_id("CVE-2008-0554");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1579-1 (netpbm-free)";
 script_name(name);

 desc = "The remote host is missing an update to netpbm-free
announced via advisory DSA 1579-1.

A vulnerability was discovered in the GIF reader implementation in
netpbm-free, a suite of image manipulation utilities.  Insufficient
input data validation could allow a maliciously-crafted GIF file
to overrun a stack buffer, potentially permitting the execution of
arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 2:10.0-11.1+etch1.

For the unstable distribution (sid), these problems were fixed in
version 2:10.0-11.1.

We recommend that you upgrade your netpbm packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201579-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1579-1 (netpbm-free)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnetpbm9", ver:"10.0-11.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm9-dev", ver:"10.0-11.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm10", ver:"10.0-11.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"netpbm", ver:"10.0-11.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnetpbm10-dev", ver:"10.0-11.1+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
