# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1874-1 (nss)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64758);
 script_cve_id("CVE-2009-2404", "CVE-2009-2408", "CVE-2009-2409");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Debian Security Advisory DSA 1874-1 (nss)");

 desc = "The remote host is missing an update to nss
announced via advisory DSA 1874-1.

Several vulnerabilities have been discovered in the Network Security
Service libraries. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-2404

Moxie Marlinspike discovered that a buffer overflow in the regular
expression parser could lead to the execution of arbitrary code.

CVE-2009-2408

Dan Kaminsky discovered that NULL characters in certificate
names could lead to man-in-the-middle attacks by tricking the user
into accepting a rogue certificate.

CVE-2009-2409

Certificates with MD2 hash signatures are no longer accepted
since they're no longer considered cryptograhically secure.


The old stable distribution (etch) doesn't contain nss.

For the stable distribution (lenny), these problems have been fixed in
version 3.12.3.1-0lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 3.12.3.1-1.

We recommend that you upgrade your nss packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201874-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1874-1 (nss)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnss3-1d-dbg", ver:"3.12.3.1-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-dev", ver:"3.12.3.1-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-1d", ver:"3.12.3.1-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3-tools", ver:"3.12.3.1-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
