# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7794 (moin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64414);
 script_cve_id("CVE-2009-2265");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 11 FEDORA-2009-7794 (moin)";
 script_name(name);

 desc = "The remote host is missing an update to moin
announced via advisory FEDORA-2009-7794.

Update Information:

This update removes the filemanager directory from the embedded FCKeditor, it
contains code with know security vulnerabilities, even though that code couldn't
be invoked when Moin was used with the default settings. Moin was probably not
affected, but installing this update is still recommended as a security measure.
CVE-2009-2265 is the related CVE identifier.

ChangeLog:

* Sun Jul 12 2009 Ville-Pekka Vainio  1.8.4-2
- Remove the filemanager directory from the embedded FCKeditor, it contains
code with know security vulnerabilities, even though that code couldn't
be invoked when moin was used with the default settings.
- Fixes rhbz #509924, related to CVE-2009-2265

References:

[ 1 ] Bug #509924 - CVE-2009-2265 moin: embedded fckeditor multiple directory traversal vulns
https://bugzilla.redhat.com/show_bug.cgi?id=509924

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update moin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7794

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-7794 (moin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"moin", rpm:"moin~1.8.4~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
