#
#VID 75770425-67a2-11d8-80e3-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52509);
 script_bugtraq_id(9630);
 script_cve_id("CVE-2004-0269");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.4");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: phpnuke";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: phpnuke

The installed version of phpnuke is vulnerable to a
SQL SQL injection vulnerability.  Remote attackers
can inject arbitrary SQL code and gain sensitive
information via (1) the category variable in the
Search module or (2) the admin variable in the
Web_Links module.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://security.nnov.ru/search/document.asp?docid=5748
http://www.securityfocus.com/archive/1/348375
http://www.securityfocus.com/archive/1/353201
http://www.vuxml.org/freebsd/75770425-67a2-11d8-80e3-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: phpnuke";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpnuke");
if(!isnull(bver) && revcomp(a:bver, b:"6.9")<=0) {
    security_note(0, data:"Package phpnuke version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
