###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for fetchmail vulnerability USN-405-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840041);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "405-1");
  script_cve_id("CVE-2006-5867");
  script_name( "Ubuntu Update for fetchmail vulnerability USN-405-1");
  desc = "

  Vulnerability Insight:

  It was discovered that fetchmail did not correctly require TLS
  negotiation in certain situations.  This would result in a user's
  unencrypted password being sent across the network.
  
  If fetchmail has been configured to use the &quot;sslproto tls1&quot;,
  &quot;sslcertck&quot;, or &quot;sslfingerprint&quot; options with a server that does not
  correctly support TLS negotiation, this update may cause fetchmail to
  (correctly) abort authentication.

  Affected Software/OS:
  fetchmail vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000464.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of fetchmail vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.2-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.2-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.3.4-1ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.3.4-1ubuntu4.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"fetchmail", ver:"6.2.5-13ubuntu3.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmail-ssl", ver:"6.2.5-13ubuntu3.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fetchmailconf", ver:"6.2.5-13ubuntu3.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}