#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# Changes by rd :
#
#	- script id
#	- french translation
#	- minor changes in the english description
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10348);
 script_bugtraq_id(1053);
 script_version ("$Revision: 7521 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 
 script_cve_id("CVE-2000-0169");
 name = "ows-bin";
 script_name(name);
 
 desc = " 
Oracle's Web Listener (a component of the Oracle Application Server),
is installed and can be used by a remote attacker to run arbitrary 
commands on the web server.

Read more about this hole at:
http://www.securiteam.com/windowsntfocus/Oracle_Web_Listener_4_0_x_CGI_vulnerability.html


Solution : If 'ows-bin' is the default CGI directory used by the Oracle Application Server Manager,
then remove the ows-bin virtual directory or point it to a more benign directory.
If 'ows-bin' is not the default then verify that there are no batch files in this directory.

Risk factor : High";



 script_description(desc);
 
 summary = "Checks if ows-bin is vulnerable";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2000 Noam Rathaus");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");
port = get_http_port(default:80);

res = is_cgi_installed_ka(item:"/ows-bin/perlidlc.bat", port:port);
if(res)
{
  req = http_get(item:"/ows-bin/perlidlc.bat?&dir", port:port);
  soc = http_open_socket(port);
  if(soc)
  {
   send(socket:soc, data:req);
   result = http_recv(socket:soc);
   http_close_socket(soc);
   if("ows-bin:" >< result)security_hole(port);
  }
}

