#############################################################################
#
#  Trend Micro OfficeScan ObjRemoveCtrl ActiveX Control BOF Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/29
#
#  Revision: 1.2 
#
#  Log: schandan
#  Issue #0063
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900016);
 script_cve_id("CVE-2008-3364");
 script_bugtraq_id(30407);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.2 $");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("Trend Micro OfficeScan ObjRemoveCtrl ActiveX Control BOF Vulnerability");
 script_summary("Check for the version of Trend Micro OfficeScan");
 desc = "
 Overview : This Remote host is installed with Trend Micro OfficeScan, which
 is prone to ActiveX control buffer overflow vulnerability.

 Vulnerability Insight :
        The flaws are caused due to an error in objRemoveCtrl control, which is used to display 
        certain properties (eg., Server, ServerIniFile etc..) and their values when it is embedded
        in a web page. These property values can be overflowed to cause stack based overflow.

        Impact : Successful exploitation could allow remote attackers to
        execute arbitrary code.

 Impact Level : Application.

 Affected Software/OS :
        OfficeScan 7.3 build 1343 (Patch 4) and prior on Windows (All).
        Trend Micro Worry-Free Business Security (WFBS) version 5.0
        Trend Micro Client Server Messaging Security (CSM) versions 3.5 and 3.6

 Quick Fix : Set killbits for the following clsid's
             {5EFE8CB1-D095-11D1-88FC-0080C859833B}
             To set kill-bit refer, http://support.microsoft.com/kb/240797

 Fix : Upgrade to OfficeScan 10 or later,
 For updates refer, http://uk.trendmicro.com/uk/downloads/enterprise/index.html

 References : http://www.milw0rm.com/exploits/6152
 http://archives.neohapsis.com/archives/fulldisclosure/2008-07/0509.html

 CVSS Score :
        CVSS Base Score	    : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 6.1
 Risk factor : High";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 key = "SOFTWARE\TrendMicro\OfficeScan\service\Information";
 scanVer = registry_get_sz(key:key, item:"Server_Version");

 if(!scanVer){
	exit(0);
 }

 if(egrep(pattern:"^([0-6]\..*|7\.[0-2])$", string:scanVer))
 {
	security_warning(0);
	exit(0);
 }

 if("7.3" >!< scanVer){
	exit(0);
 }

 scanPath = registry_get_sz(key:key, item:"Local_Path");
 if(!scanPath){
	exit(0);
 }

 scanPath += "pccnt\PccNTRes.dll";

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:scanPath);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:scanPath);

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r)
 {
	close(soc);
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot)
 {
	close(soc);
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r)
 {
	close(soc);
        exit(0);
 }

 uid = session_extract_uid(reply:r);

 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid)
 {
	close(soc);
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid)
 {
	close(soc);
        exit(0);
 }

 fsize = smb_get_file_size(socket:soc, uid:uid, tid:tid, fid:fid);
 off = fsize - 90000;

 while(fsize != off)
 {
        data = ReadAndX(socket:soc, uid:uid, tid:tid, count:16384, off:off);
        data = str_replace(find:raw_string(0), replace:"", string:data);
        version = strstr(data, "SpecialBuild");
        if(!version){
                off += 16383;
        }
        else break;
 }

 close(soc);
 if(!version){
        exit(0);
 }

 v = "";
 for(i = strlen("SpecialBuild"); i < strlen(version); i++)
 {
        if((ord(version[i]) < ord("0") ||
            ord(version[i]) > ord("9")) && version[i] != "."){
                break;
        }
        else
                v += version[i];
 }

 # Grep for OfficeScan 7.3 build 1343 (Patch 4) and prior.
 if(egrep(pattern:"^([0-9]?[0-9]?[0-9]|1[0-2][0-9][0-9]|13([0-3][0-9]|" +
	  	  "4[0-3]))$", string:v))
 {
	clsid = "{5EFE8CB1-D095-11D1-88FC-0080C859833B}";
        clsidKey = "SOFTWARE\Classes\CLSID\"+ clsid;
        if(registry_key_exists(key:clsidKey))
        {
                # Check kill bit is set for ActiveX control
                activeKey = "SOFTWARE\Microsoft\Internet Explorer\" +
                            "ActiveX Compatibility\" + clsid;
                killBit = registry_get_dword(key:activeKey,
                                             item:"Compatibility Flags");
                if(!killBit){
                        security_warning(0);
                }
        }
 }
