///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMVIZ_SETTINGS_PAGE_H
#define __ATOMVIZ_SETTINGS_PAGE_H

#include <atomviz/AtomViz.h>

#include <core/Core.h>
#include <core/gui/dialogs/SettingsDialog.h>

namespace AtomViz {

/**
 * \brief A page that is plugged into the application's settings dialog to let the user
 *        configure the AtomViz plugin.
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT AtomVizSettingsPage : public ApplicationSettingsPage
{
public:
	/// Default constructor.
	AtomVizSettingsPage() : ApplicationSettingsPage() {}

	/// \brief Creates the widget that contains the plugin specific setting controls.
	virtual void insertSettingsDialogPage(SettingsDialog* settingsDialog, QTabWidget* tabWidget);

	/// \brief Lets the settings page to save all values entered by the user.
	/// \param settingsDialog The settings dialog box.
	virtual void saveValues(SettingsDialog* settingsDialog);

private Q_SLOTS:

	/// Opens the OpenGL test utility.
	void openOpenGLTestUtility();

private:

	QComboBox* defaultRenderingMethodBox;
	QComboBox* defaultHQRenderingMethodBox;
	SettingsDialog* settingsDialog;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(AtomVizSettingsPage)
};

};	// End of namespace AtomViz

#endif // __ATOMVIZ_SETTINGS_PAGE_H
