///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting_gui/ScriptingGUI.h>
#include <core/gui/RolloutContainer.h>
#include <core/gui/mainwnd/MainFrame.h>
#include "ScriptUtility.h"
#include "ScriptEditor.h"

namespace Scripting {

using namespace boost::python;

IMPLEMENT_PLUGIN_CLASS(ScriptUtility, UtilityPlugin)

/******************************************************************************
* Initializes the utility applet.
******************************************************************************/
ScriptUtility::ScriptUtility() : UtilityPlugin(), panel(NULL)
{
}

/******************************************************************************
* Shows the UI of the utility in the given RolloutContainer.
******************************************************************************/
void ScriptUtility::openUtility(RolloutContainer* container, const RolloutInsertionParameters& rolloutParams)
{
	// Create a rollout.
	panel = new QWidget();
	container->addRollout(panel, tr("Scripting"), rolloutParams);

    // Create the rollout contents.
	QVBoxLayout* layout = new QVBoxLayout(panel);
	layout->setContentsMargins(4,4,4,4);
	layout->setSpacing(4);

	QPushButton* btn;
	layout->addWidget((btn = new QPushButton(tr("Open New Editor"), panel)));
	connect(btn, SIGNAL(clicked(bool)), this, SLOT(onNewEditor()));
	layout->addWidget((btn = new QPushButton(tr("Open Script File"), panel)));
	connect(btn, SIGNAL(clicked(bool)), this, SLOT(onOpenScriptFile()));
	layout->addWidget((btn = new QPushButton(tr("Run Script File"), panel)));
	connect(btn, SIGNAL(clicked(bool)), this, SLOT(onRunScriptFile()));
}

/******************************************************************************
* Removes the UI of the utility from the rollout container.
******************************************************************************/
void ScriptUtility::closeUtility(RolloutContainer* container)
{
	delete panel;
}

/******************************************************************************
* Handles the "Open New Editor" command event.
******************************************************************************/
void ScriptUtility::onNewEditor()
{
	// Open a new script editor frame.
	ScriptEditor* editor = new ScriptEditor(MAIN_FRAME);
	editor->show();
	editor->setFocus();
}

/******************************************************************************
* Handles the "Open Script File" command event.
******************************************************************************/
void ScriptUtility::onOpenScriptFile()
{
	// Open a new script editor frame.
	ScriptEditor* editor = new ScriptEditor(MAIN_FRAME);
	if(!editor->loadFile()) {
		delete editor;
		return;
	}
	editor->show();
}

/******************************************************************************
* Handles the "Run Script File" command event.
******************************************************************************/
void ScriptUtility::onRunScriptFile()
{
	// Open a new script editor frame.
	ScriptEditor* editor = new ScriptEditor(MAIN_FRAME);
	if(!editor->loadFile()) {
		delete editor;
		return;
	}
	editor->show();
	editor->executeScript();
}

};
