/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtSubsetsMetaData.h>
#include <DataNode.h>

//
// Enum conversion methods for avtSubsetsMetaData::PartialCellModes
//

static const char *PartialCellModes_strings[] = {
"Include", "Exclude", "Dissect"
};

std::string
avtSubsetsMetaData::PartialCellModes_ToString(avtSubsetsMetaData::PartialCellModes t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return PartialCellModes_strings[index];
}

std::string
avtSubsetsMetaData::PartialCellModes_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return PartialCellModes_strings[index];
}

bool
avtSubsetsMetaData::PartialCellModes_FromString(const std::string &s, avtSubsetsMetaData::PartialCellModes &val)
{
    val = avtSubsetsMetaData::Include;
    for(int i = 0; i < 3; ++i)
    {
        if(s == PartialCellModes_strings[i])
        {
            val = (PartialCellModes)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for avtSubsetsMetaData::DecompMode
//

static const char *DecompMode_strings[] = {
"None", "Cover", "Partition"
};

std::string
avtSubsetsMetaData::DecompMode_ToString(avtSubsetsMetaData::DecompMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return DecompMode_strings[index];
}

std::string
avtSubsetsMetaData::DecompMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return DecompMode_strings[index];
}

bool
avtSubsetsMetaData::DecompMode_FromString(const std::string &s, avtSubsetsMetaData::DecompMode &val)
{
    val = avtSubsetsMetaData::None;
    for(int i = 0; i < 3; ++i)
    {
        if(s == DecompMode_strings[i])
        {
            val = (DecompMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Init utility for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSubsetsMetaData::Init()
{
    isChunkCat = false;
    isMaterialCat = false;
    isUnionOfChunks = false;
    hasPartialCells = false;

    avtSubsetsMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Copy utility for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSubsetsMetaData::Copy(const avtSubsetsMetaData &obj)
{
    catName = obj.catName;
    catCount = obj.catCount;
    nameScheme = obj.nameScheme;
    colorScheme = obj.colorScheme;
    setsToChunksMaps = obj.setsToChunksMaps;
    graphEdges = obj.graphEdges;
    isChunkCat = obj.isChunkCat;
    isMaterialCat = obj.isMaterialCat;
    isUnionOfChunks = obj.isUnionOfChunks;
    hasPartialCells = obj.hasPartialCells;
    decompMode = obj.decompMode;
    maxTopoDim = obj.maxTopoDim;

    avtSubsetsMetaData::SelectAll();
}

// Type map format string
const char *avtSubsetsMetaData::TypeMapFormatString = AVTSUBSETSMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtSubsetsMetaData::TmfsStruct = {AVTSUBSETSMETADATA_TMFS};


// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Default constructor for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData::avtSubsetsMetaData() : 
    avtVarMetaData(avtSubsetsMetaData::TmfsStruct)
{
    avtSubsetsMetaData::Init();
}

// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData::avtSubsetsMetaData(private_tmfs_t tmfs) : 
    avtVarMetaData(tmfs)
{
    avtSubsetsMetaData::Init();
}

// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Copy constructor for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData::avtSubsetsMetaData(const avtSubsetsMetaData &obj) : 
    avtVarMetaData(obj,avtSubsetsMetaData::TmfsStruct)
{
    avtSubsetsMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSubsetsMetaData::avtSubsetsMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData::avtSubsetsMetaData(const avtSubsetsMetaData &obj, private_tmfs_t tmfs) : 
    avtVarMetaData(obj,tmfs)
{
    avtSubsetsMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtSubsetsMetaData::~avtSubsetsMetaData
//
// Purpose: 
//   Destructor for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData::~avtSubsetsMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtSubsetsMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSubsetsMetaData& 
avtSubsetsMetaData::operator = (const avtSubsetsMetaData &obj)
{
    if (this == &obj) return *this;

    // call the base class' assignment operator first
    avtVarMetaData::operator=(obj);

    avtSubsetsMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtSubsetsMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSubsetsMetaData::operator == (const avtSubsetsMetaData &obj) const
{
    // Create the return value
    return ((catName == obj.catName) &&
            (catCount == obj.catCount) &&
            (nameScheme == obj.nameScheme) &&
            (colorScheme == obj.colorScheme) &&
            (setsToChunksMaps == obj.setsToChunksMaps) &&
            (graphEdges == obj.graphEdges) &&
            (isChunkCat == obj.isChunkCat) &&
            (isMaterialCat == obj.isMaterialCat) &&
            (isUnionOfChunks == obj.isUnionOfChunks) &&
            (hasPartialCells == obj.hasPartialCells) &&
            (decompMode == obj.decompMode) &&
            (maxTopoDim == obj.maxTopoDim) &&
            avtVarMetaData::operator==(obj));
}

// ****************************************************************************
// Method: avtSubsetsMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSubsetsMetaData::operator != (const avtSubsetsMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtSubsetsMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtSubsetsMetaData::TypeName() const
{
    return "avtSubsetsMetaData";
}

// ****************************************************************************
// Method: avtSubsetsMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSubsetsMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtSubsetsMetaData *tmp = (const avtSubsetsMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtSubsetsMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSubsetsMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtSubsetsMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtSubsetsMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtSubsetsMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSubsetsMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtSubsetsMetaData(*this);
    else
        retval = new avtSubsetsMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtSubsetsMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSubsetsMetaData::SelectAll()
{
    // call the base class' SelectAll() first
    avtVarMetaData::SelectAll();
    Select(ID_catName,          (void *)&catName);
    Select(ID_catCount,         (void *)&catCount);
    Select(ID_nameScheme,       (void *)&nameScheme);
    Select(ID_colorScheme,      (void *)&colorScheme);
    Select(ID_setsToChunksMaps, (void *)&setsToChunksMaps);
    Select(ID_graphEdges,       (void *)&graphEdges);
    Select(ID_isChunkCat,       (void *)&isChunkCat);
    Select(ID_isMaterialCat,    (void *)&isMaterialCat);
    Select(ID_isUnionOfChunks,  (void *)&isUnionOfChunks);
    Select(ID_hasPartialCells,  (void *)&hasPartialCells);
    Select(ID_decompMode,       (void *)&decompMode);
    Select(ID_maxTopoDim,       (void *)&maxTopoDim);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
avtSubsetsMetaData::SetCatName(const std::string &catName_)
{
    catName = catName_;
    Select(ID_catName, (void *)&catName);
}

void
avtSubsetsMetaData::SetCatCount(int catCount_)
{
    catCount = catCount_;
    Select(ID_catCount, (void *)&catCount);
}

void
avtSubsetsMetaData::SetNameScheme(const NameschemeAttributes &nameScheme_)
{
    nameScheme = nameScheme_;
    Select(ID_nameScheme, (void *)&nameScheme);
}

void
avtSubsetsMetaData::SetSetsToChunksMaps(const intVector &setsToChunksMaps_)
{
    setsToChunksMaps = setsToChunksMaps_;
    Select(ID_setsToChunksMaps, (void *)&setsToChunksMaps);
}

void
avtSubsetsMetaData::SetGraphEdges(const intVector &graphEdges_)
{
    graphEdges = graphEdges_;
    Select(ID_graphEdges, (void *)&graphEdges);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
avtSubsetsMetaData::GetCatName() const
{
    return catName;
}

std::string &
avtSubsetsMetaData::GetCatName()
{
    return catName;
}

int
avtSubsetsMetaData::GetCatCount() const
{
    return catCount;
}

const NameschemeAttributes &
avtSubsetsMetaData::GetNameScheme() const
{
    return nameScheme;
}

NameschemeAttributes &
avtSubsetsMetaData::GetNameScheme()
{
    return nameScheme;
}

const intVector &
avtSubsetsMetaData::GetSetsToChunksMaps() const
{
    return setsToChunksMaps;
}

intVector &
avtSubsetsMetaData::GetSetsToChunksMaps()
{
    return setsToChunksMaps;
}

const intVector &
avtSubsetsMetaData::GetGraphEdges() const
{
    return graphEdges;
}

intVector &
avtSubsetsMetaData::GetGraphEdges()
{
    return graphEdges;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
avtSubsetsMetaData::SelectCatName()
{
    Select(ID_catName, (void *)&catName);
}

void
avtSubsetsMetaData::SelectNameScheme()
{
    Select(ID_nameScheme, (void *)&nameScheme);
}

void
avtSubsetsMetaData::SelectSetsToChunksMaps()
{
    Select(ID_setsToChunksMaps, (void *)&setsToChunksMaps);
}

void
avtSubsetsMetaData::SelectGraphEdges()
{
    Select(ID_graphEdges, (void *)&graphEdges);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtSubsetsMetaData::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtSubsetsMetaData::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_catName:          return "catName";
    case ID_catCount:         return "catCount";
    case ID_nameScheme:       return "nameScheme";
    case ID_colorScheme:      return "colorScheme";
    case ID_setsToChunksMaps: return "setsToChunksMaps";
    case ID_graphEdges:       return "graphEdges";
    case ID_isChunkCat:       return "isChunkCat";
    case ID_isMaterialCat:    return "isMaterialCat";
    case ID_isUnionOfChunks:  return "isUnionOfChunks";
    case ID_hasPartialCells:  return "hasPartialCells";
    case ID_decompMode:       return "decompMode";
    case ID_maxTopoDim:       return "maxTopoDim";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtSubsetsMetaData::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
avtSubsetsMetaData::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_catName:          return FieldType_string;
    case ID_catCount:         return FieldType_int;
    case ID_nameScheme:       return FieldType_att;
    case ID_colorScheme:      return FieldType_stringVector;
    case ID_setsToChunksMaps: return FieldType_intVector;
    case ID_graphEdges:       return FieldType_intVector;
    case ID_isChunkCat:       return FieldType_bool;
    case ID_isMaterialCat:    return FieldType_bool;
    case ID_isUnionOfChunks:  return FieldType_bool;
    case ID_hasPartialCells:  return FieldType_bool;
    case ID_decompMode:       return FieldType_enum;
    case ID_maxTopoDim:       return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: avtSubsetsMetaData::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
avtSubsetsMetaData::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_catName:          return "string";
    case ID_catCount:         return "int";
    case ID_nameScheme:       return "att";
    case ID_colorScheme:      return "stringVector";
    case ID_setsToChunksMaps: return "intVector";
    case ID_graphEdges:       return "intVector";
    case ID_isChunkCat:       return "bool";
    case ID_isMaterialCat:    return "bool";
    case ID_isUnionOfChunks:  return "bool";
    case ID_hasPartialCells:  return "bool";
    case ID_decompMode:       return "enum";
    case ID_maxTopoDim:       return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: avtSubsetsMetaData::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSubsetsMetaData::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const avtSubsetsMetaData &obj = *((const avtSubsetsMetaData*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_catName:
        {  // new scope
        retval = (catName == obj.catName);
        }
        break;
    case ID_catCount:
        {  // new scope
        retval = (catCount == obj.catCount);
        }
        break;
    case ID_nameScheme:
        {  // new scope
        retval = (nameScheme == obj.nameScheme);
        }
        break;
    case ID_colorScheme:
        {  // new scope
        retval = (colorScheme == obj.colorScheme);
        }
        break;
    case ID_setsToChunksMaps:
        {  // new scope
        retval = (setsToChunksMaps == obj.setsToChunksMaps);
        }
        break;
    case ID_graphEdges:
        {  // new scope
        retval = (graphEdges == obj.graphEdges);
        }
        break;
    case ID_isChunkCat:
        {  // new scope
        retval = (isChunkCat == obj.isChunkCat);
        }
        break;
    case ID_isMaterialCat:
        {  // new scope
        retval = (isMaterialCat == obj.isMaterialCat);
        }
        break;
    case ID_isUnionOfChunks:
        {  // new scope
        retval = (isUnionOfChunks == obj.isUnionOfChunks);
        }
        break;
    case ID_hasPartialCells:
        {  // new scope
        retval = (hasPartialCells == obj.hasPartialCells);
        }
        break;
    case ID_decompMode:
        {  // new scope
        retval = (decompMode == obj.decompMode);
        }
        break;
    case ID_maxTopoDim:
        {  // new scope
        retval = (maxTopoDim == obj.maxTopoDim);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtSubsetsMetaData::Print
//
//  Purpose: Print out subset meta-data object information.
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************

inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtSubsetsMetaData::Print(ostream &out, int indent) const
{
    size_t i;

    avtVarMetaData::Print(out, indent);

    Indent(out, indent);
    out << "catName =\"" << catName << "\"" << endl;

    Indent(out, indent);
    out << "catCount = " << catCount << endl;

    Indent(out, indent);
    out << "isChunkCat = " << isChunkCat << endl;

    Indent(out, indent);
    out << "isMaterialCat = " << isMaterialCat << endl;

    Indent(out, indent);
    out << "isUnionOfChunks = " << isUnionOfChunks << endl;

    Indent(out, indent);
    out << "hasPartialCells = " << hasPartialCells << endl;

    Indent(out, indent);
    out << "decompMode = " << DecompMode_ToString(decompMode) << endl;

    Indent(out, indent);
    out << "maxTopoDim = " << maxTopoDim << endl;

#if 0
    if (nameScheme.size() == 1)
    {
        Indent(out, indent);
        out << "nameScheme = \"" << nameScheme[0] << "\"" << endl;
    }
    else
    {
        Indent(out, indent);
        out << "nameScheme = ..." << endl;
        for (i = 0; i < 50 && i < catCount; i++)
        {
            Indent(out, indent+1);
            out << "set[" << i << "] has name \"" << nameScheme[i] << "\"";
            if (i < colorScheme.size())
                out << " and color \"" << colorScheme[i] << "\"";
            out << endl;
        }
        if (catCount >= 50)
        {
            if (catCount > 51)
            {
                Indent(out, indent+1); 
                out << "." << endl;
            }
            if (catCount > 52)
            {
                Indent(out, indent+1); 
                out << "." << endl;
            }
            if (catCount > 53)
            {
                Indent(out, indent+1); 
                out << "." << endl;
            }
            for (i = catCount-50; i < catCount; i++)
            {
                Indent(out, indent+1);
                out << "set[" << i << "] has name \"" << nameScheme[i] << "\"";
                if (i < colorScheme.size())
                    out << " and color \"" << colorScheme[i] << "\"";
                out << endl;
            }
        } 
    }
#endif

    if (setsToChunksMaps.size())
    {
        i = 0;
        while (i < setsToChunksMaps.size())
        {
            Indent(out, indent);
            out << "set[" << setsToChunksMaps[i++] << "] exists on chunks..." << endl;
            int n = setsToChunksMaps[i++];
            Indent(out, indent+1);
            for (int j = 0; j < n; j++, i++)
            {
                if (j == 0)
                    out << setsToChunksMaps[i];
                else
                    out << ", " << setsToChunksMaps[i];
                if (j == n-1)
                    out << endl;
            }
        }
    }

    if (graphEdges.size())
    {
        Indent(out, indent);
        out << "graphEdges..." << endl;
        for (i = 0; i < 100 && i < graphEdges.size(); i += 2)
        {
            Indent(out, indent+1);
            out << "set[" << graphEdges[2*i  ] << "] is parent of "
                   "set[" << graphEdges[2*i+1] << "]" << endl;
        }
        if (graphEdges.size() > 100)
        {
            if (graphEdges.size() > 102)
            {
               Indent(out, indent+1); 
               out << "." << endl;
            }
            if (graphEdges.size() > 104)
            {
               Indent(out, indent+1); 
               out << "." << endl;
            }
            if (graphEdges.size() > 106)
            {
               Indent(out, indent+1); 
               out << "." << endl;
            }
            for (i = graphEdges.size() - 100; i < graphEdges.size(); i += 2)
            {
                Indent(out, indent+1);
                out << "set[" << graphEdges[2*i  ] << "] is parent of "
                       "set[" << graphEdges[2*i+1] << "]" << endl;
            }
        }
    }
}

// ****************************************************************************
//  Method: avtSubsetsMetaData::AddGraphEdge
//
//  Purpose: Add an edge to the subset inclusion graph indicating that the
//  set identified at the 'tail' is the child of (e.g. contained in) the set
//  identified at the head.
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************

void
avtSubsetsMetaData::AddGraphEdge(int head, int tail)
{
    graphEdges.push_back(head);
    graphEdges.push_back(tail);
}

// ****************************************************************************
//  Method: avtSubsetsMetaData::SetChunksForSet
//
//  Purpose: Indicate which chunks a given set exists on.
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************

void avtSubsetsMetaData::SetChunksForSet(int setId, std::vector<int> &chunks)
{
    SetChunksForSet(setId, &chunks[0], (int) chunks.size());
}

// ****************************************************************************
//  Method: avtSubsetsMetaData constructor
//
//  Purpose: convenient constructor
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************
avtSubsetsMetaData::avtSubsetsMetaData(const char *catName, int catCount, int maxTopoDim)
    : avtVarMetaData(avtSubsetsMetaData::TmfsStruct)
{
    avtSubsetsMetaData::Init();
    this->catName = catName;
    this->catCount = catCount;
    this->maxTopoDim = maxTopoDim;
}

// ****************************************************************************
//  Method: avtSubsetsMetaData constructor
//
//  Purpose: convenient constructor
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************
avtSubsetsMetaData::avtSubsetsMetaData(const std::string &catName, int catCount, int maxTopoDim)
    : avtVarMetaData(avtSubsetsMetaData::TmfsStruct)
{
    *this = avtSubsetsMetaData(catName.c_str(), catCount, maxTopoDim);
}

// ****************************************************************************
//  Method: avtSubsetsMetaData::SetChunksForSet
//
//  Purpose: Indicate which chunks a given set exists on.
//
//  Programmer: Mark C. Miller
//  Creation:   August 18, 2009
// ****************************************************************************

void avtSubsetsMetaData::SetChunksForSet(int setId, const int *chunks, int len)
{
    setsToChunksMaps.push_back(setId);
    setsToChunksMaps.push_back(len);
    for (int i = 0; i < len; i++)
        setsToChunksMaps.push_back(chunks[i]);
}

