# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

# Follows PEP8

from core import models
from lib.reverse_translation import _t
from lib.openImage import open as open_image
from lib.imtools import has_transparency

MASK = 'http://photobatch.wikidot.com/local--files/action-mask/mask_torn.png'
MASKS = [MASK]
#---Pil


def init():
    global Image, ImageMath, imtools
    import Image
    import ImageMath
    from lib import imtools


def put_mask(image, mask, resample_mask, cache=None):
    if cache is None:
        cache = {}
    resample_mask = getattr(Image, resample_mask)
    id = mask + '_w%d_h%d' % image.size
    try:
        mask = cache[id]
    except KeyError:
        mask = cache[id] = open_image(mask).convert('L').resize(
                                image.size, resample_mask)
    if not has_transparency(image):
        image = image.convert('RGBA')
    else:
        if has_transparency(image):
            image = image.convert('RGBA')
        alpha = imtools.get_alpha(image)
        mask = (ImageMath.eval("convert(min(a, b), 'L')",
            a=alpha,
            b=mask))
    image.putalpha(mask)
    return image

#---Phatch


class Action(models.Action):
    """Apply a watermark with tiling, scaling and opacity"""

    label = _t('Mask')
    author = 'Stani'
    cache = True
    email = 'spe.stani.be@gmail.com'
    init = staticmethod(init)
    pil = staticmethod(put_mask)
    version = '0.1'
    tags = [_t('filter')]
    __doc__ = _t('Apply a transparency mask')

    def interface(self, fields):
        fields[_t('Mask')] = self.MaskFileField('Daisy')
        fields[_t('Resample Mask')] = self.ImageResampleField('antialias')

    icon = \
'x\xda\x01\xfa\x07\x05\xf8\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\
\x00\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\
\x08\x08|\x08d\x88\x00\x00\x07\xb1IDATh\x81\xd5\x99\x7fL[\xd7\x15\xc7\xbf\
\xf7\xbe\xe7g?\xdb\xd8\x06\x1b\x9eqL\xc0\x9d\x94&\r\r\x9a6-\x83\xb6S\x97?\
\x82T\xa5\x9a\xd2&lK\x1b\x08$\x83-\xd5\xb4\xae\xdd\xa6\xfc1m\x7fD\xda&%\xaaR\
eI\x13\x9a\x04X\xda,\x0bm\xaaf[\xd6\xa6\xea\x94\xa5K\xd6D\xa2\xdb\xdaf\x94\
\x84b(\x04b\xc06\x04\x1b\xffz\xef\xde\xfd\xc1\xf0 \xc1\xd8\x06\n\xf4\xf3\x97\
\x9f\xef\xb9\xf7|\xcf\xbd\xe7\xbew\xdfy\xc0\x17\x1c\xb2P\x03mo,\xaa\xf4\r\
\xfb\xceSB\xa2\x84\naJ\xe9\x1dB\x89\x9f\x122\x98k\xb5^$:\xf13\x81\xc1\xc7\
\x18\xf56\xd5}\xda\xbbP~\x17,\x80\xcd/\xe6\x9e\x0c\x06\x83O\x0b\xa2\x08\x81\
\x10\xa8\xaa\x06Q\'BQ\x14\x88\xa2x\xb7y\x18\xc0\r\x80\xff\xb3\xa9\xa6{\xe7L\
\xe3\xd5\x9ep\xaf\x0f\x99\xf1akU_d6\xbf\xd3F\xdez\xc6-\'|\xa1\xf5"\xc8\x03\
\x16\x9b-\xc4\x18\xac\x14\xb0q\x0e+!\x18=Q\xe3\xdd\x9bj UM|\x83\x12\x8a"\xb7\
\x1b\x84\xa4\x9d\x17\x13\x80/s\x10\xdbL\x8d[\x0e9\xf6\xf7\xf6\xdf~^6\x19\x87\
\xea\x8e{\x1e9\xb1\xd3\xdb\x91j\xa0\xa4\xa7o\xbd`9\x17\x8d\xc5\x1e\xb7\xe4\
\xe4\xc0 \xcb3\xcd\xda\xdf\x9aj\xbc\x8f\xa6\x1a\xa8\xf2\xd7\xfa\x84\xaai\xe2\
\xca\xa2\xa2t\xe2\x93\xc4\x13\t\x8c\x87\xc31\xbd\xa4\x7f\xc7`1>\xd7\xfcT\xd7\
\xcd-\x87\x1cG\xfc\xc3\xfe\x06\xce9\x00@\x96\x8d\tG\xae\xfd\xf1\x93\xf5\xbdo\
\xcf\x1a\xc0c\xfbL\x9f\xc8z\xfd\xfd\x16\xabuFg\x9a\x9a\x08\x04G\xeftRJ\x86\t\
\xc8\x80d\x10\xdf\xe5y\x96\xf3\xadU]\xa3\xf5\xa7V9:;;\x87D\x9d\x88\x15\xae\
\x15\x19\x070\x16\x1aCd<\x82\x82\x82\x02p\xce\xe3\xb1x\xec\xaao\xc0\xf7\x08\
\xe3l\x9a\x9d$I\xdcf\xb3\xef>\xb3{\xe0H\xca\x00\xb6\x1e\xce\x7f\xcfl2?\x9c\
\xcaY4\x1a\x85\xcf\xe7\xc3\xca\xe2\x95\xe0\x9c\x83i\x0c\xa2(2\x007\xb9\xc6n\
\xf5\xdf\x1e\xd8\xe0t:!\x08B\xc6\x01\x04G\x82\xb0\xe4X\x92}FGG\x11\x08\x04\
\x00\x00\xa2\xa8\x83$\xe90>>>q-\x88\xb0\xe5\xe5\xed}\xed\x99\xc1_L\x1d\x83N\
\xfe0\x9b\xcc\xdd\xe9\x1c\x9aL&\x10\x10PB\'S\x8c\x02\xb8\x9f\x81o`\x8cg%\x1e\
\x00\xe2\xb1\xf8\xb4\xfdb\xb5Z\xe1t:a4\x1a\x91\x9f\xef\x80\xa2(P\x9c\n\x04A\
\x80\xb3\xd0\tUK\xfc\xbc\xea\xb7\x8ei\xab\x90\x0c\x00\x9c\xf4\xcf\xe6L\xa04u\
#\xe7 \xe0Y\x89\x07\x00UU\xa1\xaa\xea\xb4\xffdY\x86\xa2(0\x18\x0c\x00\x00\
\xa3l\x84\xdb\xed\x86(\x8a\xc8\xb5\xda\x88\xde`hx\xea\x98\xab\x11|"{\x92;\
\x95\x13\xd6Of\xbb\xabR\n\x83l\x98\xb1\x89q\x06S\x8e9\xeb\x00$I\x82$Ii\xed\
\xe8\x94\xc9\x13u:\x00\xf8^\xedI\x8f>t\xc6[\x97\x0c\x80r\xda\xc7I\xeaY\x14(\
\x85Q6\xa6p \xc0j\x99y\xf3\xa7\x821\x06\xb39\xfb\xa0\x93pT\x9b\xc6=c\xa4\xfe\
\xe8}\xd6\xc1\xf1\xc0\xf3zY\xbf\xc1(\x1b\x1f\x9a\xfb\x88\xd9\x91PU\x88\xa2\
\x80YW==\x83bO\xe0\xd6\x90 \x08:\x93\xd9\xb4P\xda2Bw\xefs&{8y\x96\xeat\xba\
\x98\xa2(\x19\xe5\xe2\xa2B\xf0;L\x1c9f\x84\x13\xbc\xda\xb4\xa3\xeb\xf7T\xd5\
\xb4X \x18XDe\x99\xc19\xff@ \xecA\x0e\\\x9b\xa1\xb9;A\x85\xdd\x00@\x05*\xf8C\
\xa10b\xf1\xd8"K\x9c\x1d\x02\xfaSU#\x03R4\xf6M\x80\xbc1\xb5\x8dS\xd4\xbf\xfa\
t\xe7\x1d\x00\xa0T\xa0\xbd+\\.\xe8%\xfd\xd2(M\t_A\x08\xfdAcC\xffx\xb1\xb7k\
\x0b\x07\xff\r\x00\x15\xe0M\xcd\xdb\xbd\xefLZ\x91\xcd/\xe6\xbe\xc44\xf6\xfd<\
{\xde\x12\x8aM\xc9\xa0,\x1b\xbft\xb8\xeaz\x08\x00v\x1es\xe7\x1d\xdf\xd9\x17\
\x9c\xfa\xd4\xa4T\xc0\xc7\xb1x\x0c\xe0\xd9?I\x17\x81\x82\xf1H\xa4z\xf2\xe2\
\xf8\xae\xbe\xc0\xdd\x8f|*\x89\xba\x0fL&\x13\x90\xfe\x0c\xbf$\x10\xb0\'gk\
\x17\xd5<\xe9_\xa6\xb1\xe5)>\x13hkU_D\x10u\xb7\x96ZH*8\xc1\xcb\xb3\xb5\xff\
\xef\x94\xc4;\x17CL\xb6\x10\x82\xb7\x9a\xab\xbbO\xcff3\x11\x00A\xcaw\xce\xa5\
\x82\x03\x03T\xc4\x8etv\x14\x00\x08\xc7r[\x01\r\x8co;\xb6\xcd\xebKg8\xb1\x02\
|y\xad\x00\x07\xdf\xd7\\\xdb}1\x13[\n\x00\\\xd4\xe6\xbd\x02f\xc1\x01\xbbX\
\x02C\xd4\x89\xa8_\x07\xa6\xcd\xed\xceF\x80\xb6\xb0l\xfae\xa6\xf6\x14\x00BRN\
\'\x00mN\x1e\x01\x88\xc4\x80\x12\xf1a\x08!\x07"\xfa\x01\xdcQ\xfb0t;\x005,!\
\xcb7\xcd\x08%l{k\xd5\xf5x\xa6\x1d(\x00\xb4V]\x8fs`0K\xddIV\x1b*\xf1Q\xcf\
\xdf1\xac\xff7\x08!(P\x14h\x88`\xc0\xdf\x85\x98_\xc6]U\x92\xd9\xf8\xd9\xb1\
\xea\x9e\xf6l|\'_6\t\xf0\x1e\x80D6\x9d\x01\xc0\xa3/GG\x7f\x1b\xe2R\x00\x18q`\
\xb2RS\xe8*\x84\xd1d\xc0\xc0X;\xc2>\x02\xa6\xa6K)\xf2\x97\xa6j\xef\xa1l\xfd\
\'\x03h\xaa\xf1~\x1b\x1c\x17\xb3\xe8;\xc48\xfd\xaa]-=z\xf3\xe3\x9e\x1f\t9\
\xf8\xee(z\x9f\x89\xf4\x14\xb4\xb1\xb8\x08B\x08\xf2\xecv\xe8$\x1d\x86\xa2]\
\x18\xf6\x05\xa1\xa5N\xa9a\xceX\xdd\\J\x1b\xd3j%\x04\xc4\x9fyW\xfeQ\xcb\x8eO\
\xdb\xc6\xfa\xe8+\x15\xca\xf6\xe8\x7f^\xb2\xbd\xfe\xda\xb3\xbd\x87O\xbf\xf9~\
\xb9\xaf\xcd^\xab\x8e\x9a\x13\x04\x04\x85\x85\x85\xb0Xr@\xf5*\xfa\x03^$\x82\
\xf7\xa6\x14\x01\xabo\xae\xed\xbe\x9d\xad\xf8{\x02\x10%\xf1\x87\x9c\xe38\x80\
\xb4\xafh\x9c\xd3\x0f\x01`\xcf\x9e=\xffp:\x9d+GFF\x9c\x00\x806$\xde:\xf2~\
\xcb\xd5\xb3c\xebb\xfd\xf9}\x94\n\xb0\xdb\x1dp8\x1cp\xaf(D0\xf1\x19\xc2\x83\
\xffO)\xceq\xfcDM\xcf\x1b\xa9=e\x11@\xe3\xb6\x1b\xc3\xcd;\xbc\xbb\x8a\xbd\
\xde|J\xe8\x83\x84\xa3\x81pr\x1a\xc0\xd0=\x1di\xf2\xf8\xa1\xb5\xb7\xb7\x1fmh\
h\xd8\xeer\xb9&\xeb.\xfc\xc6\xc5\xee\x8eS\xfb\xae\xad\x1d\xefp\x9de\x89\x89\
\x8a\x1d\xa1\x14\xb2\xac\xc7Pd"\xa5X\xd8\xd0O5\xe9\xc7s\x15\x0fd\xfa}\x80\
\x83\xd4\xbd\xe2Y\xc58\xf9\n\xe5|-\x80"F\xf8\xf9)\xe7\x14r\xe0\xc0\x81\xe7.]\
\xbat\xf9\xec\xd9\xb3W15\xd3\xd7Bz\xec\xa1\xafW\xdbK\xc3\x87EkH\x07\x00\x81\
\x80\x1f\x8cqp\xbf\xbb\xfdO\x8d\xed\xeb1\x8c\xb1\xf9\x04\xb1 l\xdc\xb8\xd1t\
\xf0\xe0\xc1\x17l6\xdbL5\x7f\xb2jc\xc9\xeam\xbf\xfaZom\xcb}\xbc\xb6\xc5\xc3\
\xbf\xb3oM\\X%\xecB>\xe6Q\xdd\xba+\x85\xe6\xc3\x85\x0b\x17\xc2\x0e\x87#\xbaf\
\xcd\x9aU\xb8we\xf9\x8d\x0b\xdd\x1d\xa7\xf6O\xa4T\xdco\x8c_\xfe\xf3\xd0!-\
\xa6\xbd\x8b\xa1\xd4\xa5\x93E\xe5\xca\x95+\xf2\xb9s\xe7^.))Y\xbfu\xeb\xd6\
\xd4e\xea\xb5\x90\xb0\x12\x0f\xa0\x04\xab\x01dW\xce\xfe\x1c\xb1WTT\xbc]^^\
\xbe\xb9\xb8\xb8\xb80\x03{\x82\x05\xfc>7_HNN\xce\x9b\x82 \\\x93$\xe9I,\xa3Y\
\xcd\x88\xb2\xb2\xb2?\xba\\\xae \x80\x9f\x00p/\xb5\x9e\xacX\xb7n\xdd\xfe\xf2\
\xf2r\x0e\xe0\x0f\x00*\xb0\x807\x85\xcf\x1d\x8f\xc7\xb3q\xd3\xa6ML\xaf\xd7\
\x7f\x02\xa0\x06\x98\xdf\xedp\xb11WVV\x86\x15E\t\x03\xd8\x0b\xc0\x83e\xb4)\
\xd3RVVv\xb9\xb4\xb4\x94\x01h\xc1D\xea|\xa16\xae\xa0(J;\x80\xbf\x02x\x02\x80\
\xbc\xc4z\xe6D!\x80G\x01\xe4.\xb1\x8ey\xb1,r\xfe\xbf\xac\x8b\xb4L\xaa\xd1\
\xdf\x86\x00\x00\x00\x00IEND\xaeB`\x82\xd5\xb6\xd7\xb5'
