# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackendTlsProperties(Model):
    """Properties controlling TLS Certificate Validation.

    :param validate_certificate_chain: Flag indicating whether SSL certificate
     chain validation should be done when using self-signed certificates for
     this backend host. Default value: True .
    :type validate_certificate_chain: bool
    :param validate_certificate_name: Flag indicating whether SSL certificate
     name validation should be done when using self-signed certificates for
     this backend host. Default value: True .
    :type validate_certificate_name: bool
    """

    _attribute_map = {
        'validate_certificate_chain': {'key': 'validateCertificateChain', 'type': 'bool'},
        'validate_certificate_name': {'key': 'validateCertificateName', 'type': 'bool'},
    }

    def __init__(self, *, validate_certificate_chain: bool=True, validate_certificate_name: bool=True, **kwargs) -> None:
        super(BackendTlsProperties, self).__init__(**kwargs)
        self.validate_certificate_chain = validate_certificate_chain
        self.validate_certificate_name = validate_certificate_name
