# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .control_activity import ControlActivity


class ExecutePipelineActivity(ControlActivity):
    """Execute pipeline activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param type: Required. Constant filled by server.
    :type type: str
    :param pipeline: Required. Pipeline reference.
    :type pipeline: ~azure.mgmt.datafactory.models.PipelineReference
    :param parameters: Pipeline parameters.
    :type parameters: dict[str, object]
    :param wait_on_completion: Defines whether activity execution will wait
     for the dependent pipeline execution to finish. Default is false.
    :type wait_on_completion: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'pipeline': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'type': {'key': 'type', 'type': 'str'},
        'pipeline': {'key': 'typeProperties.pipeline', 'type': 'PipelineReference'},
        'parameters': {'key': 'typeProperties.parameters', 'type': '{object}'},
        'wait_on_completion': {'key': 'typeProperties.waitOnCompletion', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ExecutePipelineActivity, self).__init__(**kwargs)
        self.pipeline = kwargs.get('pipeline', None)
        self.parameters = kwargs.get('parameters', None)
        self.wait_on_completion = kwargs.get('wait_on_completion', None)
        self.type = 'ExecutePipeline'
