/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef FILTRATIONRULEEDITOR_H
#define FILTRATIONRULEEDITOR_H

#include <QDialog>

#include <QPushButton>
#include <QLabel>
#include <QTextEdit>
#include <QLineEdit>
#include <QCheckBox>
#include <QPushButton>
class FiltrationRule;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class FiltrationRuleEditor : public QDialog
{
  Q_OBJECT
  private:
    bool m_edited;
    FiltrationRule* m_rule;

    QLineEdit* m_nameEdit;
    QTextEdit* m_userNamesEdit;
    QTextEdit* m_compNamesEdit;
    QTextEdit* m_messageFilterEdit;
    QTextEdit* m_IPsEdit;
    QCheckBox* m_isRegExpChbx;

    QPushButton*   m_okBtn;
    QPushButton*   m_applyBtn;
    QPushButton*   m_cancelBtn;

  public:
    FiltrationRuleEditor(QWidget *parent = 0);
    ~FiltrationRuleEditor();

    void init(FiltrationRule*);

  public slots:
    void saveRule();
    void edited(){m_edited = true; m_applyBtn->setEnabled(true);}

};

#endif
