/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef TCPRECEIVERTHREAD_H
#define TCPRECEIVERTHREAD_H

#include "receiverthread.h"

#include <QTcpSocket>

#include "qchatsocket.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class TcpReceiverThread : public ReceiverThread
{
  Q_OBJECT
  private:
//     QTcpSocket* m_socket;
    QChatSocket* m_socket;

  public:
    TcpReceiverThread(QObject *parent = 0);
    ~TcpReceiverThread();

    void run();
    void changePort(quint16);
    int  readData(char*, uint);
    QTcpSocket* socket(){return m_socket->socket();}
    QAbstractSocket::SocketState state(){return m_socket->state();}

  public slots:
    void login(const QString&, const QHostAddress&, uint, const QString& = "");

  signals:
    /**
     *
     * @param  err_id id of error
     * 0: no errors
     * 1: cannot connect to server
     * 2: cannot login to server
     * @param  descr optional text description of error
     */
    void loginFinished(int err_id, const QString& descr = "");
    void disconnected();
};

#endif
