/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DISPATCHEVENT_H
#define DISPATCHEVENT_H
#include <QEvent>
#include "imageviewer.h"
#include <unistd.h>


/** dispatch events are used to communicate with the different threads */
enum dispatchEventType
{
	info = QEvent::User, //!< send when dsp stops running
	soundcardIdle, //!< send when soundcard stops running
	displayFFT,
  displaySync,
	syncDisp,				//!< synchro display event
	lineDisplay,				//!< display 1 line 
	eraseDisp,
	createMode,
  startImageRX,
	endImageRX,
	endImageTX,
	progressTX,
	verticalRetrace,
  syncLost,
	outOfSync,
	statusMsg,  	//!<  display status message
	closeWindows,
	callEditor,
  templatesChanged,
  editorFinished,
  changeRXFilter,
  startAutoRepeater,
  startRepeater,
  stopRxTx
};

class baseEvent: public QEvent
{
public:
  baseEvent(QEvent::Type t):QEvent(t) {doneIt=NULL;}
  void waitFor(bool *d) {doneIt=d;}
  void setDone()
    {
      if(doneIt!=NULL) *doneIt=TRUE;
    }
  QString description;
private:
  bool *doneIt;

 };

/**
	this event is send when the dspfunc thread stops running
*/
class infoEvent : public  baseEvent
{
public:
	/** create event */
	infoEvent(QString t):baseEvent( (QEvent::Type) info ), str(t)
	{
		description="infoEvent";
	}
	/** returns info string from the event */
  QString getStr() const { return str; }
private:
  QString str;
};

/**
	this event is send when the soundcard thread goes to idle
*/
class soundcardIdleEvent : public baseEvent
{
public:
	/** create event */
	soundcardIdleEvent():baseEvent( (QEvent::Type) soundcardIdle )
	 {
		{
			description=" soudcardIdleEvent";
		}
	 }
};


//class rxDataAvailableEvent : public baseEvent
//{
//public:
//	/** create event */
//	rxDataAvailableEvent(uint idx,uint numSamples):baseEvent( (QEvent::Type)rxData ), index(idx),len(numSamples) {}
//	/** returns length and pointer  from the event */
//  uint getIndex(uint &idx) const { idx=index; return len;}
	
//private:
//  uint index;
//	uint len;
//};


/**
  this event is send with teh sync quality info and the signal volume
*/
class displaySyncEvent : public baseEvent
{
public:
	/** create event */
	displaySyncEvent(uint s,uint v):baseEvent( (QEvent::Type) displaySync), sync(s), vol(v)
	{
		description=" displaySyncEvent";
	}
	/** returns length and pointer  from the event */
  void getInfo(uint &s,uint &v)  {s=sync; v=vol;}
	
private:
  uint sync;
  uint vol;
};

class statusMsgEvent : public baseEvent
{
public:
	/** create event */
	statusMsgEvent(QString t):baseEvent( (QEvent::Type)statusMsg ), str(t)
	{
		description="statusMsgEvent";
	}
	/** returns info string from the event */
  QString getStr() const { return str; }
private:
  QString str;
};

class lineDisplayEvent : public baseEvent
{
public:
	/** create event */
	lineDisplayEvent(uint lineNbr):baseEvent( (QEvent::Type)lineDisplay ), lineNumber(lineNbr)
	{
		description="lineDisplayEvent";
	}
	/** returns length and pointer  from the event */
 void getInfo(uint &lineNbr) const { lineNbr=lineNumber;}
	
private:
	uint lineNumber;
};

class eraseDisplayEvent : public baseEvent
{
public:
	/** create event */
	eraseDisplayEvent():baseEvent( (QEvent::Type)eraseDisp )
	{
		description="eraseDisplayEvent";
	}
};

class startAutoRepeaterEvent: public baseEvent
{
public:
  /** create event */
  startAutoRepeaterEvent():baseEvent( (QEvent::Type)startAutoRepeater )
  {
    description="startAutoRepeaterEvent";
  }
};

class startRepeaterEvent: public baseEvent
{
public:
  /** create event */
  startRepeaterEvent():baseEvent( (QEvent::Type)startRepeater )
  {
    description="startRepeaterEvent";
  }
};


class createModeEvent : public baseEvent
{
public:
	/** create event */
	createModeEvent(uint m,QString t):baseEvent( (QEvent::Type)createMode ), mode(m) ,str(t)
	{
		description="createModeEvent";
	}
	/** returns info string from the event */
  void getMode(uint &m,QString &s) const { m=mode;s=str; }
private:
	uint mode;
  QString str;
};

class startImageRXEvent : public baseEvent
{
public:
  /** create event */
  startImageRXEvent():baseEvent( (QEvent::Type)startImageRX )
  {
    description="startImageRXEvent";
  }

};

class endImageRXEvent : public baseEvent
{
public:
	/** create event */
	endImageRXEvent():baseEvent( (QEvent::Type)endImageRX )
	{
		description="endImageRXEvent";
	}
};

class endImageTXEvent : public baseEvent
{
public:
	/** create event */
	endImageTXEvent():baseEvent( (QEvent::Type)endImageTX )
	{
		description="endImageTXEvent";
	}
};

class verticalRetraceEvent : public baseEvent
{
public:
	/** create event */
	verticalRetraceEvent():baseEvent( (QEvent::Type) verticalRetrace )
	{
		description="verticalRetraceEvent";
	}
};

class syncLostEvent : public baseEvent
{
public:
  /** create event */
  syncLostEvent():baseEvent( (QEvent::Type) syncLost )
  {
    description="syncLostEvent";
  }
};



class outOfSyncEvent : public baseEvent
{
public:
	/** create event */
	outOfSyncEvent():baseEvent( (QEvent::Type)outOfSync )
	{
		description="outOfSyncEvent";
	}
};



class progressTXEvent : public baseEvent
{
public:
	/** create event */
	progressTXEvent(double tim):baseEvent( (QEvent::Type)progressTX ), txTime(tim)
	{
		description="progressTXEvent";
	}
	/** returns length and pointer  from the event */
 double getInfo() { return txTime;}
	
private:
  double txTime;
};

class closeWindowsEvent : public baseEvent
{
public:
	/** create event */
	closeWindowsEvent():baseEvent( (QEvent::Type)closeWindows)
	{
		description="closeWindowEvent";
	}
	/** returns length and pointer  from the event */
};



class callEditorEvent : public baseEvent
{
public:
	/** create event */
	callEditorEvent(imageViewer *iv,QString fn):baseEvent( (QEvent::Type) callEditor ), filename(fn),imviewer(iv)
	{
		description="callEditorEvent";
	}
	/** returns info string from the event */
  QString getFilename() const { return filename; }
	imageViewer *getImageViewer() { return imviewer; }
private:
  QString filename;
	imageViewer *imviewer;
};


class templatesChangedEvent : public baseEvent
{
public:
  /** create event */
  templatesChangedEvent():baseEvent( (QEvent::Type) templatesChanged )
  {
    description="templateChangeEvent";
  }
};

class editorFinishedEvent : public baseEvent
{
public:
	/** create event */
	editorFinishedEvent(bool b,QString fn):baseEvent( (QEvent::Type)editorFinished),ok(b),filename(fn)
	{
		description="editorFinishedEvent";
	}
	bool isOK() { return ok;}
	QString getFilename() const { return filename; }
	
private:
  bool ok;
  QString filename;

};


class displayFFTEvent : public baseEvent
{
public:
	/** create event */
	displayFFTEvent(short int *buf):baseEvent( (QEvent::Type)displayFFT),buffer(buf)
	{
		description="displayFFTEvent";
	}
	short int *data() { return buffer;}	
private:
  short int *buffer;

};

class filterRXChangedEvent: public baseEvent
{
  public:
    /** create event */
    filterRXChangedEvent(int fIndex):baseEvent( (QEvent::Type)changeRXFilter),filterIndex(fIndex)
    {
      description="filterChangedEvent";
    }
    int index() { return filterIndex;}
  private:
    int filterIndex;
  };

class stopRxTxEvent : public baseEvent
{
public:
	/** create event */
	stopRxTxEvent():baseEvent( (QEvent::Type)stopRxTx)
	{
		description="stopRxTxEvent";
	}
};

#endif
