% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmknnParam-class.R
\docType{class}
\name{KmknnParam}
\alias{KmknnParam}
\alias{KmknnParam-class}
\alias{show,KmknnParam-method}
\alias{KmknnParam_kmeans_args}
\title{The KmknnParam class}
\usage{
KmknnParam(..., distance = "Euclidean")
}
\arguments{
\item{...}{Arguments to be passed to \code{\link{kmeans}}.}

\item{distance}{A string specifying the distance metric to use.}
}
\value{
An instance of the KmknnParam class.
}
\description{
A class to hold parameters for the KMKNN algorithm for exact nearest neighbor identification.
}
\details{
The KmknnParam class holds any parameters associated with running the KMKNN algorithm.
Currently, this relates to tuning of the k-means step - see \code{\link{buildKmknn}} for details.

Users can get or set values from an KmknnParam object with the usual \code{[[} syntax.
All parameters listed in \code{...} are available via \code{x[['kmeans.args']]}.
}
\examples{
(out <- KmknnParam(iter.max=100))
out[['kmeans.args']]

}
\seealso{
\code{\link{buildKmknn}}, for the index construction.

\code{\link{findKmknn}} and related functions, for the actual search. 

\linkS4class{BiocNeighborParam}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
