% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reloo.R
\name{reloo.brmsfit}
\alias{reloo.brmsfit}
\alias{reloo.loo}
\alias{reloo}
\title{Compute exact cross-validation for problematic observations}
\usage{
\method{reloo}{brmsfit}(
  x,
  loo = NULL,
  k_threshold = 0.7,
  newdata = NULL,
  resp = NULL,
  check = TRUE,
  recompile = NULL,
  future_args = list(),
  ...
)

\method{reloo}{loo}(x, fit, ...)

reloo(x, ...)
}
\arguments{
\item{x}{An \R object of class \code{brmsfit} or \code{loo} depending
on the method.}

\item{loo}{An \R object of class \code{loo}. If \code{NULL},
brms will try to extract a precomputed \code{loo} object
from the fitted model, added there via \code{\link{add_criterion}}.}

\item{k_threshold}{The threshold at which Pareto \eqn{k}
estimates are treated as problematic. Defaults to \code{0.7}.
See \code{\link[loo:pareto-k-diagnostic]{pareto_k_ids}}
for more details.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{check}{Logical; If \code{TRUE} (the default), some checks
check are performed if the \code{loo} object was generated
from the \code{brmsfit} object passed to argument \code{fit}.}

\item{recompile}{Logical, indicating whether the Stan model should be
recompiled. This may be necessary if you are running \code{reloo} on
another machine than the one used to fit the model.}

\item{future_args}{A list of further arguments passed to
\code{\link[future:future]{future}} for additional control over parallel
execution if activated.}

\item{...}{Further arguments passed to
\code{\link{update.brmsfit}} and \code{\link{log_lik.brmsfit}}.}

\item{fit}{An \R object of class \code{brmsfit}.}
}
\value{
An object of the class \code{loo}.
}
\description{
Compute exact cross-validation for problematic observations for which
approximate leave-one-out cross-validation may return incorrect results.
Models for problematic observations can be run in parallel using the
\pkg{future} package.
}
\details{
Warnings about Pareto \eqn{k} estimates indicate observations
for which the approximation to LOO is problematic (this is described in
detail in Vehtari, Gelman, and Gabry (2017) and the
\pkg{\link[loo:loo-package]{loo}} package documentation).
If there are \eqn{J} observations with \eqn{k} estimates above
\code{k_threshold}, then \code{reloo} will refit the original model
\eqn{J} times, each time leaving out one of the \eqn{J}
problematic observations. The pointwise contributions of these observations
to the total ELPD are then computed directly and substituted for the
previous estimates from these \eqn{J} observations that are stored in the
original \code{loo} object.

By default, this method uses \code{sample_new_levels = "gaussian"}
  to sample parameter values for new grouping-factor levels (see also
  \code{\link{prepare_predictions}}). This default will fail for models with
  non-Gaussian group-level effects. In this case, we recommend setting
  \code{sample_new_levels = "uncertainty"}.
}
\section{Parallelization with multiple CPU cores}{


\pkg{brms} can make use of multiple CPU cores in parallel to speed
up computations in various ways. For efficient use of the
available resources it is recommended to only use parallelism to
an extend such that the available physical CPUs are not
oversubscribed. For example, when you have 8 CPU cores locally
available, then you may consider to run 4 chains with 2 threads
per chain for best performance if you happen to just run a single
model. In case you run a simulation study which requires to run
many times a given model, then neither chain nor within-chain
parallelization is advisable as the computational resources are
already exhausted by the simulation study and any further
parallelization beyond the simulation study itself will in fact
slow down the overall runtime. Please be aware that for
historical reasons the nomenclature of the arguments is possibly
confusing. The \code{cores} argument refers to running different
chains in parallel and the within-chain parallelization will
allocate for each chain as many threads as requested. The
requested threads therefore increase the use of overall CPUs in a
multiplicative way.

For more advanced parallelization (including beyond single model
fits), \pkg{brms} also integrates with the \pkg{future}
package. Importantly, this enables seamless integration with the
\pkg{mirai} parallelization framework through the use of the
\pkg{future.mirai} adapter. With \pkg{mirai} local and remote
machines can be used in a fully transparent manner to the
user. This includes the possibility to use large number of remote
machines running in the context of a computer cluster, which are
managed with queuing systems. Please refer to the section on
distributed computing of
\code{\link[mirai:daemons]{mirai::daemons}}.
}

\examples{
\dontrun{
fit1 <- brm(count ~ zAge + zBase * Trt + (1|patient),
            data = epilepsy, family = poisson())

# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))

# no more warnings after reloo
(reloo1 <- reloo(fit1, loo = loo1, chains = 1))
}

}
\seealso{
\code{\link{loo}}, \code{\link{kfold}}
}
