% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{na.interp}
\alias{na.interp}
\title{Interpolate missing values in a time series}
\usage{
na.interp(
  x,
  lambda = NULL,
  linear = (frequency(x) <= 1 || sum(!is.na(x)) <= 2 * frequency(x))
)
}
\arguments{
\item{x}{Time series.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{linear}{Should a linear interpolation be used.}
}
\value{
Time series
}
\description{
By default, uses linear interpolation for non-seasonal series. For seasonal series, a
robust STL decomposition is first computed. Then a linear interpolation is applied to the
seasonally adjusted data, and the seasonal component is added back.
}
\details{
A more general and flexible approach is available using \code{na.approx} in
the \CRANpkg{zoo} package.
}
\examples{

data(gold)
plot(na.interp(gold))

}
\seealso{
\code{\link[=tsoutliers]{tsoutliers()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
