% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revparse.r
\docType{methods}
\name{revparse_single}
\alias{revparse_single}
\alias{revparse_single,git_repository,character-method}
\title{Revparse}
\usage{
revparse_single(repo, revision)

\S4method{revparse_single}{git_repository,character}(repo, revision)
}
\arguments{
\item{repo}{The repository}

\item{revision}{The revision string, see
http://git-scm.com/docs/git-rev-parse.html#_specifying_revisions}
}
\value{
a \code{git_commit} or \code{git_tag} or \code{git_tree}
object
}
\description{
Find object specified by revision.
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "First commit message")

# Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
             con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Second commit message")

revparse_single(repo, "HEAD^")
}
}
\keyword{methods}
