% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbosity.R
\name{with_verbosity}
\alias{with_verbosity}
\alias{local_verbosity}
\title{Temporarily set verbosity for all requests}
\usage{
with_verbosity(code, verbosity = 1)

local_verbosity(verbosity, env = caller_env())
}
\arguments{
\item{code}{Code to execture}

\item{verbosity}{How much information to print? This is a wrapper
around \code{\link[=req_verbose]{req_verbose()}} that uses an integer to control verbosity:
\itemize{
\item \code{0}: no output
\item \code{1}: show headers
\item \code{2}: show headers and bodies
\item \code{3}: show headers, bodies, and curl status messages.
}

Use \code{\link[=with_verbosity]{with_verbosity()}} to control the verbosity of requests that
you can't affect directly.}

\item{env}{Environment to use for scoping changes.}
}
\value{
\code{with_verbosity()} returns the result of evaluating \code{code}.
\code{local_verbosity()} is called for its side-effect and invisibly returns
the previous value of the option.
}
\description{
\code{with_verbosity()} and \code{local_verbosity()} are useful for debugging httr2
code buried deep inside another package, because they allow you to change
the verbosity even when you don't have access to the request.

Both functions work by temporarily setting the \code{httr2_verbosity} option. You
can also control verbosity by setting the \code{HTTR2_VERBOSITY} environment
variable. This has lower precedence than the option, but can be more easily
changed outside of R.
}
\examples{
fun <- function() {
  request("https://httr2.r-lib.org") |> req_perform()
}
with_verbosity(fun())

fun <- function() {
  local_verbosity(2)
  # someotherpackage::fun()
}
}
