% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{TVbo}
\alias{TVbo}
\title{Sensory Assesment of B&O TVs}
\format{\describe{
\item{Assessor}{factor with 8 levels assessors.}
\item{TVset}{product factor with 3 levels.}
\item{Picture}{product factor with 4 levels.}
}
In addition the following 15 numeric (response) variables are the
characteristics on which the TV sets (products) are assessed:

Coloursaturation, Colourbalance, Noise, Depth, Sharpness, Lightlevel,
Contrast, Sharpnessofmovement, Flickeringstationary, Flickeringmovement,
Distortion, Dimglasseffect, Cutting, Flossyedges, Elasticeffect.}
\usage{
data(TVbo)
}
\description{
The TVbo dataset has kindly been made available by the Danish high-end
consumer electronics company
\href{https://www.bang-olufsen.com}{Bang & Olufsen}.
The main purpose was to assess 12 different TV sets (products) specified by
the two attributes Picture and TVset.
15 different response variables (characteristics of the
product) were assessed by a trained panel with 8 assessors.
}
\examples{

fm <- lmer(Coloursaturation ~ TVset + Picture + (1|Assessor:TVset) +
             (1|Assessor), data=TVbo)
ranova(fm)
anova(fm)

}
\keyword{datasets}
