% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_data.R
\name{plotly_data}
\alias{plotly_data}
\alias{groups.plotly}
\alias{ungroup.plotly}
\alias{group_by.plotly}
\alias{mutate.plotly}
\alias{do.plotly}
\alias{summarise.plotly}
\alias{arrange.plotly}
\alias{select.plotly}
\alias{filter.plotly}
\alias{distinct.plotly}
\alias{slice.plotly}
\alias{rename.plotly}
\alias{transmute.plotly}
\alias{group_by_.plotly}
\alias{mutate_.plotly}
\alias{do_.plotly}
\alias{summarise_.plotly}
\alias{arrange_.plotly}
\alias{select_.plotly}
\alias{filter_.plotly}
\alias{distinct_.plotly}
\alias{slice_.plotly}
\alias{rename_.plotly}
\alias{transmute_.plotly}
\title{Obtain data associated with a plotly graph}
\usage{
plotly_data(p, id = p$x$cur_data)

\method{groups}{plotly}(x)

\method{ungroup}{plotly}(x, ...)

\method{group_by}{plotly}(.data, ...)

\method{mutate}{plotly}(.data, ...)

\method{do}{plotly}(.data, ...)

\method{summarise}{plotly}(.data, ...)

\method{arrange}{plotly}(.data, ...)

\method{select}{plotly}(.data, ...)

\method{filter}{plotly}(.data, ...)

\method{distinct}{plotly}(.data, ...)

\method{slice}{plotly}(.data, ...)

\method{rename}{plotly}(.data, ...)

\method{transmute}{plotly}(.data, ...)

\method{group_by_}{plotly}(.data, ...)

\method{mutate_}{plotly}(.data, ...)

\method{do_}{plotly}(.data, ...)

\method{summarise_}{plotly}(.data, ...)

\method{arrange_}{plotly}(.data, ...)

\method{select_}{plotly}(.data, ...)

\method{filter_}{plotly}(.data, ...)

\method{distinct_}{plotly}(.data, ...)

\method{slice_}{plotly}(.data, ...)

\method{rename_}{plotly}(.data, ...)

\method{transmute_}{plotly}(.data, ...)
}
\arguments{
\item{p}{a plotly visualization.}

\item{id}{a character string or number referencing an "attribute layer".}

\item{x}{a plotly visualization.}

\item{...}{arguments passed onto the relevant method.}

\item{.data}{a plotly visualization.}
}
\description{
\code{plotly_data()} returns data associated with
a plotly visualization (if there are multiple data frames, by default,
it returns the most recent one).
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# use group_by() to define groups of visual markings
p <- txhousing \%>\%
  group_by(city) \%>\%
  plot_ly(x = ~date, y = ~sales)
p

# plotly objects preserve data groupings 
groups(p)
plotly_data(p)

# dplyr verbs operate on plotly objects as if they were data frames
p <- economics \%>\%
  plot_ly(x = ~date, y = ~unemploy / pop) \%>\%
  add_lines() \%>\%
  mutate(rate = unemploy / pop) \%>\% 
  filter(rate == max(rate))
plotly_data(p)
add_markers(p)
layout(p, annotations = list(x = ~date, y = ~rate, text = "peak"))

# use group_by() + do() + subplot() for trellis displays 
d <- group_by(mpg, drv)
plots <- do(d, p = plot_ly(., x = ~cty, name = ~drv))
subplot(plots[["p"]], nrows = 3, shareX = TRUE)

# arrange displays by their mean
means <- summarise(d, mn = mean(cty, na.rm = TRUE))
means \%>\%
  dplyr::left_join(plots) \%>\%
  arrange(mn) \%>\%
  subplot(nrows = NROW(.), shareX = TRUE)
  
# more dplyr verbs applied to plotly objects
p <- mtcars \%>\%
  plot_ly(x = ~wt, y = ~mpg, name = "scatter trace") \%>\%
  add_markers()
p \%>\% slice(1) \%>\% plotly_data()
p \%>\% slice(1) \%>\% add_markers(name = "first observation")
p \%>\% filter(cyl == 4) \%>\% plotly_data()
p \%>\% filter(cyl == 4) \%>\% add_markers(name = "four cylinders")

\dontshow{\}) # examplesIf}
}
