% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{formatSummarizedNumerics}
\alias{formatSummarizedNumerics}
\title{Reformat numeric summarize output as one column per variable,
similar to R summary}
\usage{
formatSummarizedNumerics(x, ...)
}
\arguments{
\item{x}{numeric summaries from summarize function}

\item{...}{Other arguments, such as digits}
}
\value{
An R \code{table} object
}
\description{
The summarizeNumeric function returns a data frame with the
variable names on the rows and summary statistics (mean, median,
std. deviation) in the columns.This transposes and abbreviates
the information to look more like R summary.
}
\examples{
set.seed(21234)
X <- matrix(rnorm(10000), ncol = 10, dimnames = list(NULL, paste0("xvar", 1:10)))
Xsum <- summarize(X)
Xsum$numerics
formatSummarizedNumerics(Xsum$numerics)
formatSummarizedNumerics(Xsum$numerics, digits = 5)
Xsum.fmt <- formatSummarizedNumerics(Xsum$numerics)
str(Xsum.fmt)
}
\author{
Paul Johnson
}
