% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactives.R
\name{reactive}
\alias{reactive}
\alias{is.reactive}
\title{Create a reactive expression}
\usage{
reactive(
  x,
  env = parent.frame(),
  quoted = FALSE,
  ...,
  label = NULL,
  domain = getDefaultReactiveDomain(),
  ..stacktraceon = TRUE
)

is.reactive(x)
}
\arguments{
\item{x}{For \code{is.reactive()}, an object to test. For \code{reactive()}, an
expression. When passing in a \code{\link[rlang:defusing-advanced]{rlang::quo()}}sure with \code{reactive()},
remember to use \code{\link[rlang:inject]{rlang::inject()}} to distinguish that you are passing in
the content of your quosure, not the expression of the quosure.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{x} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{x}
will be used when \code{x} is evaluated. If \code{x} is a quosure and you
would like to use its expression as a value for \code{x}, then you must set
\code{quoted} to \code{TRUE}.}

\item{...}{Not used.}

\item{label}{A label for the reactive expression, useful for debugging.}

\item{domain}{See \link{domains}.}

\item{..stacktraceon}{Advanced use only. For stack manipulation purposes; see
\code{\link[=stacktrace]{stacktrace()}}.}
}
\value{
a function, wrapped in a S3 class "reactive"
}
\description{
Wraps a normal expression to create a reactive expression. Conceptually, a
reactive expression is a expression whose result will change over time.
}
\details{
Reactive expressions are expressions that can read reactive values and call
other reactive expressions. Whenever a reactive value changes, any reactive
expressions that depended on it are marked as "invalidated" and will
automatically re-execute if necessary. If a reactive expression is marked as
invalidated, any other reactive expressions that recently called it are also
marked as invalidated. In this way, invalidations ripple through the
expressions that depend on each other.

See the \href{https://shiny.rstudio.com/tutorial/}{Shiny tutorial} for
more information about reactive expressions.
}
\examples{
library(rlang)
values <- reactiveValues(A=1)

reactiveB <- reactive({
  values$A + 1
})
# View the values from the R console with isolate()
isolate(reactiveB())
# 2

# To store expressions for later conversion to reactive, use quote()
myquo <- rlang::quo(values$A + 2)
# Unexpected value! Sending a quosure directly will not work as expected.
reactiveC <- reactive(myquo)
# We'd hope for `3`, but instead we get the quosure that was supplied.
isolate(reactiveC())

# Instead, the quosure should be `rlang::inject()`ed
reactiveD <- rlang::inject(reactive(!!myquo))
isolate(reactiveD())
# 3

# (Legacy) Can use quoted expressions
expr <- quote({ values$A + 3 })
reactiveE <- reactive(expr, quoted = TRUE)
isolate(reactiveE())
# 4

}
