// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from User.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.usermgmt {

  public class UserInfo : ICloneable {
    public object Clone() {
      UserInfo copy = new UserInfo();
      copy.enabled = this.enabled;
      copy.locked = this.locked;
      copy.blocked = this.blocked;
      copy.needPasswordChange = this.needPasswordChange;
      copy.auxInfo = this.auxInfo;
      copy.snmpV3Settings = this.snmpV3Settings;
      copy.sshPublicKey = this.sshPublicKey;
      copy.preferences = this.preferences;
      copy.roleIds = this.roleIds;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["locked"] = this.locked;
      json["blocked"] = this.blocked;
      json["needPasswordChange"] = this.needPasswordChange;
      json["auxInfo"] = this.auxInfo.Encode();
      json["snmpV3Settings"] = this.snmpV3Settings.Encode();
      json["sshPublicKey"] = this.sshPublicKey;
      json["preferences"] = this.preferences.Encode();
      json["roleIds"] = new JsonArray(this.roleIds.Select(
        _value => (JsonValue)(_value)));
      return json;
    }

    public static UserInfo Decode(LightJson.JsonObject json, Agent agent) {
      UserInfo inst = new UserInfo();
      inst.enabled = (bool)json["enabled"];
      inst.locked = (bool)json["locked"];
      inst.blocked = (bool)json["blocked"];
      inst.needPasswordChange = (bool)json["needPasswordChange"];
      inst.auxInfo = Com.Raritan.Idl.usermgmt.AuxInfo.Decode(json["auxInfo"], agent);
      inst.snmpV3Settings = Com.Raritan.Idl.usermgmt.SnmpV3Settings.Decode(json["snmpV3Settings"], agent);
      inst.sshPublicKey = (string)json["sshPublicKey"];
      inst.preferences = Com.Raritan.Idl.usermgmt.Preferences.Decode(json["preferences"], agent);
      inst.roleIds = new System.Collections.Generic.List<int>(json["roleIds"].AsJsonArray.Select(
        _value => (int)_value));
      return inst;
    }

    public bool enabled = false;
    public bool locked = false;
    public bool blocked = false;
    public bool needPasswordChange = false;
    public Com.Raritan.Idl.usermgmt.AuxInfo auxInfo = new Com.Raritan.Idl.usermgmt.AuxInfo();
    public Com.Raritan.Idl.usermgmt.SnmpV3Settings snmpV3Settings = new Com.Raritan.Idl.usermgmt.SnmpV3Settings();
    public string sshPublicKey = "";
    public Com.Raritan.Idl.usermgmt.Preferences preferences = new Com.Raritan.Idl.usermgmt.Preferences();
    public System.Collections.Generic.IEnumerable<int> roleIds = new System.Collections.Generic.List<int>();
  }
}
