#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
# latex2html cannot handle complex figures
# with latex and postcript combined, so
# wrap arround this by generating a 
# .dvi for this figure, and then .ps
# then, include this file in a simple .fig
# and re-rrun fig2dev
#
# author: Pierre.Saramito@imag.fr
#
arg=$1
#srcdir=$2
srcdir=`expr ${arg} : '\(.*\)/.*' \| "."`
filename=`expr ${arg} : '.*/\(.*\)' \| ${arg}`
basename=`expr ${filename} : '\(.*\).fig' \| ${filename}`
input=${srcdir}/${basename}.fig
builddir=`pwd`

#echo "SRCDIR=$srcdir" >&2
#echo "BUILDDIR=$builddir" >&2
#echo "FILENAME=$filename" >&2
#echo "BASENAME $basename"
#exit 0
tmp="tmp"

fig2dev -L pstex                          ${input} > ${tmp}-1-${basename}.ps
fig2dev -L pstex_t -p ${tmp}-1-${basename}.ps ${input} > ${tmp}-1-${basename}.tex

cat > ${tmp}-2-${basename}.tex << EOF2
\documentclass{article}
\usepackage{epsfig}
\usepackage{color}
\usepackage{amsbsy}
\usepackage{amsmath}
\usepackage{amsfonts}
\usepackage{amssymb}
\begin{document}
\input{${tmp}-1-${basename}.tex}
\thispagestyle{empty}
\end{document}
EOF2

latex ${tmp}-2-${basename}.tex
dvips -E -f ${tmp}-2-${basename}.dvi -o ${tmp}-2-${basename}.ps
ps2epsi ${tmp}-2-${basename}.ps ${tmp}-2-${basename}.eps
epstopdf ${tmp}-2-${basename}.eps
mv ${tmp}-2-${basename}.pdf ${basename}.pdf

/bin/rm -f tmp-1-${basename}.tex
/bin/rm -f tmp-1-${basename}.ps
/bin/rm -f tmp-2-${basename}.tex 
/bin/rm -f tmp-2-${basename}.aux
/bin/rm -f tmp-2-${basename}.log
/bin/rm -f tmp-2-${basename}.dvi
/bin/rm -f tmp-2-${basename}.ps
/bin/rm -f tmp-2-${basename}.eps

#if test x"$srcdir" != x""; then
#    builddir=`pwd`
#    cd $srcdir
#    dest=`pwd`
#    cd $builddir
#    if test $builddir != $dest; then
#        command="mv ${basename}.pdf $srcdir"
#        echo $command
#        eval $command
#    fi
#fi
