#ifndef _RHEOLEF_CONTAINER_TRAITS_H
#define _RHEOLEF_CONTAINER_TRAITS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// traits class for array<T>
//   for T=simple type
//    or T=index_set or pair_set, i.e. container type
// also says when T is a simple mpi_datatype or a container of mpi_datatype
// --------------------------------------------------------------------------
#include <boost/serialization/utility.hpp>
#include "rheolef/msg_util.h" // set_op<T1,T2>
#ifdef _RHEOLEF_HAVE_MPI
#include <boost/mpi/datatype.hpp>
#endif // _RHEOLEF_HAVE_MPI

namespace rheolef {
  template <class T>
  struct default_set_op {
    typedef set_op<T,T> type;
  };
  template<class T>
  struct is_container : boost::mpl::false_ {
    typedef boost::mpl::false_ type;
  };
#ifdef _RHEOLEF_HAVE_MPI
  template <class T>
  struct is_container_of_mpi_datatype : boost::mpl::false_ {
    typedef boost::mpl::false_ type;
  };
#endif // _RHEOLEF_HAVE_MPI
} // namespace rheolef
#endif // _RHEOLEF_CONTAINER_TRAITS_H

