
#line 1 "ragel/i18n/ru.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/ru.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 22, 23, 25, 27, 38, 
	39, 40, 42, 44, 49, 54, 59, 64, 
	68, 72, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 89, 94, 101, 106, 110, 116, 119, 
	121, 127, 138, 139, 141, 142, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 157, 158, 159, 160, 
	161, 162, 163, 165, 166, 167, 169, 170, 
	171, 172, 173, 174, 175, 176, 177, 178, 
	179, 180, 181, 182, 183, 184, 185, 186, 
	195, 206, 208, 219, 221, 224, 226, 228, 
	230, 232, 234, 236, 238, 240, 242, 244, 
	246, 248, 250, 252, 254, 256, 258, 260, 
	262, 264, 266, 268, 271, 273, 275, 277, 
	279, 281, 283, 285, 287, 289, 291, 293, 
	295, 297, 299, 301, 303, 305, 307, 309, 
	311, 313, 315, 317, 319, 321, 323, 325, 
	327, 330, 332, 334, 336, 338, 340, 342, 
	344, 346, 348, 350, 352, 354, 356, 358, 
	361, 363, 365, 367, 369, 371, 373, 375, 
	377, 379, 381, 383, 385, 387, 389, 391, 
	393, 395, 397, 399, 401, 403, 405, 407, 
	409, 411, 413, 415, 417, 419, 421, 423, 
	425, 427, 429, 431, 433, 435, 437, 439, 
	441, 443, 445, 447, 449, 452, 454, 456, 
	459, 461, 463, 465, 467, 469, 471, 473, 
	475, 477, 479, 482, 484, 486, 488, 490, 
	492, 494, 496, 498, 500, 502, 504, 506, 
	508, 510, 512, 514, 516, 518, 520, 522, 
	524, 525, 526, 527, 528, 529, 530, 531, 
	532, 533, 534, 535, 536, 537, 538, 540, 
	541, 543, 544, 545, 546, 547, 548, 549, 
	550, 551, 552, 553, 554, 555, 556, 557, 
	558, 559, 560, 561, 562, 563, 564, 565, 
	566, 567, 568, 569, 570, 577, 580, 582, 
	584, 586, 588, 590, 592, 594, 596, 598, 
	600, 602, 604, 606, 608, 610, 612, 614, 
	616, 618, 620, 622, 624, 626, 628, 630, 
	633, 635, 637, 639, 641, 643, 645, 647, 
	649, 650, 651, 652, 653, 654, 655, 657, 
	658, 659, 660, 661, 662, 663, 664, 665, 
	666, 667, 668, 669, 670, 671, 672, 673, 
	681, 686, 688, 690, 692, 694, 696, 698, 
	700, 702, 704, 706, 708, 710, 712, 714, 
	716, 718, 720, 722, 725, 727, 729, 731, 
	733, 735, 737, 739, 741, 743, 745, 747, 
	749, 751, 753, 755, 757, 759, 761, 763, 
	765, 767, 769, 771, 773, 776, 778, 780, 
	782, 784, 786, 788, 790, 792, 794, 796, 
	798, 800, 802, 805, 807, 809, 811, 813, 
	815, 817, 819, 821, 823, 825, 827, 829, 
	831, 833, 835, 837, 839, 841, 843, 845, 
	847, 849, 851, 853, 855, 857, 859, 861, 
	863, 865, 867, 869, 871, 873, 875, 877, 
	879, 881, 883, 885, 887, 889, 891, 893, 
	895, 897, 899, 902, 904, 906, 908, 910, 
	912, 914, 916, 918, 920, 922, 924, 926, 
	928, 930, 932, 934, 936, 938, 940, 942, 
	944, 946, 947, 948, 949, 950, 951, 952, 
	953, 954, 955, 956, 957, 958, 959, 960, 
	961, 962, 963, 964, 965, 966, 967, 968, 
	969, 970, 971, 972, 973, 974, 975, 976, 
	977, 978, 979, 980, 989, 1000, 1002, 1004, 
	1007, 1009, 1011, 1013, 1015, 1017, 1019, 1021, 
	1023, 1025, 1027, 1029, 1031, 1033, 1035, 1037, 
	1039, 1041, 1043, 1045, 1047, 1049, 1051, 1054, 
	1056, 1058, 1060, 1062, 1064, 1066, 1068, 1070, 
	1072, 1074, 1076, 1078, 1080, 1082, 1084, 1086, 
	1088, 1090, 1092, 1094, 1096, 1098, 1100, 1102, 
	1104, 1106, 1108, 1110, 1113, 1115, 1117, 1119, 
	1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 
	1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 
	1153, 1155, 1157, 1159, 1161, 1163, 1165, 1167, 
	1169, 1172, 1174, 1176, 1179, 1181, 1183, 1185, 
	1187, 1189, 1191, 1193, 1195, 1197, 1199, 1202, 
	1204, 1206, 1208, 1210, 1212, 1214, 1216, 1218, 
	1220, 1222, 1224, 1226, 1228, 1230, 1232, 1234, 
	1236, 1238, 1240, 1242, 1244, 1246, 1247, 1248, 
	1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 
	1257, 1258, 1259, 1260, 1261, 1270, 1281, 1283, 
	1285, 1288, 1290, 1292, 1294, 1296, 1298, 1300, 
	1302, 1304, 1306, 1308, 1310, 1312, 1314, 1316, 
	1318, 1320, 1322, 1324, 1326, 1328, 1330, 1332, 
	1335, 1337, 1339, 1342, 1344, 1346, 1348, 1350, 
	1352, 1354, 1356, 1358, 1360, 1362, 1364, 1366, 
	1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382, 
	1384, 1386, 1388, 1390, 1392, 1394, 1396, 1398, 
	1400, 1403, 1405, 1407, 1409, 1411, 1413, 1415, 
	1417, 1419, 1421, 1423, 1425, 1427, 1429, 1431, 
	1433, 1435, 1437, 1439, 1441, 1443, 1445, 1447, 
	1449, 1451, 1454, 1456, 1458, 1460, 1462, 1464, 
	1466, 1468, 1470, 1472, 1474, 1476, 1478, 1480, 
	1483, 1485, 1487, 1489, 1491, 1493, 1495, 1497, 
	1499, 1501, 1503, 1505, 1507, 1509, 1511, 1513, 
	1515, 1517, 1519, 1521, 1523, 1525, 1527, 1529, 
	1531, 1533, 1535, 1537, 1539, 1541, 1543, 1545, 
	1547, 1549, 1551, 1553, 1555, 1557, 1559, 1562, 
	1564, 1566, 1569, 1571, 1573, 1575, 1577, 1579, 
	1581, 1583, 1585, 1587, 1589, 1591, 1594, 1596, 
	1598, 1600, 1602, 1604, 1606, 1608, 1610, 1612, 
	1614, 1616, 1618, 1620, 1622, 1624, 1626, 1628, 
	1630, 1632, 1634, 1636, 1637, 1639, 1640, 1641, 
	1643, 1644, 1645, 1646, 1647, 1648, 1649, 1650, 
	1651, 1652, 1653, 1654, 1656, 1657, 1658, 1659, 
	1660, 1661, 1662, 1663, 1664, 1665, 1666
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -108, -107, -104, 
	-102, -99, -97, -95, -94, -92, 32, 10, 
	13, 10, 13, -48, 10, 32, 34, 35, 
	37, 42, 64, 124, 9, 13, 34, 34, 
	10, 13, 10, 13, 10, 32, 34, 9, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 9, 13, 10, 32, 9, 13, 
	10, 13, 10, 95, 70, 69, 65, 84, 
	85, 82, 69, 95, 69, 78, 68, 95, 
	37, 13, 32, 64, 9, 10, 9, 10, 
	13, 32, 64, 11, 12, 10, 32, 64, 
	9, 13, 32, 124, 9, 13, 10, 32, 
	92, 124, 9, 13, 10, 92, 124, 10, 
	92, 10, 32, 92, 124, 9, 13, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, -80, -66, -48, -67, -48, 
	-66, -48, -65, -47, -125, -47, -127, -47, 
	-126, -48, -72, -48, -68, -47, -127, -48, 
	-69, -48, -72, -48, 32, -66, -48, -77, 
	-67, -48, -76, -48, -80, -47, -126, -48, 
	-75, -48, -70, -47, -127, -47, -126, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -108, -107, -104, -102, 
	-99, -97, -95, -94, -92, 10, 10, 32, 
	-48, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, -48, 10, -80, -66, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-48, 10, -65, 10, -47, 10, -125, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -48, 10, -68, 10, 
	-47, 10, -127, 10, -48, 10, -69, 10, 
	-48, 10, -72, 10, -48, 10, 32, -66, 
	10, -48, 10, -77, 10, -48, 10, -76, 
	10, -48, 10, -80, 10, -47, 10, -126, 
	10, -48, 10, -66, 10, -48, 10, -68, 
	10, -47, 10, -125, 10, 10, 32, -48, 
	10, -74, 10, -48, 10, -75, 10, -47, 
	10, -125, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, -47, 10, -116, 10, -48, 
	-47, 10, -78, 10, -48, 10, -66, 10, 
	-48, 10, -71, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -48, 10, -78, 10, 
	-48, 10, -66, 10, 10, 58, -126, -122, 
	10, -47, 10, -128, 10, -47, 10, -125, 
	10, -48, 10, -70, 10, -47, 10, -126, 
	10, -47, 10, -125, 10, -47, 10, -128, 
	10, -48, 10, -80, 10, 10, 32, -47, 
	10, -127, 10, -47, 10, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, -48, 
	10, -80, -66, 10, -48, 10, -70, 10, 
	-48, 10, 32, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	-47, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -47, -126, -48, -66, 
	-48, -68, -47, -125, 32, -48, -74, -48, 
	-75, -47, -128, -125, -48, -75, -72, -48, 
	-76, -47, -117, -47, -127, -47, -126, -48, 
	-66, -47, -128, -48, -72, -47, -113, -48, 
	-68, -48, -75, -47, -128, -47, -117, 58, 
	10, 10, -48, 10, 32, 35, 124, 9, 
	13, -95, -92, 10, -48, 10, -78, 10, 
	-48, 10, -66, 10, -48, 10, -71, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -78, 10, -48, 10, -66, 10, 
	10, 58, -47, 10, -125, 10, -48, 10, 
	-67, 10, -48, 10, -70, 10, -47, 10, 
	-122, 10, -48, 10, -72, 10, -48, -47, 
	10, -66, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -48, 10, -69, 10, -113, 
	10, -47, -127, -47, -126, -47, -116, -48, 
	-47, -78, -48, -66, -48, -71, -47, -127, 
	-47, -126, -48, -78, -48, -66, 58, 10, 
	10, -48, 10, 32, 35, 37, 64, 9, 
	13, -102, -97, -95, -92, 10, -48, 10, 
	-66, 10, -48, 10, -67, 10, -47, 10, 
	-126, 10, -48, 10, -75, 10, -48, 10, 
	-70, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, 10, 58, -47, 10, -128, 10, 
	-48, 10, -75, -72, 10, -48, 10, -76, 
	10, -47, 10, -117, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -66, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -47, 10, -113, 10, -48, 10, -68, 
	10, -48, 10, -75, 10, -47, 10, -128, 
	10, -47, 10, -117, 10, -48, -47, 10, 
	-78, 10, -48, 10, -66, 10, -48, 10, 
	-71, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -48, 10, -78, 10, -48, 10, 
	-66, 10, -126, -122, 10, -47, 10, -128, 
	10, -47, 10, -125, 10, -48, 10, -70, 
	10, -47, 10, -126, 10, -47, 10, -125, 
	10, -47, 10, -128, 10, -48, 10, -80, 
	10, 10, 32, -47, 10, -127, 10, -47, 
	10, -122, 10, -48, 10, -75, 10, -48, 
	10, -67, 10, -48, 10, -80, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, -47, 
	10, -125, 10, -48, 10, -67, 10, -48, 
	10, -70, 10, -47, 10, -122, 10, -48, 
	10, -72, 10, -48, -47, 10, -66, 10, 
	-48, 10, -67, 10, -48, 10, -80, 10, 
	-48, 10, -69, 10, 10, 95, 10, 70, 
	10, 69, 10, 65, 10, 84, 10, 85, 
	10, 82, 10, 69, 10, 95, 10, 69, 
	10, 78, 10, 68, 10, 95, 10, 37, 
	-126, -122, -47, -128, -47, -125, -48, -70, 
	-47, -126, -47, -125, -47, -128, -48, -80, 
	32, -47, -127, -47, -122, -48, -75, -48, 
	-67, -48, -80, -47, -128, -48, -72, -47, 
	-113, 58, 10, 10, -48, 10, 32, 35, 
	37, 42, 64, 9, 13, -112, -108, -107, 
	-104, -102, -99, -97, -95, -94, -92, 10, 
	10, 32, -48, 10, -80, -66, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -48, 
	10, -65, 10, -47, 10, -125, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -72, 10, -48, 10, -68, 10, -47, 
	10, -127, 10, -48, 10, -69, 10, -48, 
	10, -72, 10, -48, 10, 32, -66, 10, 
	-48, 10, -77, 10, -48, 10, -76, 10, 
	-48, 10, -80, 10, -47, 10, -126, 10, 
	-48, 10, -66, 10, -48, 10, -68, 10, 
	-47, 10, -125, 10, 10, 32, -48, 10, 
	-74, 10, -48, 10, -75, 10, -47, 10, 
	-125, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -47, 10, -116, 10, -48, -47, 
	10, -78, 10, -48, 10, -66, 10, -48, 
	10, -71, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, -48, 10, -78, 10, -48, 
	10, -66, 10, 10, 58, -122, 10, -48, 
	10, -75, 10, -48, 10, -67, 10, -48, 
	10, -80, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -48, 10, -71, 10, -48, 
	10, -80, -66, 10, -48, 10, -70, 10, 
	-48, 10, 32, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	-47, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	-113, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -48, -75, 
	-48, -67, -48, -80, -47, -128, -48, -72, 
	-48, -71, 58, 10, 10, -48, 10, 32, 
	35, 37, 42, 64, 9, 13, -112, -108, 
	-107, -104, -102, -99, -97, -95, -94, -92, 
	10, 10, 32, -48, 10, -80, -66, 10, 
	-48, 10, -67, 10, -48, 10, -66, 10, 
	-48, 10, -65, 10, -47, 10, -125, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -72, 10, -48, 10, -68, 10, 
	-47, 10, -127, 10, -48, 10, -69, 10, 
	-48, 10, -72, 10, -48, 10, 32, -66, 
	10, -48, 10, -77, -67, 10, -48, 10, 
	-76, 10, -48, 10, -80, 10, -47, 10, 
	-126, 10, -48, 10, -75, 10, -48, 10, 
	-70, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, 10, 58, -47, 10, -126, 10, 
	-48, 10, -66, 10, -48, 10, -68, 10, 
	-47, 10, -125, 10, 10, 32, -48, 10, 
	-74, 10, -48, 10, -75, 10, -47, 10, 
	-128, -125, 10, -48, 10, -75, 10, -48, 
	10, -76, 10, -47, 10, -117, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -47, 
	10, -116, 10, -48, -47, 10, -78, 10, 
	-48, 10, -66, 10, -48, 10, -71, 10, 
	-47, 10, -127, 10, -47, 10, -126, 10, 
	-48, 10, -78, 10, -48, 10, -66, 10, 
	-126, -122, 10, -47, 10, -128, 10, -47, 
	10, -125, 10, -48, 10, -70, 10, -47, 
	10, -126, 10, -47, 10, -125, 10, -47, 
	10, -128, 10, -48, 10, -80, 10, 10, 
	32, -47, 10, -127, 10, -47, 10, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -47, 10, -128, 10, -48, 10, -72, 
	10, -48, 10, -71, 10, -48, 10, -80, 
	-66, 10, -48, 10, -70, 10, -48, 10, 
	32, -77, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	-47, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -80, -66, -48, 
	-70, -48, 32, -77, -47, -125, -48, -67, 
	-48, -70, -47, -122, -48, -72, -48, -47, 
	-66, -48, -67, -48, -80, -48, -69, -113, 
	-69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 10, 1, 2, 2, 9, 1, 
	1, 2, 2, 3, 3, 3, 3, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 3, 5, 3, 2, 4, 3, 2, 
	4, 9, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	11, 2, 9, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 5, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	5, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 7, 11, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 7, 11, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 2, 1, 1, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 0, 0, 
	1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 23, 25, 28, 31, 42, 
	44, 46, 49, 52, 57, 62, 67, 72, 
	76, 80, 83, 85, 87, 89, 91, 93, 
	95, 97, 99, 101, 103, 105, 107, 109, 
	111, 113, 118, 125, 130, 134, 140, 144, 
	147, 153, 164, 166, 169, 171, 173, 175, 
	177, 179, 181, 183, 185, 187, 189, 191, 
	193, 195, 197, 199, 201, 203, 205, 207, 
	209, 211, 213, 216, 218, 220, 223, 225, 
	227, 229, 231, 233, 235, 237, 239, 241, 
	243, 245, 247, 249, 251, 253, 255, 257, 
	266, 278, 281, 292, 295, 299, 302, 305, 
	308, 311, 314, 317, 320, 323, 326, 329, 
	332, 335, 338, 341, 344, 347, 350, 353, 
	356, 359, 362, 365, 369, 372, 375, 378, 
	381, 384, 387, 390, 393, 396, 399, 402, 
	405, 408, 411, 414, 417, 420, 423, 426, 
	429, 432, 435, 438, 441, 444, 447, 450, 
	453, 457, 460, 463, 466, 469, 472, 475, 
	478, 481, 484, 487, 490, 493, 496, 499, 
	503, 506, 509, 512, 515, 518, 521, 524, 
	527, 530, 533, 536, 539, 542, 545, 548, 
	551, 554, 557, 560, 563, 566, 569, 572, 
	575, 578, 581, 584, 587, 590, 593, 596, 
	599, 602, 605, 608, 611, 614, 617, 620, 
	623, 626, 629, 632, 635, 639, 642, 645, 
	649, 652, 655, 658, 661, 664, 667, 670, 
	673, 676, 679, 683, 686, 689, 692, 695, 
	698, 701, 704, 707, 710, 713, 716, 719, 
	722, 725, 728, 731, 734, 737, 740, 743, 
	746, 748, 750, 752, 754, 756, 758, 760, 
	762, 764, 766, 768, 770, 772, 774, 777, 
	779, 782, 784, 786, 788, 790, 792, 794, 
	796, 798, 800, 802, 804, 806, 808, 810, 
	812, 814, 816, 818, 820, 822, 824, 826, 
	828, 830, 832, 834, 836, 843, 847, 850, 
	853, 856, 859, 862, 865, 868, 871, 874, 
	877, 880, 883, 886, 889, 892, 895, 898, 
	901, 904, 907, 910, 913, 916, 919, 922, 
	926, 929, 932, 935, 938, 941, 944, 947, 
	950, 952, 954, 956, 958, 960, 962, 965, 
	967, 969, 971, 973, 975, 977, 979, 981, 
	983, 985, 987, 989, 991, 993, 995, 997, 
	1005, 1011, 1014, 1017, 1020, 1023, 1026, 1029, 
	1032, 1035, 1038, 1041, 1044, 1047, 1050, 1053, 
	1056, 1059, 1062, 1065, 1069, 1072, 1075, 1078, 
	1081, 1084, 1087, 1090, 1093, 1096, 1099, 1102, 
	1105, 1108, 1111, 1114, 1117, 1120, 1123, 1126, 
	1129, 1132, 1135, 1138, 1141, 1145, 1148, 1151, 
	1154, 1157, 1160, 1163, 1166, 1169, 1172, 1175, 
	1178, 1181, 1184, 1188, 1191, 1194, 1197, 1200, 
	1203, 1206, 1209, 1212, 1215, 1218, 1221, 1224, 
	1227, 1230, 1233, 1236, 1239, 1242, 1245, 1248, 
	1251, 1254, 1257, 1260, 1263, 1266, 1269, 1272, 
	1275, 1278, 1281, 1284, 1287, 1290, 1293, 1296, 
	1299, 1302, 1305, 1308, 1311, 1314, 1317, 1320, 
	1323, 1326, 1329, 1333, 1336, 1339, 1342, 1345, 
	1348, 1351, 1354, 1357, 1360, 1363, 1366, 1369, 
	1372, 1375, 1378, 1381, 1384, 1387, 1390, 1393, 
	1396, 1399, 1401, 1403, 1405, 1407, 1409, 1411, 
	1413, 1415, 1417, 1419, 1421, 1423, 1425, 1427, 
	1429, 1431, 1433, 1435, 1437, 1439, 1441, 1443, 
	1445, 1447, 1449, 1451, 1453, 1455, 1457, 1459, 
	1461, 1463, 1465, 1467, 1476, 1488, 1491, 1494, 
	1498, 1501, 1504, 1507, 1510, 1513, 1516, 1519, 
	1522, 1525, 1528, 1531, 1534, 1537, 1540, 1543, 
	1546, 1549, 1552, 1555, 1558, 1561, 1564, 1568, 
	1571, 1574, 1577, 1580, 1583, 1586, 1589, 1592, 
	1595, 1598, 1601, 1604, 1607, 1610, 1613, 1616, 
	1619, 1622, 1625, 1628, 1631, 1634, 1637, 1640, 
	1643, 1646, 1649, 1652, 1656, 1659, 1662, 1665, 
	1668, 1671, 1674, 1677, 1680, 1683, 1686, 1689, 
	1692, 1695, 1698, 1701, 1704, 1707, 1710, 1713, 
	1716, 1719, 1722, 1725, 1728, 1731, 1734, 1737, 
	1740, 1744, 1747, 1750, 1754, 1757, 1760, 1763, 
	1766, 1769, 1772, 1775, 1778, 1781, 1784, 1788, 
	1791, 1794, 1797, 1800, 1803, 1806, 1809, 1812, 
	1815, 1818, 1821, 1824, 1827, 1830, 1833, 1836, 
	1839, 1842, 1845, 1848, 1851, 1854, 1856, 1858, 
	1860, 1862, 1864, 1866, 1868, 1870, 1872, 1874, 
	1876, 1878, 1880, 1882, 1884, 1893, 1905, 1908, 
	1911, 1915, 1918, 1921, 1924, 1927, 1930, 1933, 
	1936, 1939, 1942, 1945, 1948, 1951, 1954, 1957, 
	1960, 1963, 1966, 1969, 1972, 1975, 1978, 1981, 
	1985, 1988, 1991, 1995, 1998, 2001, 2004, 2007, 
	2010, 2013, 2016, 2019, 2022, 2025, 2028, 2031, 
	2034, 2037, 2040, 2043, 2046, 2049, 2052, 2055, 
	2058, 2061, 2064, 2067, 2070, 2073, 2076, 2079, 
	2082, 2086, 2089, 2092, 2095, 2098, 2101, 2104, 
	2107, 2110, 2113, 2116, 2119, 2122, 2125, 2128, 
	2131, 2134, 2137, 2140, 2143, 2146, 2149, 2152, 
	2155, 2158, 2162, 2165, 2168, 2171, 2174, 2177, 
	2180, 2183, 2186, 2189, 2192, 2195, 2198, 2201, 
	2205, 2208, 2211, 2214, 2217, 2220, 2223, 2226, 
	2229, 2232, 2235, 2238, 2241, 2244, 2247, 2250, 
	2253, 2256, 2259, 2262, 2265, 2268, 2271, 2274, 
	2277, 2280, 2283, 2286, 2289, 2292, 2295, 2298, 
	2301, 2304, 2307, 2310, 2313, 2316, 2319, 2323, 
	2326, 2329, 2333, 2336, 2339, 2342, 2345, 2348, 
	2351, 2354, 2357, 2360, 2363, 2366, 2370, 2373, 
	2376, 2379, 2382, 2385, 2388, 2391, 2394, 2397, 
	2400, 2403, 2406, 2409, 2412, 2415, 2418, 2421, 
	2424, 2427, 2430, 2433, 2435, 2438, 2440, 2442, 
	2445, 2447, 2449, 2451, 2453, 2455, 2457, 2459, 
	2461, 2463, 2465, 2467, 2470, 2472, 2474, 2476, 
	2478, 2480, 2482, 2484, 2486, 2488, 2490
};

static const short _lexer_trans_targs[] = {
	2, 844, 6, 6, 7, 17, 19, 3, 
	33, 36, 6, 0, 3, 42, 60, 3, 
	66, 46, 253, 326, 819, 825, 0, 4, 
	0, 6, 18, 5, 6, 18, 5, 2, 
	6, 6, 7, 17, 19, 3, 33, 36, 
	6, 0, 8, 0, 9, 0, 11, 10, 
	10, 11, 10, 10, 12, 12, 13, 12, 
	12, 12, 12, 13, 12, 12, 12, 12, 
	14, 12, 12, 12, 12, 15, 12, 12, 
	6, 16, 16, 0, 6, 16, 16, 0, 
	6, 18, 17, 6, 0, 20, 0, 21, 
	0, 22, 0, 23, 0, 24, 0, 25, 
	0, 26, 0, 27, 0, 28, 0, 29, 
	0, 30, 0, 31, 0, 32, 0, 846, 
	0, 0, 0, 0, 0, 34, 35, 6, 
	35, 35, 33, 34, 34, 6, 35, 33, 
	35, 0, 36, 37, 36, 0, 41, 40, 
	39, 37, 40, 38, 0, 39, 37, 38, 
	0, 39, 38, 41, 40, 39, 37, 40, 
	38, 2, 41, 41, 7, 17, 19, 3, 
	33, 36, 41, 0, 43, 0, 44, 48, 
	0, 45, 0, 46, 0, 47, 0, 3, 
	0, 49, 0, 50, 0, 51, 0, 52, 
	0, 53, 0, 54, 0, 55, 0, 56, 
	0, 57, 0, 58, 0, 59, 0, 3, 
	0, 61, 0, 62, 0, 63, 0, 64, 
	0, 65, 0, 3, 0, 67, 240, 0, 
	68, 0, 69, 0, 70, 74, 0, 71, 
	0, 72, 0, 73, 0, 3, 0, 75, 
	0, 76, 0, 77, 0, 78, 0, 79, 
	0, 80, 0, 81, 0, 82, 0, 83, 
	0, 84, 0, 85, 0, 87, 86, 87, 
	86, 88, 87, 87, 6, 226, 89, 6, 
	87, 86, 89, 91, 109, 89, 115, 95, 
	136, 144, 203, 208, 87, 86, 87, 90, 
	86, 2, 6, 6, 7, 17, 19, 3, 
	33, 36, 6, 0, 92, 87, 86, 93, 
	97, 87, 86, 94, 87, 86, 95, 87, 
	86, 96, 87, 86, 89, 87, 86, 98, 
	87, 86, 99, 87, 86, 100, 87, 86, 
	101, 87, 86, 102, 87, 86, 103, 87, 
	86, 104, 87, 86, 105, 87, 86, 106, 
	87, 86, 107, 87, 86, 108, 87, 86, 
	89, 87, 86, 110, 87, 86, 111, 87, 
	86, 112, 87, 86, 113, 87, 86, 114, 
	87, 86, 89, 87, 86, 116, 87, 123, 
	86, 117, 87, 86, 118, 87, 86, 119, 
	87, 86, 120, 87, 86, 121, 87, 86, 
	122, 87, 86, 89, 87, 86, 124, 87, 
	86, 125, 87, 86, 126, 87, 86, 127, 
	87, 86, 128, 87, 86, 129, 87, 86, 
	130, 87, 86, 131, 87, 86, 87, 132, 
	86, 133, 87, 86, 134, 87, 86, 135, 
	87, 86, 89, 87, 86, 137, 87, 86, 
	138, 87, 86, 139, 87, 86, 140, 87, 
	86, 141, 87, 86, 142, 87, 86, 143, 
	87, 86, 89, 87, 86, 145, 159, 87, 
	86, 146, 87, 86, 147, 87, 86, 148, 
	87, 86, 149, 87, 86, 150, 87, 86, 
	151, 87, 86, 152, 87, 86, 153, 87, 
	86, 154, 87, 86, 155, 87, 86, 156, 
	87, 86, 157, 87, 86, 158, 87, 86, 
	87, 90, 86, 160, 191, 87, 86, 161, 
	87, 86, 162, 87, 86, 163, 87, 86, 
	164, 87, 86, 165, 87, 86, 166, 87, 
	86, 167, 87, 86, 168, 87, 86, 169, 
	87, 86, 170, 87, 86, 171, 87, 86, 
	172, 87, 86, 173, 87, 86, 174, 87, 
	86, 87, 175, 86, 176, 87, 86, 177, 
	87, 86, 178, 87, 86, 179, 87, 86, 
	180, 87, 86, 181, 87, 86, 182, 87, 
	86, 183, 87, 86, 184, 87, 86, 185, 
	87, 86, 186, 87, 86, 187, 87, 86, 
	188, 87, 86, 189, 87, 86, 190, 87, 
	86, 158, 87, 86, 192, 87, 86, 193, 
	87, 86, 194, 87, 86, 195, 87, 86, 
	196, 87, 86, 197, 87, 86, 198, 87, 
	86, 199, 87, 86, 200, 87, 86, 201, 
	87, 86, 202, 87, 86, 158, 87, 86, 
	204, 87, 86, 205, 207, 87, 86, 206, 
	87, 86, 132, 87, 86, 118, 87, 90, 
	86, 209, 87, 86, 210, 87, 86, 211, 
	87, 86, 212, 87, 86, 213, 87, 86, 
	214, 87, 86, 215, 87, 86, 216, 87, 
	86, 217, 87, 86, 218, 87, 86, 219, 
	190, 87, 86, 220, 87, 86, 221, 87, 
	86, 222, 87, 86, 223, 87, 86, 224, 
	87, 86, 225, 87, 86, 158, 87, 86, 
	87, 227, 86, 87, 228, 86, 87, 229, 
	86, 87, 230, 86, 87, 231, 86, 87, 
	232, 86, 87, 233, 86, 87, 234, 86, 
	87, 235, 86, 87, 236, 86, 87, 237, 
	86, 87, 238, 86, 87, 239, 86, 87, 
	6, 86, 241, 0, 242, 0, 243, 0, 
	244, 0, 245, 0, 246, 0, 247, 0, 
	248, 0, 249, 0, 250, 0, 251, 0, 
	252, 0, 3, 0, 254, 0, 255, 320, 
	0, 256, 0, 257, 273, 0, 258, 0, 
	259, 0, 260, 0, 261, 0, 262, 0, 
	263, 0, 264, 0, 265, 0, 266, 0, 
	267, 0, 268, 0, 269, 0, 270, 0, 
	271, 0, 272, 0, 84, 0, 274, 0, 
	275, 0, 276, 0, 277, 0, 278, 0, 
	279, 0, 280, 0, 281, 0, 282, 0, 
	284, 283, 284, 283, 285, 284, 284, 6, 
	6, 284, 283, 286, 301, 284, 283, 287, 
	284, 283, 288, 284, 283, 289, 284, 283, 
	290, 284, 283, 291, 284, 283, 292, 284, 
	283, 293, 284, 283, 294, 284, 283, 295, 
	284, 283, 296, 284, 283, 297, 284, 283, 
	298, 284, 283, 299, 284, 283, 300, 284, 
	283, 284, 90, 283, 302, 284, 283, 303, 
	284, 283, 304, 284, 283, 305, 284, 283, 
	306, 284, 283, 307, 284, 283, 308, 284, 
	283, 309, 284, 283, 310, 284, 283, 311, 
	284, 283, 312, 319, 284, 283, 313, 284, 
	283, 314, 284, 283, 315, 284, 283, 316, 
	284, 283, 317, 284, 283, 318, 284, 283, 
	300, 284, 283, 300, 284, 283, 321, 0, 
	322, 0, 323, 0, 324, 0, 325, 0, 
	3, 0, 327, 472, 0, 328, 0, 329, 
	0, 330, 0, 331, 0, 332, 0, 333, 
	0, 334, 0, 335, 0, 336, 0, 337, 
	0, 338, 0, 339, 0, 340, 0, 341, 
	0, 343, 342, 343, 342, 344, 343, 343, 
	6, 458, 6, 343, 342, 345, 360, 388, 
	440, 343, 342, 346, 343, 342, 347, 343, 
	342, 348, 343, 342, 349, 343, 342, 350, 
	343, 342, 351, 343, 342, 352, 343, 342, 
	353, 343, 342, 354, 343, 342, 355, 343, 
	342, 356, 343, 342, 357, 343, 342, 358, 
	343, 342, 359, 343, 342, 343, 90, 342, 
	361, 343, 342, 362, 343, 342, 363, 343, 
	342, 364, 380, 343, 342, 365, 343, 342, 
	366, 343, 342, 367, 343, 342, 368, 343, 
	342, 369, 343, 342, 370, 343, 342, 371, 
	343, 342, 372, 343, 342, 373, 343, 342, 
	374, 343, 342, 375, 343, 342, 376, 343, 
	342, 377, 343, 342, 378, 343, 342, 379, 
	343, 342, 359, 343, 342, 381, 343, 342, 
	382, 343, 342, 383, 343, 342, 384, 343, 
	342, 385, 343, 342, 386, 343, 342, 387, 
	343, 342, 359, 343, 342, 389, 402, 343, 
	342, 390, 343, 342, 391, 343, 342, 392, 
	343, 342, 393, 343, 342, 394, 343, 342, 
	395, 343, 342, 396, 343, 342, 397, 343, 
	342, 398, 343, 342, 399, 343, 342, 400, 
	343, 342, 401, 343, 342, 359, 343, 342, 
	403, 428, 343, 342, 404, 343, 342, 405, 
	343, 342, 406, 343, 342, 407, 343, 342, 
	408, 343, 342, 409, 343, 342, 410, 343, 
	342, 411, 343, 342, 412, 343, 342, 413, 
	343, 342, 414, 343, 342, 415, 343, 342, 
	416, 343, 342, 417, 343, 342, 343, 418, 
	342, 419, 343, 342, 420, 343, 342, 421, 
	343, 342, 422, 343, 342, 423, 343, 342, 
	424, 343, 342, 425, 343, 342, 426, 343, 
	342, 427, 343, 342, 374, 343, 342, 429, 
	343, 342, 430, 343, 342, 431, 343, 342, 
	432, 343, 342, 433, 343, 342, 434, 343, 
	342, 435, 343, 342, 436, 343, 342, 437, 
	343, 342, 438, 343, 342, 439, 343, 342, 
	359, 343, 342, 441, 343, 342, 442, 343, 
	342, 443, 343, 342, 444, 343, 342, 445, 
	343, 342, 446, 343, 342, 447, 343, 342, 
	448, 343, 342, 449, 343, 342, 450, 343, 
	342, 451, 379, 343, 342, 452, 343, 342, 
	453, 343, 342, 454, 343, 342, 455, 343, 
	342, 456, 343, 342, 457, 343, 342, 359, 
	343, 342, 343, 459, 342, 343, 460, 342, 
	343, 461, 342, 343, 462, 342, 343, 463, 
	342, 343, 464, 342, 343, 465, 342, 343, 
	466, 342, 343, 467, 342, 343, 468, 342, 
	343, 469, 342, 343, 470, 342, 343, 471, 
	342, 343, 6, 342, 473, 629, 0, 474, 
	0, 475, 0, 476, 0, 477, 0, 478, 
	0, 479, 0, 480, 0, 481, 0, 482, 
	0, 483, 0, 484, 0, 485, 0, 486, 
	0, 487, 0, 488, 0, 489, 0, 490, 
	0, 491, 0, 492, 0, 493, 0, 494, 
	0, 495, 0, 496, 0, 497, 0, 498, 
	0, 499, 0, 500, 0, 501, 0, 502, 
	0, 503, 0, 504, 0, 505, 0, 507, 
	506, 507, 506, 508, 507, 507, 6, 615, 
	509, 6, 507, 506, 509, 510, 528, 509, 
	534, 514, 555, 563, 591, 596, 507, 506, 
	507, 90, 506, 511, 507, 506, 512, 516, 
	507, 506, 513, 507, 506, 514, 507, 506, 
	515, 507, 506, 509, 507, 506, 517, 507, 
	506, 518, 507, 506, 519, 507, 506, 520, 
	507, 506, 521, 507, 506, 522, 507, 506, 
	523, 507, 506, 524, 507, 506, 525, 507, 
	506, 526, 507, 506, 527, 507, 506, 509, 
	507, 506, 529, 507, 506, 530, 507, 506, 
	531, 507, 506, 532, 507, 506, 533, 507, 
	506, 509, 507, 506, 535, 507, 542, 506, 
	536, 507, 506, 537, 507, 506, 538, 507, 
	506, 539, 507, 506, 540, 507, 506, 541, 
	507, 506, 509, 507, 506, 543, 507, 506, 
	544, 507, 506, 545, 507, 506, 546, 507, 
	506, 547, 507, 506, 548, 507, 506, 549, 
	507, 506, 550, 507, 506, 507, 551, 506, 
	552, 507, 506, 553, 507, 506, 554, 507, 
	506, 509, 507, 506, 556, 507, 506, 557, 
	507, 506, 558, 507, 506, 559, 507, 506, 
	560, 507, 506, 561, 507, 506, 562, 507, 
	506, 509, 507, 506, 564, 578, 507, 506, 
	565, 507, 506, 566, 507, 506, 567, 507, 
	506, 568, 507, 506, 569, 507, 506, 570, 
	507, 506, 571, 507, 506, 572, 507, 506, 
	573, 507, 506, 574, 507, 506, 575, 507, 
	506, 576, 507, 506, 577, 507, 506, 507, 
	90, 506, 579, 507, 506, 580, 507, 506, 
	581, 507, 506, 582, 507, 506, 583, 507, 
	506, 584, 507, 506, 585, 507, 506, 586, 
	507, 506, 587, 507, 506, 588, 507, 506, 
	589, 507, 506, 590, 507, 506, 577, 507, 
	506, 592, 507, 506, 593, 595, 507, 506, 
	594, 507, 506, 551, 507, 506, 537, 507, 
	90, 506, 597, 507, 506, 598, 507, 506, 
	599, 507, 506, 600, 507, 506, 601, 507, 
	506, 602, 507, 506, 603, 507, 506, 604, 
	507, 506, 605, 507, 506, 606, 507, 506, 
	607, 614, 507, 506, 608, 507, 506, 609, 
	507, 506, 610, 507, 506, 611, 507, 506, 
	612, 507, 506, 613, 507, 506, 577, 507, 
	506, 577, 507, 506, 507, 616, 506, 507, 
	617, 506, 507, 618, 506, 507, 619, 506, 
	507, 620, 506, 507, 621, 506, 507, 622, 
	506, 507, 623, 506, 507, 624, 506, 507, 
	625, 506, 507, 626, 506, 507, 627, 506, 
	507, 628, 506, 507, 6, 506, 630, 0, 
	631, 0, 632, 0, 633, 0, 634, 0, 
	635, 0, 636, 0, 637, 0, 638, 0, 
	639, 0, 640, 0, 641, 0, 642, 0, 
	644, 643, 644, 643, 645, 644, 644, 6, 
	805, 646, 6, 644, 643, 646, 647, 665, 
	646, 671, 651, 703, 729, 781, 787, 644, 
	643, 644, 90, 643, 648, 644, 643, 649, 
	653, 644, 643, 650, 644, 643, 651, 644, 
	643, 652, 644, 643, 646, 644, 643, 654, 
	644, 643, 655, 644, 643, 656, 644, 643, 
	657, 644, 643, 658, 644, 643, 659, 644, 
	643, 660, 644, 643, 661, 644, 643, 662, 
	644, 643, 663, 644, 643, 664, 644, 643, 
	646, 644, 643, 666, 644, 643, 667, 644, 
	643, 668, 644, 643, 669, 644, 643, 670, 
	644, 643, 646, 644, 643, 672, 644, 690, 
	643, 673, 644, 643, 674, 644, 643, 675, 
	679, 644, 643, 676, 644, 643, 677, 644, 
	643, 678, 644, 643, 646, 644, 643, 680, 
	644, 643, 681, 644, 643, 682, 644, 643, 
	683, 644, 643, 684, 644, 643, 685, 644, 
	643, 686, 644, 643, 687, 644, 643, 688, 
	644, 643, 689, 644, 643, 644, 90, 643, 
	691, 644, 643, 692, 644, 643, 693, 644, 
	643, 694, 644, 643, 695, 644, 643, 696, 
	644, 643, 697, 644, 643, 698, 644, 643, 
	644, 699, 643, 700, 644, 643, 701, 644, 
	643, 702, 644, 643, 646, 644, 643, 704, 
	644, 643, 705, 723, 644, 643, 706, 644, 
	643, 707, 644, 643, 708, 644, 643, 709, 
	644, 643, 710, 644, 643, 711, 644, 643, 
	712, 644, 643, 713, 644, 643, 714, 644, 
	643, 715, 644, 643, 716, 644, 643, 717, 
	644, 643, 718, 644, 643, 719, 644, 643, 
	720, 644, 643, 721, 644, 643, 722, 644, 
	643, 689, 644, 643, 724, 644, 643, 725, 
	644, 643, 726, 644, 643, 727, 644, 643, 
	728, 644, 643, 646, 644, 643, 730, 743, 
	644, 643, 731, 644, 643, 732, 644, 643, 
	733, 644, 643, 734, 644, 643, 735, 644, 
	643, 736, 644, 643, 737, 644, 643, 738, 
	644, 643, 739, 644, 643, 740, 644, 643, 
	741, 644, 643, 742, 644, 643, 689, 644, 
	643, 744, 769, 644, 643, 745, 644, 643, 
	746, 644, 643, 747, 644, 643, 748, 644, 
	643, 749, 644, 643, 750, 644, 643, 751, 
	644, 643, 752, 644, 643, 753, 644, 643, 
	754, 644, 643, 755, 644, 643, 756, 644, 
	643, 757, 644, 643, 758, 644, 643, 644, 
	759, 643, 760, 644, 643, 761, 644, 643, 
	762, 644, 643, 763, 644, 643, 764, 644, 
	643, 765, 644, 643, 766, 644, 643, 767, 
	644, 643, 768, 644, 643, 717, 644, 643, 
	770, 644, 643, 771, 644, 643, 772, 644, 
	643, 773, 644, 643, 774, 644, 643, 775, 
	644, 643, 776, 644, 643, 777, 644, 643, 
	778, 644, 643, 779, 644, 643, 780, 644, 
	643, 689, 644, 643, 782, 644, 643, 783, 
	785, 644, 643, 784, 644, 643, 699, 644, 
	643, 786, 644, 90, 643, 675, 644, 643, 
	788, 644, 643, 789, 644, 643, 790, 644, 
	643, 791, 644, 643, 792, 644, 643, 793, 
	644, 643, 794, 644, 643, 795, 644, 643, 
	796, 644, 643, 797, 644, 643, 798, 722, 
	644, 643, 799, 644, 643, 800, 644, 643, 
	801, 644, 643, 802, 644, 643, 803, 644, 
	643, 804, 644, 643, 689, 644, 643, 644, 
	806, 643, 644, 807, 643, 644, 808, 643, 
	644, 809, 643, 644, 810, 643, 644, 811, 
	643, 644, 812, 643, 644, 813, 643, 644, 
	814, 643, 644, 815, 643, 644, 816, 643, 
	644, 817, 643, 644, 818, 643, 644, 6, 
	643, 820, 0, 821, 823, 0, 822, 0, 
	249, 0, 824, 4, 0, 70, 0, 826, 
	0, 827, 0, 828, 0, 829, 0, 830, 
	0, 831, 0, 832, 0, 833, 0, 834, 
	0, 835, 0, 836, 843, 0, 837, 0, 
	838, 0, 839, 0, 840, 0, 841, 0, 
	842, 0, 340, 0, 340, 0, 845, 0, 
	6, 0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 43, 0, 
	43, 149, 126, 57, 110, 23, 0, 29, 
	54, 0, 5, 1, 0, 29, 1, 35, 
	0, 43, 0, 43, 0, 43, 139, 48, 
	9, 106, 11, 0, 134, 45, 45, 45, 
	3, 122, 33, 33, 33, 0, 122, 33, 
	33, 33, 0, 122, 33, 0, 33, 0, 
	102, 7, 7, 43, 54, 0, 0, 43, 
	114, 25, 0, 54, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 43, 43, 43, 43, 0, 27, 118, 
	27, 27, 51, 27, 0, 54, 0, 1, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 96, 54, 0, 93, 90, 41, 96, 
	90, 99, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 84, 54, 0, 72, 33, 84, 72, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 54, 0, 54, 15, 
	0, 63, 130, 31, 60, 57, 31, 63, 
	57, 66, 31, 43, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 15, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 15, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	15, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 81, 
	81, 0, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 21, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	69, 33, 69, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 13, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 13, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 84, 54, 0, 78, 33, 
	84, 78, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	54, 19, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	19, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	19, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 19, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 75, 
	33, 84, 75, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 17, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 17, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 17, 
	0, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 846;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/ru.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1675 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/ru.c.rl"
    
#line 1682 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/ru.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/ru.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/ru.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/ru.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/ru.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/ru.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/ru.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/ru.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/ru.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/ru.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/ru.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/ru.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/ru.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/ru.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1972 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 2035 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/ru.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ru()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ru", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

