/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file RTModules.h
    \author Romain BONDUE
    \date 19/08/2005 */
#ifndef __RTMODULES_H__
#define __RTMODULES_H__

#include <vector>
#include <string>
#include <memory> // std::auto_ptr<>

#include "Module.h"
#include "UserData.h"
#include "CWE17Module.h"
#include "ProfileEditor.h"
#include "WWidgets.h"
#include "RTDrivers.h"



namespace nsGUI
{
    class CGtkGUI;


    class CRT2500ConfigDialog : public CSharedConfigDialog
    {
      public :
        CRT2500ConfigDialog () throw();


      private :
        static void ModeChangedCallBack (::GtkToggleButton*,
                                         CRT2500ConfigDialog*) throw();

    }; // CRT2500ConfigDialog


    class CRTxxConfigDialog : public CSharedConfigDialog
    {
      public :
        CRTxxConfigDialog () throw();


      private :
        static void ModeChangedCallBack (::GtkToggleButton*, CRTxxConfigDialog*)
                                                                        throw();

    }; // CRTxxConfigDialog

} // namespace nsGUI



namespace nsCore
{
    class CRT2400CLIModule : public ICLIModule
    {
      public :
        CRT2400CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CRT2400CLIModule () throw();
        const nsUserData::CProfile& GetProfile (unsigned) const throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        unsigned GetNbProfile () const throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();


      private :
        CRT2400CLIModule (const CRT2400CLIModule&);
        CRT2400CLIModule& operator = (const CRT2400CLIModule&);

        nsWireless::CRT2400Driver m_Driver;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CRT2400CLIModule


    class CRT2400Module : public IModule
    {
      public :
        CRT2400Module (const std::string&, const std::string&)
                                 throw (nsErrors::CException, std::bad_alloc);
        ~CRT2400Module () throw();
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile (::GtkWindow*) throw();
        nsUserData::CProfile* NewProfile
                              (::GtkWindow*, const nsWireless::CCell&) throw();
        bool EditProfile (::GtkWindow*, unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        void ApplyProfile (unsigned, const nsWireless::CMacAddress&)
                                                throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void RecordProfiles () throw (nsErrors::CException);
        ::GtkWidget* GetPrivateTab () throw();


      protected :
        static const char* const NewProfileDefaultName;


      private :
        CRT2400Module (const CRT2400Module&);
        CRT2400Module& operator= (const CRT2400Module&);

        nsUserData::CProfile* EditNewProfile (::GtkWindow*) throw();

        std::auto_ptr<nsWireless::CRT2400Driver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CRT2400Module


    class CRTAdvancedCLIModule : public ICLIModule
    {
      public :
        ~CRTAdvancedCLIModule () throw();
        const nsUserData::CProfile& GetProfile (unsigned) const throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        unsigned GetNbProfile () const throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();


      protected :
        CRTAdvancedCLIModule (nsWireless::CRTAdvancedDriver*,
                              const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        nsUserData::CProfilesFile& GetProfilesFile () throw();
        const nsUserData::CProfilesFile& GetProfilesFile () const throw();


      private :
        CRTAdvancedCLIModule (const CRTAdvancedCLIModule&);
        CRTAdvancedCLIModule& operator = (const CRTAdvancedCLIModule&);

        std::auto_ptr<nsWireless::CRTAdvancedDriver> m_pDriver;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CRTAdvancedCLIModule


    class CRTAdvancedModule : public IModule
    {
      public :
        ~CRTAdvancedModule () throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile (::GtkWindow*) throw();
        nsUserData::CProfile* NewProfile
                              (::GtkWindow*, const nsWireless::CCell&) throw();
        bool EditProfile (::GtkWindow*, unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        void ApplyProfile (unsigned, const nsWireless::CMacAddress&)
                                                throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void RecordProfiles () throw (nsErrors::CException);
        ::GtkWidget* GetPrivateTab () throw();


      protected :
        CRTAdvancedModule (nsWireless::CRTAdvancedDriver*,
                           nsGUI::CConfigDialog*, const std::string&,
                           nsGUI::CGtkGUI*, bool AdHofdmSupport)
                                throw (nsErrors::CException, std::bad_alloc);
        void CreateCBox (const char* [], unsigned, int, const char*, unsigned,
                         void (*) (::GtkComboBox*, CRTAdvancedModule*)) throw();
        void CreateCheckButton (const char*, unsigned, unsigned, bool,
                            void (*) (::GtkToggleButton*, CRTAdvancedModule*))
                                                                    throw();
        void SetDriver (nsWireless::CRTAdvancedDriver*) throw();

        nsUserData::CProfilesFile& GetProfilesFile () throw();
        const nsUserData::CProfilesFile& GetProfilesFile () const throw();
        static const char* const NewProfileDefaultName;
        CProfileEditor& GetProfileEditor () throw();
        const CProfileEditor& GetProfileEditor () const throw();
        nsUserData::CProfile* EditNewProfile (::GtkWindow*) throw();


      private :
        CRTAdvancedModule (const CRTAdvancedModule&);
        CRTAdvancedModule& operator= (const CRTAdvancedModule&);

        std::auto_ptr<nsWireless::CRTAdvancedDriver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile m_ProfilesFile;

            // Private tab :
        ::GtkTable* const m_pTable;
        nsGUI::CGtkGUI* const m_pUI;
        unsigned m_CurrentActiveBoxItem;
        bool m_IsSkipped;

        typedef void (nsWireless::CRTAdvancedDriver::*DriverCBoxMember_t) (int);
        void CommonCBoxCallBack (DriverCBoxMember_t, ::GtkComboBox*) throw();

        typedef void (nsWireless::CRTAdvancedDriver::*DriverButtonMember_t)
                                                                        (bool);
        void CommonCButtonCallBack (DriverButtonMember_t,
                                    ::GtkToggleButton*) throw();
        void ResumePreviousState (::GtkComboBox*) throw();

        static void ModeCallBack (::GtkComboBox*, CRTAdvancedModule*) throw();
        static void BGProtectionCallBack (::GtkComboBox*, CRTAdvancedModule*)
                                                                    throw();
        static void TxPreambleCallBack (::GtkComboBox*, CRTAdvancedModule*)
                                                                    throw();
        static void TxBurstCallBack (::GtkToggleButton*, CRTAdvancedModule*)
                                                                    throw();
        static void TurboRateCallBack (::GtkToggleButton*, CRTAdvancedModule*)
                                                                    throw();
        static void AdHocOFDMCallBack (::GtkToggleButton*, CRTAdvancedModule*)
                                                                    throw();
        static void RfmontxCallBack (::GtkToggleButton*, CRTAdvancedModule*)
                                                                    throw();
        static void CBoxFocusCallBack (::GtkComboBox*, bool, CRTAdvancedModule*)
                                                                    throw();

    }; // CRTAdvancedModule


    class CRT2500CLIModule : public CRTAdvancedCLIModule
    {
      public :
        CRT2500CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);

    }; // CRT2500CLIModule


    class CRT2500Module : public CRTAdvancedModule
    {
      public :
        CRT2500Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);
        nsUserData::CProfile* NewProfile
                              (::GtkWindow*, const nsWireless::CCell&) throw();

    }; // CRT2500Module


    class CRT61CLIModule : public CRTAdvancedCLIModule
    {
      public :
        CRT61CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);

    }; // CRT61LIModule


    class CRT61Module : public CRTAdvancedModule
    {
      public :
        CRT61Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);

    }; // CRT61Module


    class CRT73Module : public CRTAdvancedModule
    {
      public :
        CRT73Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);

    }; // CRT73Module


    class CRT73CLIModule : public CRTAdvancedCLIModule
    {
      public :
        CRT73CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);

    }; // CRT73LIModule


    class CRT2570CLIModule : public ICLIModule
    {
      public :
        CRT2570CLIModule (const std::string&, const std::string&)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CRT2570CLIModule () throw();
        const nsUserData::CProfile& GetProfile (unsigned) const throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        unsigned GetNbProfile () const throw();
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();


      private :
        CRT2570CLIModule (const CRT2570CLIModule&);
        CRT2570CLIModule& operator = (const CRT2570CLIModule&);

        nsWireless::CRT2570Driver m_Driver;
        nsUserData::CProfilesFile m_ProfilesFile;

    }; // CRT2570CLIModule


    class CRT2570Module : public IModule
    {
      public :
        CRT2570Module (const std::string&, const std::string&, nsGUI::CGtkGUI*)
                                throw (nsErrors::CException, std::bad_alloc);
        ~CRT2570Module () throw();
        void BecomeRoot () throw (nsErrors::CException, std::bad_alloc);
        nsWireless::IDriver& GetDriver () throw();
        const nsWireless::IDriver& GetDriver () const throw();
        nsUserData::CProfile* NewProfile (::GtkWindow*) throw();
        nsUserData::CProfile* NewProfile
                              (::GtkWindow*, const nsWireless::CCell&) throw();
        bool EditProfile (::GtkWindow*, unsigned) throw();
        void DeleteProfile (unsigned) throw();
        void ApplyProfile (unsigned) throw (nsErrors::CSystemExc);
        void ApplyProfile (unsigned, const nsWireless::CMacAddress&)
                                                throw (nsErrors::CSystemExc);
        nsUserData::CProfile& GetProfile (unsigned) throw();
        unsigned GetNbProfile () const throw();
        void RecordProfiles () throw (nsErrors::CException);
        ::GtkWidget* GetPrivateTab () throw();


      protected :
        static const char* const NewProfileDefaultName;
        void BuildPrivateTab () throw();


      private :
        CRT2570Module (const CRT2570Module&);
        CRT2570Module& operator= (const CRT2570Module&);

        nsUserData::CProfile* EditNewProfile (::GtkWindow*) throw();

        std::auto_ptr<nsWireless::CRT2570Driver> m_pDriver;
        CProfileEditor m_ProfileEditor;
        nsUserData::CProfilesFile m_ProfilesFile;
        nsGUI::CGtkGUI* const m_pUI;

            // Private tab :
        ::GtkBox* const m_pBox;
        unsigned m_CurrentActiveBoxItem;
        bool m_IsSkipped;

        typedef void (nsWireless::CRT2570Driver::*DriverButtonMember_t) (bool);
        void CommonCButtonCallBack (DriverButtonMember_t,
                                    ::GtkToggleButton*) throw();
        typedef void (nsWireless::CRT2570Driver::*DriverBoxMember_t) (int);
        void CommonCBoxCallBack (DriverBoxMember_t, ::GtkComboBox*) throw();
        void ResumePreviousState (::GtkComboBox*) throw();

        static void AdhocModeCallBack (::GtkComboBox*, CRT2570Module*) throw();
        static void PrismHeaderCallBack (::GtkComboBox*, CRT2570Module*)
                                                                    throw();
        static void RfmontxCallBack (::GtkToggleButton*, CRT2570Module*)
                                                                    throw();
        static void CBoxFocusCallBack (::GtkComboBox*, bool, CRT2570Module*)
                                                                    throw();

    }; // CRT2570Module

} // namespace nsCore

#include "private/RTModules.hxx"

#endif // __RTMODULES_H__
