#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-24 07:46:04  
# conf/join-domain.sh 

### P A R A MS
MYVERBOSE=
redirection='> /dev/null'
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	redirection=
	shift
fi
MYREALM="$1"
MYADMIN="$2"
MYADMINPWD="$3"
MYOU="$4"
# organizational unit to put computer in
#echo "realm=${MYREALM}"
#echo "ou=${MYOU}"
#echo "admin=${MYADMIN}"
#echo "admin password=${MYADMINPWD}"

### I N C L U D E S
. ./_include.sh

### S T A R T

function dokinit()
{
	if echo "${MYADMINPWD}" | ${KINIT} ${MYADMIN}@${MYREALM} > /dev/null; then
		echo "kerberos authentication of ${MYADMIN}@${MYREALM} succeeded"
		return 0
	else
		echo "kerberos authentication of ${MYADMIN}@${MYREALM} failed"
		return 1
	fi
}

function indomain()
{
	echo "+test domain membership"
	e="net ads testjoin 2>&1  ${redirection}"
	if eval ${e}; then
		echo "in domain"
		return 0
	else
		echo "not in domain"
		return 1
	fi
}

# different net ads join OU syntax as of 3.0.23
echo "+get current samba version for join domain syntax"
sambapkg="${SAMBAPKG}"
sambaversion=`${PACKAGEVERSION} ${sambapkg} | sed 's/^[^:]://'`
sambamajorversion=`echo "${sambaversion}" | sed 's/^\([0-9]\).*$/\1/g'`
sambaminorversion=`echo "${sambaversion}" | sed 's/^[0-9]*\.[0-9]*\.\([0-9]*\).*$/\1/g'`
echo "samba minor version is ${sambaminorversion}"
if (( $((sambaminorversion)) < 23 )); then
	ouswitch=
else
	ouswitch=createcomputer=
fi
#echo "ouswitch=${ouswitch}"
#echo net ads join ${ouswitch}"${MYOU}"

# J O I N   D O M A I N
#echo "+get administrator credentials"
#if ! dokinit; then
#	exit 1
#fi

if [ ! -z "${MYOU}" ]; then
	echo "+join domain to ${MYOU}"
	joinparam="${ouswitch}\"${MYOU}\""
else 
	echo "+join domain"
	joinparam=
fi

e="net ads join ${joinparam} -U '${MYADMIN}%${MYADMINPWD}' ${redirection}"
#echo $e
if eval ${e} ; then
	echo "join succeeded"
else
	echo "join failed and returned $?"
	exit 2
fi

# T E S T
if indomain; then
	echo "join is ok"
else
	exit 3
fi
exit 0
