#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:42:04 
# install-pam.sh
# shell main install entry point

# P A R S E   C O M M A N D   L I N E
hasfile=
oprev=
for o ;do
	# if the previous option needs an argument, assign it.
  	if [ -n "${oprev}" ]; then
		eval "${oprev}=\${o}"
		oprev=
 		continue
 	fi

  	case "${o}" in
		-f) 
			oprev=file 
			hasfile=true 
		;;
	esac
done
if [ ! -z "${hasfile}" ]; then
	[ -n "${file}" ] || file="sadms.settings"
	i=0
	while read line; do
		name=`echo ${line} | awk 'BEGIN{FS="="}{print $1}'`
		value=`echo ${line} | awk 'BEGIN{FS="="}{print $2}'`
		#echo "+${line} = ${name} + ${value}"
		case ${name} in
			cifsserver) MYSERVER="${value}" ; i=$(( i + 1 )) ;;
			cifsshare) MYSHARE="${value}" ; i=$(( i + 1 )) ;;
			cifsmountpoint) MYMOUNTPOINT="${value}" ; i=$(( i + 1 )) ;;
			domain) MYDOMAIN="${value}" ; i=$(( i + 1 )) ;;
			cifsuser) MYUSER="${value}" ; i=$(( i + 1 )) ;;
		esac
	MYNARGS=${i}		
	done < ${file}
	echo "+read ${MYNARGS} settings from ${file}"
	echo 
else
	# echo no file
	MYNARGS=$#
	MYSERVER="$1"
	MYSHARE="$2"
	MYMOUNTPOINT="$3"
	MYDOMAIN="$4"
	MYUSER="$5"
fi

echo "-------------------------------------------------------------------------------"
echo "S A D M S  `cat version | head -n 1`"
echo "Samba as Active Directory Member Server"
echo "bbou@ac-toulouse.fr"
echo "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
echo "install PAM"
echo "-------------------------------------------------------------------------------"

# check testing/enforcing mode
MYENFORCE=
if [ -z "${MYENFORCE}" ]; then
	read -p 'Enforce (y/n): ' MYENFORCE
	if [ "${MYENFORCE}" != "y" ]; then
		MYENFORCE='-t'
	else
		MYENFORCE=
	fi
fi

# parameters
if [ -z "${MYSERVER}" ]; then
	read -p 'CIFS Home server (ex:server): ' MYSERVER
	[ -z "${MYSERVER}" ] && exit 1
fi
if [ -z "${MYSHARE}" ]; then
	read -p 'CIFS Home share (ex:users,&=logged-in user): ' MYSHARE
	[ -z "${MYSHARE}" ] &&  MYSHARE='&'
fi
if [ -z "${MYMOUNTPOINT}" ]; then
	read -p 'CIFS Mount point (default=~/.cifsmount): ' MYMOUNTPOINT
	[ -z "${MYMOUNTPOINT}" ] &&  MYMOUNTPOINT='~/.cifsmount'
fi
if [ -z "${MYDOMAIN}" ]; then
	read -p 'CIFS Domain (ex:CHAMPOL): ' MYDOMAIN
fi
if [ -z "${MYUSER}" ]; then
	read -p 'CIFS User (ex:dummy,*=logged-in user): ' MYUSER
	[ -z "${MYUSER}" ] &&  MYUSER='*'
fi

# display
echo
echo 'CIFS home server: '"${MYSERVER}"
echo 'CIFS share: '"${MYSHARE}"
echo 'CIFS mount point: '"${MYMOUNTPOINT}"
echo 'CIFS domain: '"${MYDOMAIN}"
echo 'CIFS user: '"${MYUSER}"
if [ "${MYENFORCE}" == "-t" ]; then
	echo 'Testing'
else
	echo 'Enforcing'
fi
echo
read -p 'Do you want to proceed (y/n) ?: ' yes

case ${yes} in
y*|Y*)
	./_install-pam-core.sh ${MYENFORCE} -w -h -m "${MYSERVER}" "${MYSHARE}" "${MYMOUNTPOINT}" "${MYDOMAIN}" "${MYUSER}"
	exit $?
	;;
*)
	exit
	;;
esac
