#! /usr/bin/env python

"""ex-delivery-failed.py - Signalling delivery errors

This example shows how an alarm action should
signal delivery errors."""

import CORBA, oaf
import SandUhr, SandUhr__POA

orb = oaf.init()

class BrokenAlarm(SandUhr__POA.AlarmAction):
    def __init__(self):
        self.NeedsPopup = CORBA.FALSE

    def Attach(self, timer):
        pass

    def Detach(self, timer):
        orb.shutdown(1)

    def Deliver(self, timespec, message):
        raise SandUhr.AlarmAction.DeliveryFailed(Reason="recipient unknown")

poa = orb.resolve_initial_references("RootPOA")
alarm = BrokenAlarm()._this()
poa._get_the_POAManager().activate()

factory = oaf.activate("repo_ids.has('IDL:SandUhr/TimerFactory:1.0')",[])
timer = factory.CreateTimer ("+10s", "The example timer has reached its time")
timer.Alarm = alarm

orb.run()
