package provide DS9 1.0

######
# Begin autogenerated taccle (version 1.3) routines.
# Although taccle itself is protected by the GNU Public License (GPL)
# all user-supplied functions are protected by their respective
# author's license.  See http://mini.net/tcl/taccle for other details.
######

namespace eval sia {
    variable yylval {}
    variable table
    variable rules
    variable token {}
    variable yycnt 0
    variable yyerr 0
    variable save_state 0

    namespace export yylex
}

proc sia::YYABORT {} {
    return -code return 1
}

proc sia::YYACCEPT {} {
    return -code return 0
}

proc sia::YYERROR {} {
    variable yyerr
    set yyerr 1
}

proc sia::yyclearin {} {
    variable token
    variable yycnt
    set token {}
    incr yycnt -1
}

proc sia::yyerror {s} {
    puts stderr $s
}

proc sia::setupvalues {stack pointer numsyms} {
    upvar 1 1 y
    set y {}
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        set y [lindex $stack $pointer]
        incr pointer
    }
}

proc sia::unsetupvalues {numsyms} {
    for {set i 1} {$i <= $numsyms} {incr i} {
        upvar 1 $i y
        unset y
    }
}

array set sia::table {
  34:336,target 88
  31:294,target 45
  90:303 reduce
  89:303 reduce
  16:283,target 79
  0:327,target 24
  1:303 reduce
  4:336 goto
  14:295,target 53
  27:0 reduce
  21:303 reduce
  36:303,target 58
  82:303,target 30
  4:340 goto
  13:301,target 32
  60:303 reduce
  59:303 reduce
  48:0 reduce
  0:306,target 3
  16:262,target 58
  98:303 reduce
  87:292,target 50
  70:0 reduce
  69:0 reduce
  9:303 reduce
  25:303,target 79
  95:0,target 49
  71:303,target 19
  32:296,target 46
  30:303 reduce
  29:303 reduce
  91:0 reduce
  87:0,target 70
  2:0 reduce
  80:0,target 28
  79:0,target 27
  4:301,target 32
  72:0,target 20
  68:303 reduce
  31:292,target 45
  64:0,target 12
  16:281,target 77
  0:325,target 22
  56:0,target 41
  44:298,target 92
  24:0 reduce
  6:328,target 25
  14:293,target 51
  60:303,target 8
  59:303,target 7
  48:0,target 34
  46:336,target 94
  45:0 reduce
  38:303 reduce
  88:294,target 52
  25:0,target 79
  0:304,target 1
  17:0,target 67
  77:303 reduce
  66:0 reduce
  87:290,target 48
  87:289,target 47
  48:303,target 34
  5:303,target 57
  87:0 reduce
  32:294,target 46
  47:303 reduce
  7:331,target 42
  31:300,target 45
  31:290,target 45
  31:289,target 45
  7:259,target 39
  7:260,target 40
  37:303,target 1
  21:0 reduce
  16:278,target 74
  0:323,target 20
  86:303 shift
  83:303,target 31
  44:296,target 90
  6:326,target 23
  14:291,target 49
  17:303 reduce
  88:292,target 50
  63:0 reduce
  56:303 reduce
  26:303,target 80
  72:303,target 20
  13:336,target 46
  84:0 reduce
  32:292,target 46
  26:303 reduce
  61:303,target 9
  17:0 reduce
  7:257,target 37
  65:303 reduce
  29:338 goto
  16:276,target 72
  0:321,target 18
  6:324,target 21
  4:336,target 34
  92:0,target 44
  88:290,target 48
  88:289,target 47
  60:0 reduce
  59:0 reduce
  50:303,target 36
  49:303,target 35
  35:303 reduce
  3:0,target 53
  84:0,target 32
  76:0,target 24
  81:0 reduce
  74:303 reduce
  68:0,target 16
  61:0,target 9
  0:339,target 29
  53:0,target 39
  32:300,target 46
  32:290,target 46
  32:289,target 46
  45:0,target 54
  38:303,target 2
  6:321 shift
  84:303,target 32
  6:322 shift
  30:0,target 50
  29:0,target 47
  6:323 shift
  22:0,target 76
  16:274,target 70
  0:318,target 15
  6:324 shift
  35:0 reduce
  6:322,target 19
  6:325 shift
  14:289 shift
  14:290 shift
  83:303 reduce
  44:296 shift
  6:326 shift
  14:291 shift
  44:297 shift
  27:303,target 81
  6:327 shift
  14:292 shift
  73:303,target 21
  56:0 reduce
  44:298 shift
  6:328 shift
  14:293 shift
  6:329 shift
  6:330 shift
  14:294 shift
  14:295 shift
  77:0 reduce
  53:303 reduce
  33:302,target 87
  10:300,target 31
  0:337,target 28
  98:0 reduce
  92:303 reduce
  62:303,target 10
  3:303 reduce
  6:341,target 36
  9:0 reduce
  11:0 reduce
  87:333,target 96
  23:303 reduce
  32:0 reduce
  0:316,target 13
  16:272,target 68
  62:303 reduce
  6:341 goto
  51:303,target 37
  96:303,target 71
  53:0 reduce
  32:300 reduce
  32:290 reduce
  32:289 reduce
  32:301 reduce
  32:291 reduce
  32:292 reduce
  74:0 reduce
  32:303 reduce
  32:293 reduce
  32:294 reduce
  40:303,target 4
  39:303,target 3
  32:295 reduce
  95:0 reduce
  85:303,target 66
  71:303 reduce
  32:296 reduce
  32:297 reduce
  32:298 reduce
  96:0,target 71
  28:0 accept
  88:0,target 68
  44:335 goto
  41:303 reduce
  0:314,target 11
  16:269,target 65
  16:270,target 66
  81:0,target 29
  74:303,target 22
  73:0,target 21
  50:0 reduce
  49:0 reduce
  80:303 reduce
  79:303 reduce
  65:0,target 13
  14:333 goto
  57:0,target 65
  71:0 reduce
  50:0,target 36
  49:0,target 35
  11:303 reduce
  17:303,target 67
  63:303,target 11
  92:0 reduce
  88:290 shift
  88:289 shift
  50:303 reduce
  49:303 reduce
  26:0,target 80
  3:0 reduce
  88:291 shift
  88:333,target 97
  18:0,target 72
  16:288,target 84
  88:292 shift
  11:0,target 61
  88:293 shift
  88:303 reduce
  88:294 shift
  25:0 reduce
  0:304 shift
  88:295 shift
  52:303,target 38
  20:303 reduce
  19:303 reduce
  0:305 shift
  97:303,target 69
  0:312,target 9
  0:306 shift
  8:303,target 43
  16:262 shift
  16:267,target 63
  0:307 shift
  16:263 shift
  58:303 reduce
  0:308 shift
  15:334,target 57
  16:264 shift
  0:309 shift
  0:310 shift
  16:265 shift
  67:0 reduce
  34:300,target 31
  0:311 shift
  16:266 shift
  97:303 reduce
  44:335,target 93
  41:303,target 5
  0:312 shift
  8:303 shift
  16:267 shift
  86:303,target 95
  0:313 shift
  16:268 shift
  88:0 reduce
  0:314 shift
  16:269 shift
  16:270 shift
  31:297,target 45
  0:315 shift
  16:271 shift
  16:286,target 82
  0:316 shift
  16:272 shift
  67:303 reduce
  0:317 shift
  16:273 shift
  30:303,target 50
  29:303,target 48
  22:0 reduce
  16:274 shift
  0:318 shift
  75:303,target 23
  16:275 shift
  0:320 shift
  0:319 shift
  16:276 shift
  0:321 shift
  43:0 reduce
  16:277 shift
  0:322 shift
  0:309,target 6
  0:310,target 7
  16:265,target 61
  37:303 reduce
  16:278 shift
  0:323 shift
  16:280 shift
  16:279 shift
  0:324 shift
  87:295,target 53
  64:0 reduce
  18:303,target 72
  16:281 shift
  0:325 shift
  94:298,target 92
  76:303 reduce
  64:303,target 12
  16:282 shift
  0:326 shift
  16:283 shift
  0:327 shift
  85:0 reduce
  46:300 shift
  16:284 shift
  0:328 shift
  46:301 shift
  16:285 shift
  0:329 shift
  0:330 shift
  93:0,target 62
  31:295,target 45
  16:286 shift
  85:0,target 66
  46:300,target 31
  16:287 shift
  16:284,target 80
  0:328,target 25
  88:333 goto
  77:0,target 25
  53:303,target 39
  18:0 reduce
  16:288 shift
  98:303,target 63
  70:0,target 18
  69:0,target 17
  9:303,target 60
  85:303 reduce
  62:0,target 10
  54:0,target 64
  0:307,target 4
  0:337 goto
  16:263,target 59
  61:0 reduce
  42:303,target 89
  31:0,target 45
  0:339 goto
  87:293,target 51
  87:303,target 70
  55:303 reduce
  23:0,target 77
  0:341 goto
  94:296,target 90
  82:0 reduce
  32:297,target 46
  5:303 reduce
  4:302,target 33
  31:303,target 45
  31:293,target 45
  25:303 reduce
  94:296 shift
  76:303,target 24
  16:282,target 78
  0:326,target 23
  94:297 shift
  6:329,target 26
  6:330,target 27
  14:294,target 52
  94:298 shift
  64:303 reduce
  36:0 reduce
  34:300 shift
  13:300,target 31
  16:332,target 85
  88:295,target 53
  34:301 shift
  20:303,target 74
  19:303,target 73
  0:305,target 2
  65:303,target 13
  57:0 reduce
  29:338,target 86
  87:291,target 49
  78:0 reduce
  73:303 reduce
  32:295,target 46
  54:303,target 64
  4:300,target 31
  15:296,target 55
  31:301,target 45
  31:291,target 45
  7:261,target 41
  16:280,target 76
  16:279,target 75
  0:324,target 21
  44:297,target 91
  43:303 reduce
  6:327,target 24
  14:292,target 50
  46:336 goto
  4:340,target 35
  13:300 shift
  16:332 goto
  82:303 reduce
  43:303,target 59
  13:301 shift
  88:293,target 51
  88:303,target 68
  54:0 reduce
  97:0,target 69
  90:0,target 42
  89:0,target 55
  75:0 reduce
  1:0,target 51
  82:0,target 30
  52:303 reduce
  74:0,target 22
  32:303,target 46
  32:293,target 46
  96:0 reduce
  77:303,target 25
  66:0,target 14
  94:335 goto
  91:303 reduce
  58:0,target 6
  2:303 reduce
  51:0,target 37
  7:258,target 38
  43:0,target 59
  22:303 reduce
  16:277,target 73
  0:322,target 19
  35:0,target 56
  30:0 reduce
  29:0 reduce
  6:325,target 22
  14:289,target 47
  14:290,target 48
  27:0,target 81
  21:303,target 75
  66:303,target 14
  61:303 reduce
  20:0,target 74
  19:0,target 73
  7:257 shift
  51:0 reduce
  7:258 shift
  88:291,target 49
  31:300 reduce
  31:290 reduce
  31:289 reduce
  7:259 shift
  7:260 shift
  31:301 reduce
  31:291 reduce
  7:261 shift
  72:0 reduce
  31:292 reduce
  31:303 reduce
  31:293 reduce
  55:303,target 40
  34:336 goto
  31:294 reduce
  0:341,target 30
  93:0 reduce
  32:301,target 46
  32:291,target 46
  31:295 reduce
  70:303 reduce
  69:303 reduce
  31:296 reduce
  31:297 reduce
  31:298 reduce
  26:0 reduce
  16:275,target 71
  0:320,target 17
  0:319,target 16
  6:323,target 20
  90:303,target 42
  89:303,target 55
  40:303 reduce
  39:303 reduce
  1:303,target 51
  47:0 reduce
  10:300 shift
  78:303 reduce
  10:301 shift
  68:0 reduce
  78:303,target 26
  10:301,target 32
  13:336 goto
  90:0 reduce
  89:0 reduce
  1:0 reduce
  87:290 shift
  87:289 shift
  48:303 reduce
  87:291 shift
  87:292 shift
  87:293 shift
  87:303 reduce
  23:0 reduce
  22:303,target 76
  87:294 shift
  67:303,target 15
  16:273,target 69
  0:317,target 14
  87:295 shift
  18:303 reduce
  6:321,target 18
  5:0,target 57
  78:0,target 26
  57:303 reduce
  71:0,target 19
  65:0 reduce
  11:303,target 61
  63:0,target 11
  56:303,target 41
  96:303 reduce
  55:0,target 40
  47:0,target 33
  27:303 reduce
  32:0,target 46
  24:0,target 78
  66:303 reduce
  45:303,target 54
  20:0 reduce
  19:0 reduce
  94:335,target 98
  91:303,target 43
  2:303,target 52
  0:315,target 12
  16:271,target 67
  36:303 reduce
  62:0 reduce
  80:303,target 28
  79:303,target 27
  14:333,target 54
  75:303 reduce
  83:0 reduce
  10:336 goto
  23:303,target 77
  68:303,target 16
  45:303 reduce
  87:333 goto
  10:336,target 44
  84:303 reduce
  0:313,target 10
  16:268,target 64
  12:303,target 45
  58:0 reduce
  57:303,target 65
  34:301,target 32
  7:331 goto
  54:303 reduce
  4:300 shift
  15:296 shift
  80:0 reduce
  79:0 reduce
  4:301 shift
  4:302 shift
  93:303 reduce
  31:298,target 45
  15:299 shift
  16:287,target 83
  98:0,target 63
  92:303,target 44
  24:303 reduce
  3:303,target 53
  9:0,target 60
  91:0,target 43
  2:0,target 52
  83:0,target 31
  75:0,target 23
  63:303 reduce
  67:0,target 15
  0:311,target 8
  16:266,target 62
  60:0,target 8
  59:0,target 7
  35:303,target 56
  81:303,target 29
  55:0 reduce
  52:0,target 38
  33:302 shift
  36:0,target 58
  76:0 reduce
  28:0,target 0
  21:0,target 75
  72:303 reduce
  24:303,target 78
  97:0 reduce
  70:303,target 18
  69:303,target 17
  31:296,target 45
  46:301,target 32
  16:285,target 81
  0:329,target 26
  0:330,target 27
  42:303 shift
  31:0 reduce
  58:303,target 6
  0:308,target 5
  16:264,target 60
  81:303 reduce
  52:0 reduce
  15:334 goto
  87:294,target 52
  12:303 shift
  94:297,target 91
  73:0 reduce
  32:298,target 46
  51:303 reduce
  47:303,target 33
  93:303,target 62
  5:0 reduce
  15:299,target 56
}

array set sia::rules {
  9,l 332
  11,l 332
  32,l 332
  53,l 339
  74,l 341
  6,l 332
  28,l 332
  50,l 339
  49,l 337
  71,l 340
  3,l 331
  25,l 332
  46,l 336
  67,l 339
  0,l 342
  22,l 332
  43,l 335
  64,l 339
  18,l 332
  40,l 334
  39,l 333
  61,l 339
  15,l 332
  36,l 333
  57,l 339
  78,l 341
  12,l 332
  33,l 333
  54,l 339
  75,l 341
  7,l 332
  29,l 332
  30,l 332
  51,l 339
  72,l 341
  4,l 331
  26,l 332
  47,l 337
  68,l 340
  1,l 331
  23,l 332
  44,l 335
  65,l 339
  19,l 332
  20,l 332
  41,l 334
  62,l 339
  16,l 332
  37,l 333
  58,l 339
  80,l 341
  79,l 341
  13,l 332
  34,l 333
  55,l 339
  76,l 341
  8,l 332
  10,l 332
  31,l 332
  52,l 339
  73,l 341
  5,l 331
  27,l 332
  48,l 338
  70,l 340
  69,l 340
  2,l 331
  24,l 332
  45,l 336
  66,l 339
  21,l 332
  42,l 335
  63,l 339
  17,l 332
  38,l 333
  60,l 339
  59,l 339
  81,l 341
  14,l 332
  35,l 333
  56,l 339
  77,l 341
}

array set sia::rules {
  63,dc 4
  12,dc 1
  77,dc 1
  26,dc 1
  3,dc 1
  41,dc 1
  55,dc 3
  70,dc 2
  69,dc 3
  18,dc 1
  33,dc 1
  9,dc 1
  47,dc 1
  62,dc 3
  11,dc 1
  76,dc 1
  25,dc 1
  2,dc 1
  40,dc 1
  39,dc 1
  54,dc 2
  68,dc 2
  17,dc 1
  32,dc 1
  8,dc 1
  46,dc 1
  61,dc 1
  10,dc 1
  75,dc 1
  24,dc 1
  1,dc 1
  38,dc 1
  53,dc 1
  67,dc 1
  16,dc 1
  31,dc 1
  7,dc 1
  45,dc 1
  60,dc 1
  59,dc 2
  74,dc 1
  23,dc 1
  0,dc 1
  37,dc 1
  52,dc 1
  66,dc 2
  15,dc 1
  81,dc 1
  29,dc 1
  30,dc 1
  6,dc 1
  44,dc 1
  58,dc 2
  73,dc 1
  22,dc 1
  36,dc 1
  51,dc 1
  65,dc 2
  14,dc 1
  80,dc 1
  79,dc 1
  28,dc 1
  5,dc 1
  43,dc 1
  57,dc 1
  72,dc 1
  21,dc 1
  35,dc 1
  50,dc 1
  49,dc 3
  64,dc 2
  13,dc 1
  78,dc 1
  27,dc 1
  4,dc 1
  42,dc 1
  56,dc 2
  71,dc 3
  19,dc 1
  20,dc 1
  34,dc 1
  48,dc 0
}

array set sia::rules {
  41,line 192
  7,line 156
  37,line 187
  4,line 152
  34,line 184
  1,line 149
  31,line 180
  27,line 176
  24,line 173
  80,line 244
  79,line 243
  21,line 170
  76,line 240
  17,line 166
  73,line 237
  14,line 163
  70,line 232
  69,line 231
  11,line 160
  66,line 226
  63,line 223
  60,line 219
  59,line 218
  56,line 215
  53,line 211
  50,line 207
  49,line 204
  46,line 200
  43,line 196
  9,line 158
  40,line 191
  39,line 189
  6,line 155
  36,line 186
  3,line 151
  33,line 183
  29,line 178
  30,line 179
  26,line 175
  23,line 172
  78,line 242
  19,line 168
  20,line 169
  75,line 239
  16,line 165
  72,line 236
  13,line 162
  68,line 230
  10,line 159
  65,line 225
  62,line 222
  58,line 217
  55,line 214
  52,line 209
  48,line 203
  45,line 199
  42,line 195
  8,line 157
  38,line 188
  5,line 153
  35,line 185
  2,line 150
  32,line 181
  48,e 1
  28,line 177
  25,line 174
  81,line 245
  22,line 171
  77,line 241
  18,line 167
  74,line 238
  15,line 164
  71,line 233
  12,line 161
  67,line 227
  64,line 224
  61,line 220
  57,line 216
  54,line 212
  51,line 208
  47,line 203
  44,line 197
}

array set sia::lr1_table {
  35 {{56 {0 303} 2}}
  66,trans {}
  36 {{58 {0 303} 2}}
  85,trans {}
  37 {{1 303 1}}
  38 {{2 303 1}}
  40 {{4 303 1}}
  39 {{3 303 1}}
  41 {{5 303 1}}
  42 {{55 {0 303} 2}}
  43 {{59 {0 303} 2}}
  44 {{45 {296 297 298} 1}}
  45 {{46 {296 297 298} 1}}
  46 {{62 {0 303} 2} {42 {0 303} 0} {43 {0 303} 0} {44 {0 303} 0}}
  47 {{54 {0 303} 2}}
  48 {{63 {0 303} 2} {45 {296 297 298} 0} {46 {296 297 298} 0}}
  49 {{33 {0 303} 1}}
  50 {{34 {0 303} 1}}
  27,trans {}
  51 {{35 {0 303} 1}}
  46,trans {{296 94} {297 95} {298 96} {335 97}}
  52 {{36 {0 303} 1}}
  65,trans {}
  53 {{37 {0 303} 1}}
  84,trans {}
  54 {{38 {0 303} 1}}
  55 {{39 {0 303} 1}}
  56 {{64 {0 303} 2}}
  57 {{40 {0 303} 1}}
  58 {{41 {0 303} 1}}
  59 {{65 {0 303} 2}}
  60 {{6 {0 303} 1}}
  61 {{7 {0 303} 1}}
  62 {{8 {0 303} 1}}
  63 {{9 {0 303} 1}}
  64 {{10 {0 303} 1}}
  65 {{11 {0 303} 1}}
  66 {{12 {0 303} 1}}
  26,trans {}
  67 {{13 {0 303} 1}}
  45,trans {}
  68 {{14 {0 303} 1}}
  64,trans {}
  69 {{15 {0 303} 1}}
  70 {{16 {0 303} 1}}
  83,trans {}
  71 {{17 {0 303} 1}}
  72 {{18 {0 303} 1}}
  73 {{19 {0 303} 1}}
  74 {{20 {0 303} 1}}
  75 {{21 {0 303} 1}}
  76 {{22 {0 303} 1}}
  77 {{23 {0 303} 1}}
  78 {{24 {0 303} 1}}
  79 {{25 {0 303} 1}}
  80 {{26 {0 303} 1}}
  81 {{27 {0 303} 1}}
  82 {{28 {0 303} 1}}
  83 {{29 {0 303} 1}}
  25,trans {}
  84 {{30 {0 303} 1}}
  44,trans {}
  85 {{31 {0 303} 1}}
  63,trans {}
  86 {{32 {0 303} 1}}
  82,trans {}
  87 {{66 {0 303} 2}}
  0 {{0 0 0} {47 0 0} {49 0 0} {50 {0 303} 0} {51 {0 303} 0} {52 {0 303} 0} {53 {0 303} 0} {54 {0 303} 0} {55 {0 303} 0} {56 {0 303} 0} {57 {0 303} 0} {58 {0 303} 0} {59 {0 303} 0} {60 {0 303} 0} {61 {0 303} 0} {62 {0 303} 0} {63 {0 303} 0} {64 {0 303} 0} {65 {0 303} 0} {66 {0 303} 0} {67 {0 303} 0} {72 {0 303} 0} {73 {0 303} 0} {74 {0 303} 0} {75 {0 303} 0} {76 {0 303} 0} {77 {0 303} 0} {78 {0 303} 0} {79 {0 303} 0} {80 {0 303} 0} {81 {0 303} 0}}
  88 {{49 0 2}}
  1 {{51 {0 303} 1}}
  89 {{70 {0 303} 2} {71 {0 303} 2} {33 {0 303} 0} {34 {0 303} 0} {35 {0 303} 0} {36 {0 303} 0} {37 {0 303} 0} {38 {0 303} 0} {39 {0 303} 0}}
  90 {{45 {0 289 290 291 292 293 294 295 303} 1}}
  2 {{52 {0 303} 1}}
  91 {{46 {0 289 290 291 292 293 294 295 303} 1}}
  3 {{53 {0 303} 1}}
  92 {{68 {0 303} 2} {69 {0 303} 2} {33 {0 303} 0} {34 {0 303} 0} {35 {0 303} 0} {36 {0 303} 0} {37 {0 303} 0} {38 {0 303} 0} {39 {0 303} 0}}
  4 {{56 {0 303} 1} {68 {0 303} 0} {69 {0 303} 0} {70 {0 303} 0} {71 {0 303} 0} {45 {300 301} 0} {46 {300 301} 0}}
  93 {{55 {0 303} 3}}
  5 {{57 {0 303} 1}}
  94 {{42 {0 303} 1}}
  6 {{58 {0 303} 1} {72 {0 303} 0} {73 {0 303} 0} {74 {0 303} 0} {75 {0 303} 0} {76 {0 303} 0} {77 {0 303} 0} {78 {0 303} 0} {79 {0 303} 0} {80 {0 303} 0} {81 {0 303} 0}}
  95 {{43 {0 303} 1}}
  7 {{55 {0 303} 1} {1 303 0} {2 303 0} {3 303 0} {4 303 0} {5 303 0}}
  96 {{44 {0 303} 1}}
  8 {{59 {0 303} 1}}
  97 {{62 {0 303} 3}}
  9 {{60 {0 303} 1}}
  98 {{63 {0 303} 3} {42 {0 303} 0} {43 {0 303} 0} {44 {0 303} 0}}
  24,trans {}
  99 {{49 0 3}}
  43,trans {}
  62,trans {}
  81,trans {}
  99,trans {}
  23,trans {}
  42,trans {{303 93}}
  61,trans {}
  79,trans {}
  80,trans {}
  98,trans {{296 94} {297 95} {298 96} {335 102}}
  9,trans {}
  22,trans {}
  41,trans {}
  59,trans {}
  60,trans {}
  78,trans {}
  97,trans {}
  8,trans {{303 43}}
  100 {{71 {0 303} 3}}
  101 {{69 {0 303} 3}}
  102 {{63 {0 303} 4}}
  21,trans {}
  39,trans {}
  40,trans {}
  58,trans {}
  77,trans {}
  96,trans {}
  7,trans {{257 37} {258 38} {259 39} {260 40} {261 41} {331 42}}
  19,trans {}
  20,trans {}
  38,trans {}
  57,trans {}
  76,trans {}
  95,trans {}
  6,trans {{321 18} {322 19} {323 20} {324 21} {325 22} {326 23} {327 24} {328 25} {329 26} {330 27} {341 36}}
  18,trans {}
  37,trans {}
  56,trans {}
  75,trans {}
  94,trans {}
  5,trans {}
  17,trans {}
  36,trans {}
  55,trans {}
  74,trans {}
  93,trans {}
  4,trans {{300 31} {301 32} {302 33} {336 34} {340 35}}
  16,trans {{262 60} {263 61} {264 62} {265 63} {266 64} {267 65} {268 66} {269 67} {270 68} {271 69} {272 70} {273 71} {274 72} {275 73} {276 74} {277 75} {278 76} {279 77} {280 78} {281 79} {282 80} {283 81} {284 82} {285 83} {286 84} {287 85} {288 86} {332 87}}
  35,trans {}
  54,trans {}
  73,trans {}
  92,trans {{289 49} {290 50} {291 51} {292 52} {293 53} {294 54} {295 55} {333 101}}
  3,trans {}
  15,trans {{296 57} {299 58} {334 59}}
  34,trans {{300 90} {301 91} {336 92}}
  53,trans {}
  72,trans {}
  91,trans {}
  2,trans {}
  14,trans {{289 49} {290 50} {291 51} {292 52} {293 53} {294 54} {295 55} {333 56}}
  33,trans {{302 89}}
  52,trans {}
  71,trans {}
  1,trans {}
  89,trans {{289 49} {290 50} {291 51} {292 52} {293 53} {294 54} {295 55} {333 100}}
  90,trans {}
  13,trans {{300 31} {301 32} {336 48}}
  32,trans {}
  51,trans {}
  69,trans {}
  70,trans {}
  0,trans {{304 1} {305 2} {306 3} {307 4} {308 5} {309 6} {310 7} {311 8} {312 9} {313 10} {314 11} {315 12} {316 13} {317 14} {318 15} {319 16} {320 17} {321 18} {322 19} {323 20} {324 21} {325 22} {326 23} {327 24} {328 25} {329 26} {330 27} {337 28} {339 29} {341 30}}
  88,trans {{303 99}}
  102,trans {}
  12,trans {{303 47}}
  31,trans {}
  49,trans {}
  50,trans {}
  68,trans {}
  87,trans {}
  101,trans {}
  10 {{62 {0 303} 1} {45 {296 297 298} 0} {46 {296 297 298} 0}}
  11 {{61 {0 303} 1}}
  12 {{54 {0 303} 1}}
  13 {{63 {0 303} 1} {45 {300 301} 0} {46 {300 301} 0}}
  14 {{64 {0 303} 1} {33 {0 303} 0} {34 {0 303} 0} {35 {0 303} 0} {36 {0 303} 0} {37 {0 303} 0} {38 {0 303} 0} {39 {0 303} 0}}
  15 {{65 {0 303} 1} {40 {0 303} 0} {41 {0 303} 0}}
  11,trans {}
  16 {{66 {0 303} 1} {6 {0 303} 0} {7 {0 303} 0} {8 {0 303} 0} {9 {0 303} 0} {10 {0 303} 0} {11 {0 303} 0} {12 {0 303} 0} {13 {0 303} 0} {14 {0 303} 0} {15 {0 303} 0} {16 {0 303} 0} {17 {0 303} 0} {18 {0 303} 0} {19 {0 303} 0} {20 {0 303} 0} {21 {0 303} 0} {22 {0 303} 0} {23 {0 303} 0} {24 {0 303} 0} {25 {0 303} 0} {26 {0 303} 0} {27 {0 303} 0} {28 {0 303} 0} {29 {0 303} 0} {30 {0 303} 0} {31 {0 303} 0} {32 {0 303} 0}}
  29,trans {{338 88}}
  30,trans {}
  17 {{67 {0 303} 1}}
  48,trans {{300 44} {301 45} {336 98}}
  18 {{72 {0 303} 1}}
  67,trans {}
  20 {{74 {0 303} 1}}
  19 {{73 {0 303} 1}}
  86,trans {}
  21 {{75 {0 303} 1}}
  22 {{76 {0 303} 1}}
  100,trans {}
  23 {{77 {0 303} 1}}
  24 {{78 {0 303} 1}}
  25 {{79 {0 303} 1}}
  26 {{80 {0 303} 1}}
  27 {{81 {0 303} 1}}
  28 {{0 0 1}}
  30 {{50 {0 303} 1}}
  29 {{47 0 1} {49 0 1} {48 303 0}}
  31 {{45 {300 301} 1}}
  32 {{46 {300 301} 1}}
  10,trans {{300 44} {301 45} {336 46}}
  33 {{70 {0 303} 1} {71 {0 303} 1}}
  28,trans {}
  34 {{68 {0 303} 1} {69 {0 303} 1} {45 {0 289 290 291 292 293 294 295 303} 0} {46 {0 289 290 291 292 293 294 295 303} 0}}
  47,trans {}
}

array set sia::token_id_table {
  286 WCSX_
  286,t 0
  287 WCSY_
  292,line 44
  302,line 58
  288 WCSZ_
  317,t 0
  265,title WCSC
  289 FK4_
  290 B1950_
  300 INT_
  284,title WCSV
  291 FK5_
  301 REAL_
  313,title RADIUS
  292 J2000_
  302 SEXSTR_
  338,t 1
  332,title {}
  288,line 39
  293 ICRS_
  303 STRING_
  294 GALACTIC_
  304 CANCEL_
  305 CLEAR_
  295 ECLIPTIC_
  306 CLOSE_
  296 DEGREES_
  307 COORDINATE_
  262,t 0
  297 ARCMIN_
  308 CROSSHAIR_
  285,line 36
  298 ARCSEC_
  310 EXPORT_
  309 CURRENT_
  299 SEXAGESIMAL_
  311 NAME_
  283,t 0
  312 PRINT_
  313 RADIUS_
  314,t 0
  314 RETRIEVE_
  282,line 33
  315 SAVE_
  316 SIZE_
  264,title WCSB
  335,t 1
  317 SKY_
  283,title WCSU
  318 SKYFORMAT_
  312,title PRINT
  331,title {}
  320 UPDATE_
  319 SYSTEM_
  278,line 29
  error,line 147
  321 2MASS_
  322 AKARI_
  258,t 0
  323 ASTROWISE_
  324 CADC_
  325 CXC_
  275,line 26
  279,t 0
  280,t 0
  326 HLA_
  341,line 235
  327 MAST_
  328 SDSS_
  311,t 0
  330 TGSSADR_
  329 SKYVIEW_
  331 writer
  272,line 23
  332,t 1
  332 wcssys
  337,line 202
  333 skyframe
  263,title WCSA
  334 skyformat
  282,title WCST
  335 rformat
  311,title NAME
  336 numeric
  330,title TGSSADR
  329,title SKYVIEW
  268,line 19
  337 command
  338 @PSEUDO1
  334,line 190
  340 coordinate
  339 sia
  276,t 0
  341 site
  342 start'
  265,line 16
  307,t 0
  297,t 0
  331,line 148
  328,t 0
  262,line 13
  0,t 0
  0 {$}
  327,line 88
  262,title WCS
  281,title WCSS
  error,t 0
  310,title EXPORT
  309,title CURRENT
  299,title SEXAGESIMAL
  328,title SDSS
  258,line 8
  273,t 0
  324,line 85
  294,t 0
  304,t 0
  325,t 0
  321,line 82
  317,line 77
  261,title TSV
  279,title WCSQ
  280,title WCSR
  308,title CROSSHAIR
  269,t 0
  270,t 0
  298,title ARCSEC
  327,title MAST
  314,line 74
  291,t 0
  301,t 0
  322,t 0
  311,line 71
  307,line 67
  266,t 0
  260,title CSV
  259,title STARBASE
  297,line 50
  278,title WCSP
  307,title COORDINATE
  297,title ARCMIN
  326,title HLA
  287,t 0
  294,line 46
  304,line 64
  318,t 0
  340,t 1
  339,t 1
  error,title {}
  291,line 43
  301,line 56
  263,t 0
  258,title SB
  287,line 38
  277,title WCSO
  284,t 0
  306,title CLOSE
  296,title DEGREES
  325,title CXC
  315,t 0
  284,line 35
  336,t 1
  281,line 32
  260,t 0
  259,t 0
  281,t 0
  257,title RDB
  277,line 28
  276,title WCSN
  312,t 0
  305,title CLEAR
  295,title ECLIPTIC
  324,title CADC
  333,t 1
  274,line 25
  340,line 229
  339,line 206
  271,line 22
  336,line 198
  277,t 0
  308,t 0
  267,line 18
  298,t 0
  275,title WCSM
  333,line 182
  294,title GALACTIC
  304,title CANCEL
  330,t 0
  329,t 0
  323,title ASTROWISE
  342,title {}
  264,line 15
  330,line 91
  329,line 90
  261,line 11
  274,t 0
  326,line 87
  305,t 0
  295,t 0
  257,line 7
  326,t 0
  274,title WCSL
  323,line 84
  293,title ICRS
  303,title string
  322,title AKARI
  341,title {}
  320,line 80
  319,line 79
  error error
  271,t 0
  292,t 0
  302,t 0
  316,line 76
  323,t 0
  273,title WCSK
  313,line 73
  292,title J2000
  302,title sexagesimal
  321,title 2MASS
  340,title {}
  339,title {}
  267,t 0
  310,line 70
  309,line 69
  299,line 53
  288,t 0
  320,t 0
  319,t 0
  306,line 66
  296,line 49
  341,t 1
  272,title WCSJ
  291,title FK5
  293,line 45
  301,title float
  303,line 60
  320,title UPDATE
  319,title SYSTEM
  338,title {}
  264,t 0
  285,t 0
  289,line 41
  290,line 42
  300,line 55
  316,t 0
  286,line 37
  337,t 1
  271,title WCSI
  261,t 0
  283,line 34
  289,title FK4
  290,title B1950
  300,title integer
  318,title SKYFORMAT
  337,title {}
  282,t 0
  279,line 30
  280,line 31
  313,t 0
  334,t 1
  276,line 27
  342,line 246
  257,t 0
  269,title WCSG
  270,title WCSH
  273,line 24
  288,title WCSZ
  317,title SKY
  278,t 0
  338,line 203
  336,title {}
  310,t 0
  309,t 0
  299,t 0
  269,line 20
  270,line 21
  335,line 194
  331,t 1
  266,line 17
  332,line 154
  268,title WCSF
  275,t 0
  263,line 14
  287,title WCSY
  316,title SIZE
  335,title {}
  328,line 89
  306,t 0
  296,t 0
  327,t 0
  260,line 10
  259,line 9
  325,line 86
  322,line 83
  272,t 0
  267,title WCSE
  257 RDB_
  286,title WCSX
  293,t 0
  303,t 0
  315,title SAVE
  258 SB_
  334,title {}
  318,line 78
  260 CSV_
  259 STARBASE_
  324,t 0
  261 TSV_
  262 WCS_
  263 WCSA_
  264 WCSB_
  315,line 75
  265 WCSC_
  266 WCSD_
  267 WCSE_
  268,t 0
  268 WCSF_
  269 WCSG_
  270 WCSH_
  312,line 72
  271 WCSI_
  272 WCSJ_
  289,t 0
  290,t 0
  300,t 0
  266,title WCSD
  273 WCSK_
  274 WCSL_
  285,title WCSW
  321,t 0
  314,title RETRIEVE
  275 WCSM_
  333,title {}
  308,line 68
  276 WCSN_
  298,line 51
  277 WCSO_
  342,t 1
  278 WCSP_
  279 WCSQ_
  280 WCSR_
  281 WCSS_
  305,line 65
  282 WCST_
  295,line 47
  265,t 0
  283 WCSU_
  284 WCSV_
  285 WCSW_
}

proc sia::yyparse {} {
    variable yylval
    variable table
    variable rules
    variable token
    variable yycnt
    variable lr1_table
    variable token_id_table
    variable yyerr
    variable save_state

    set yycnt 0
    set state_stack {0}
    set value_stack {{}}
    set token ""
    set accepted 0
    set yyerr 0
    set save_state 0

    while {$accepted == 0} {
        set state [lindex $state_stack end]
        if {$token == ""} {
            set yylval ""
            set token [yylex]
            set buflval $yylval
	    if {$token>0} {
	        incr yycnt
            }
        }
        if {![info exists table($state:$token)] || $yyerr} {
	    if {!$yyerr} {
	        set save_state $state
	    }
            # pop off states until error token accepted
            while {[llength $state_stack] > 0 && \
                       ![info exists table($state:error)]} {
                set state_stack [lrange $state_stack 0 end-1]
                set value_stack [lrange $value_stack 0 \
                                       [expr {[llength $state_stack] - 1}]]
                set state [lindex $state_stack end]
            }
            if {[llength $state_stack] == 0} {
 
	        set rr { }
                if {[info exists lr1_table($save_state,trans)] && [llength $lr1_table($save_state,trans)] >= 1} {
                    foreach trans $lr1_table($save_state,trans) {
                        foreach {tok_id nextstate} $trans {
			    set ss $token_id_table($tok_id,title)
			    if {$ss != {}} {
			        append rr "$ss, "
                            }
                        }
                    }
                }
		set rr [string trimleft $rr { }]
		set rr [string trimright $rr {, }]
                yyerror "parse error, expecting: $rr"


                return 1
            }
            lappend state_stack [set state $table($state:error,target)]
            lappend value_stack {}
            # consume tokens until it finds an acceptable one
            while {![info exists table($state:$token)]} {
                if {$token == 0} {
                    yyerror "end of file while recovering from error"
                    return 1
                }
                set yylval {}
                set token [yylex]
                set buflval $yylval
            }
            continue
        }
        switch -- $table($state:$token) {
            shift {
                lappend state_stack $table($state:$token,target)
                lappend value_stack $buflval
                set token ""
            }
            reduce {
                set rule $table($state:$token,target)
                set ll $rules($rule,l)
                if {[info exists rules($rule,e)]} {
                    set dc $rules($rule,e)
                } else {
                    set dc $rules($rule,dc)
                }
                set stackpointer [expr {[llength $state_stack]-$dc}]
                setupvalues $value_stack $stackpointer $dc
                set _ $1
                set yylval [lindex $value_stack end]
                switch -- $rule {
                    1 { set _ starbase_write }
                    2 { set _ starbase_write }
                    3 { set _ starbase_write }
                    4 { set _ TSVWrite }
                    5 { set _ TSVWrite }
                    6 { set _ wcs }
                    7 { set _ wcsa }
                    8 { set _ wcsb }
                    9 { set _ wcsc }
                    10 { set _ wcsd }
                    11 { set _ wcse }
                    12 { set _ wcsf }
                    13 { set _ wcsg }
                    14 { set _ wcsh }
                    15 { set _ wcsi }
                    16 { set _ wcsj }
                    17 { set _ wcsk }
                    18 { set _ wcsl }
                    19 { set _ wcsm }
                    20 { set _ wcsn }
                    21 { set _ wcso }
                    22 { set _ wcsp }
                    23 { set _ wcsq }
                    24 { set _ wcsr }
                    25 { set _ wcss }
                    26 { set _ wcst }
                    27 { set _ wcsu }
                    28 { set _ wcsv }
                    29 { set _ wcsw }
                    30 { set _ wcsx }
                    31 { set _ wcsy }
                    32 { set _ wcsz }
                    33 { set _ fk4 }
                    34 { set _ fk4 }
                    35 { set _ fk5 }
                    36 { set _ fk5 }
                    37 { set _ icrs }
                    38 { set _ galactic }
                    39 { set _ ecliptic }
                    40 { set _ degrees }
                    41 { set _ sexagesimal }
                    42 { set _ degrees }
                    43 { set _ arcmin }
                    44 { set _ arcsec }
                    45 { set _ $1 }
                    46 { set _ $1 }
                    48 { global ds9; if {!$ds9(init)} {YYERROR} else {yyclearin; YYACCEPT} }
                    50 { SIACmdRetrieve $1 }
                    51 { ProcessCmdCVAR0 ARCancel }
                    52 { ProcessCmdCVAR0 SIAOff }
                    53 { ProcessCmdCVAR0 SIADestroy }
                    54 { TBLCmdSave $2 VOTWrite }
                    55 { TBLCmdSave $3 $2 }
                    57 { ProcessCmdCVAR0 SIACrosshair }
                    58 { SIACmdRef $2 }
                    59 { ProcessCmdCVAR name $2 }
                    60 { ProcessCmdCVAR0 TBLCmdPrint }
                    61 { global cvarname; SIAApply $cvarname 1 }
                    62 { TBLCmdSize $2 $3 }
                    63 { TBLCmdSize [expr ($2+$3)/2.] $4 }
                    64 { TBLCmdSkyframe $2 }
                    65 { ProcessCmdCVAR skyformat $2 }
                    66 { TBLCmdSystem $2 }
                    67 { ProcessCVAR0 TBLUpdate }
                    68 { TBLCmdCoord $1 $2 fk5 }
                    69 { TBLCmdCoord $1 $2 $3 }
                    70 { TBLCmdCoord $1 $2 fk5 }
                    71 { TBLCmdCoord $1 $2 $3 }
                    72 { set _ 2mass }
                    73 { set _ akari }
                    74 { set _ astrowise }
                    75 { set _ cadc }
                    76 { set _ cxc }
                    77 { set _ hla }
                    78 { set _ mast }
                    79 { set _ sdss }
                    80 { set _ skyview }
                    81 { set _ tgssadr }
                }
                unsetupvalues $dc
                # pop off tokens from the stack if normal rule
                if {![info exists rules($rule,e)]} {
                    incr stackpointer -1
                    set state_stack [lrange $state_stack 0 $stackpointer]
                    set value_stack [lrange $value_stack 0 $stackpointer]
                }
                # now do the goto transition
                lappend state_stack $table([lindex $state_stack end]:$ll,target)
                lappend value_stack $_
            }
            accept {
                set accepted 1
            }
            goto -
            default {
                puts stderr "Internal parser error: illegal command $table($state:$token)"
                return 2
            }
        }
    }
    return 0
}

######
# end autogenerated taccle functions
######

proc sia::yyerror {msg} {
     variable yycnt
     variable yy_current_buffer
     variable index_

     ParserError $msg $yycnt $yy_current_buffer $index_
}
