/* Public domain. */

#ifndef SGETOPT_H
#define SGETOPT_H


 /* reentrant */

struct subgetopt_t
{
  int ind ;
  int err ;
  int problem ;
  char const *arg ;
  unsigned int pos ;
  char const *prog ;
} ;

#define SUBGETOPT_ZERO { 1, 1, 0, 0, 0, 0 }

extern int subgetopt_r (int, char const *const *, char const *, struct subgetopt_t *) ;


 /* non-reentrant */

extern int sgetopt_r (int, char const *const *, char const *, struct subgetopt_t *) ;

extern struct subgetopt_t subgetopt_here ;

#define subgetopt(argc, argv, opts) subgetopt_r((argc), (argv), (opts), &subgetopt_here)
#define sgetopt(argc, argv, opts) sgetopt_r((argc), (argv), (opts), &subgetopt_here)
#define sgetopt_prog() (subgetopt_here.prog = PROG)

/* define SUBGETOPTNOSHORT to avoid potential name conflicts */

#ifndef SUBGETOPTNOSHORT
# define getopt sgetopt
# define optarg subgetopt_here.arg
# define optind subgetopt_here.ind
# define opterr subgetopt_here.err
# define optopt subgetopt_here.problem
# define opteof (-1)
#endif

#endif
