#==================================
#
#            setup.py
#  Copyright 2011 - Nathan Osman
#
#==================================

from distutils.core import setup
from glob           import glob
from os             import path

# Enhanced globbing utility
def recursive_glob(install_path, base_folder, pattern):
	
	# This list will store the tuples we generate
	installation_tuples = []
	
	# Grab everything that matches the pattern
	contents = glob(base_folder + '/' + pattern)
	
	# Now enumerate all of the matches and recursively add
	# any folders we come across
	files = []
	
	for entry in contents:
		
		if path.isdir(entry):
			
			# Determine the name of the folder
			basename = path.basename(entry)
			
			# Recursively add this folder
			installation_tuples.extend(recursive_glob(install_path + '/' + basename,
			                                          entry, '*'))
			
		else:
			# It's not a folder so add it to our list of files
			files.append(entry)
	
	# If there are any files, append them here
	if len(files):
		installation_tuples.append((install_path, files))
	
	return installation_tuples

# Collect filenames for the package
def collect_filenames():
	
	# This list will store all of the tuples for installation
	installation_tuples = []
	
	installation_tuples.extend(recursive_glob('/usr/share/stackapplet',      'src',    '*.py'))
	installation_tuples.extend(recursive_glob('/usr/share/stackapplet/html', 'html',   '*'))
	installation_tuples.extend(recursive_glob('/usr/share/pixmaps',          'images', '*'))
	installation_tuples.extend(recursive_glob('/usr/share/locale',           'po',     '*'))
	
	installation_tuples.extend([('/usr/share/applications', ['other/stackapplet.desktop'])])
	
	return installation_tuples

setup(name='stackapplet',
      version='1.5.2',
      description='Notification tool for Stack Exchange sites.',
      author='Nathan Osman',
      author_email='admin@quickmediasolutions.com',
      url='https://launchpad.net/stackapplet',
      license='MIT License',
      data_files=collect_filenames())
