#include <SyFi.h>

using namespace SyFi; 
using namespace std; 

void print_out(FE& fe) { 
    for (unsigned int i=0; i< fe.nbf(); i++) { 
        cout <<"fe.N("<<i<<")        =       "<<fe.N(i)<<endl; 
    }
}

int main() {

    initSyFi(3);  
   
    nsd = 3; 
    ReferenceTetrahedron tetrahedon; 
    Nedelec2Hdiv fe; 
    fe.set_polygon(tetrahedon); 
    fe.set_order(1); 
    fe.compute_basis_functions(); 
    cout <<"-------- 1 order ---------- 3D "<<endl; 
    print_out(fe); 

    fe.set_order(2); 
    fe.compute_basis_functions(); 
    cout <<"-------- 2 order ---------- 3D "<<endl; 
    print_out(fe); 

    fe.set_order(3); 
    fe.compute_basis_functions(); 
    cout <<"-------- 3 order ---------- 3D "<<endl; 
    print_out(fe); 

    fe.set_order(4); 
    fe.compute_basis_functions(); 
    cout <<"-------- 4 order ---------- 3D "<<endl; 
    print_out(fe); 

    return 0; 

}



