Telegram-Purple Unofficial (Beta)
=================================

Telegram-purple is a Libpurple protocol plugin that adds support for the Telegram messenger.

I keep getting many questions about this plugin in my E-mail, so I've created a [telegram group chat](https://bit.ly/2S539ia) for
telegram-purple related discussions or questions.

Installation
------------

If you are just interested in using the plugin you probably want to use one of the following binary distributions. Please note that I do not control most of those package sources and the version may lag behind.

If your platform is not supported or you want to contribute by testing or development, scroll down to "Building form Source".


#### OSX (Adium)

1. Download and execute the [Telegram-Adium bundle] (https://github.com/majn/telegram-purple/releases/download/v1.3.0/telegram-adium-1.3.0.AdiumLibpurplePlugin.zip)
2. Restart Adium

#### Windows

We provide an installer for Windows users:

1. Download and execute the corresponding setup from https://github.com/majn/telegram-purple/releases
2. Restart Pidgin
3. If not detected, restart pidgin again

This installer is built in a different way than previous builds
(specifically, by Eion Robb http://eion.robbmob.com/telegram/),
and may still have some issues.

Specifically, the installer is compressed, so if you have an overzealous anti-virus installed,
the installer may get flagged.

The build is 32-bit, so connecting with Telegram for the first time may take a few moments.

Alternatively, see "Building the Windows Installer" below.

#### Fedora (22, 23)

The package is available in the Fedora 22 and 23 testing repositories:

     dnf config-manager --set-enabled updates-testing
     dnf install purple-telegram


#### Arch Linux (AUR)

https://aur.archlinux.org/packages/telegram-purple/


#### Debian

You can build it from source (see following section) or build a `.deb` file
for your package manager.


Building From Source
--------------------

Below, you will find the instructions for how to build the libpurple protocol plugin from source.

#### 1. Clone

This repository has submodules, so you need to clone recursively.


        git clone --recursive https://github.com/majn/telegram-purple
        cd telegram-purple


#### 1b. Cloning if you're a packager

If you are unsure about whether you need this, then you are not a
packager and don't have any use for this.

If you need an "orig-tarball", it can be generated by `make dist`. Note
that this automatically generates an appropriate version number like
`1.2.4-58-g8e3cebf`. You can truncate the git suffix (`-g8e3cebf`). If
the `-58` part exists, it means that you're using a development
version, which is probably not what you want. If you still want to
package this, please leave the commit number (i.e., `58`) intact, as
this indicates that this version is in fact much further than just
`1.2.4`.


#### 2. Fetch all dependencies

##### Fedora

        sudo dnf install gcc gettext libgcrypt-devel libwebp-devel libpurple-devel zlib-devel


##### Debian / Ubuntu

        sudo apt-get install libgcrypt20-dev libpurple-dev libwebp-dev gettext build-essential


##### OpenSUSE

        sudo zypper install gcc glib glib-devel libpurple libpurple-devel zlib-devel libwebp-devel

And the development files for gcrypt, probably `gcrypt-devel` or something. (FIXME)


#### 3. Compile and install

If libwebp is not available, you can disable sticker support by calling ./configure --disable-libweb instead.
Please note that this is usually not necessary.

        ./configure
        make
        sudo make install


Pulling Updates
---------------

This repository contains submodules, and a simple pull just won't be enough to update all the submodules’ files. Pull new changes with:


        git pull
        git submodule sync # just in case the configuration has changed 
        git submodule update --recursive


Usage
-----

#### First Login

The username is your current phone number, including your full country prefix. For Germany, this would be '+49', resulting in a user name like '+49151123456'. Telegram will verify your phone number by sending you a code via SMS. You will be prompted for this code, once that happens.

#### Buddy List

Like in the official Telegram apps, the displayed buddy list consists of all active conversations.

##### Foreign Users

Foreign users, like for example people you only know through a group chat but never had any conversation with, will not be part of your buddy list by default. You can add those users to the buddy list by clicking on "Add contact..." in the users context menu.

#### Using secret chats

You can use Telegram secret chats with this plugin, they will show up as a new buddy with a '!' in front of the buddy name.

One caveat of secret chats in Telegram is that they can only have one endpoint, this is a limitation of the protocol. This means that if you create a secret chat in Pidgin you will not be able to use that chat on your phone. You will be asked whether to accept each secret chat, so you can always choose to accept the chat on a different device if you want. You can set a default behavior for dealing with secret chats (Accept or Decline) in the account settings, if you don't want that prompt to appear every time.

Self destructive messages will be ignored, since I don't know any way to delete them from the conversation and the history.

##### Confirming the key authenticity

Click on the buddy in the buddy list and click on "Show Info" to visualize the key fingerprint.

##### Initiate secret chats

To initiate a secret chat from Pidgin, click on a Buddy in the Buddy List and hit "Start Secret Chat"

##### Deleting secret chats

If you delete a secret chat from the buddy list, it will be terminated and no longer be usable.


#### Unicode Emojis for Pidgin

The Telegram phone applications for iOS and Android make use of standardized Unicode smileys (called [Emojis](https://en.wikipedia.org/wiki/Emoji)). Pidgin
does not display those smileys natively, but you can install a custom smiley theme like (https://github.com/stv0g/unicode-emoji) or (https://github.com/VxJasonxV/emoji-for-pidgin) and activate it under Settings > Themes > Smiley Theme.


#### Code-Tags

Since 1.3.0 it is possible to write messages in monospaced fonts using the markdown backtick syntax.

##### Example

    ``` if (true) {
        // do smth 
    }```

##### Result

    if (true) {
        // do smth
    }



Building the Adium Plugin
-------------------------

(This part may be a little outdated.)

Compiling with XCode is a little bit problematic, since it requires you to compile Adium first to get the necessary framework files. My advice is to just use the [prebuilt bundle](https://github.com/majn/telegram-purple/releases), but if you really want to do it, follow these steps:

1. Get the Adium source, compile it with XCode and copy the build output into telegram-adium/Frameworks/Adium. It should contain at least Adium.framework, AdiumLibpurple.framework and AIUitilies.framework
2. Open the Adium source code, go to ./Frameworks and copy libglib.framework and libpurple.framework into telegram-adium/Frameworks/Adium
3. Build the tgl submodule and delete libtgl.so from libs/ (it should only contain libtgl.a)
4. Install libwebp, libgcrypt and gnupg with homebrew:

    brew install webp
    brew install libgcrypt libgpg-error

5. If you already downloaded libwebp/libgcrypt in previous builds make sure that the binaries are up-to-date

    brew update
    brew upgrade webp libgcrypt

6. Install with homebrew and move it into the appropriate directory so that XCode can find them. Note that the versions might differ, use the one that is

    mkdir -p ./telegram-adium/Frameworks/Adium
    cp /usr/local/Cellar/webp/0.4.3/lib/libwebp.a ./telegram-adium/Frameworks
    cp /usr/local/Cellar/libgcrypt/1.6.4/lib/libgcrypt.20.dylib ./telegram-adium/Frameworks/Adium
    cp /usr/local/Cellar/libgpg-error/1.20_1/lib/libgpg-error.0.dylib ./telegram-adium/Frameworks/Adium

7. Update the paths in the dylibs, to assure that the resulting binary will load them form within the bundle.

    cd ./telegram-adium/Frameworks/Adium
    install_name_tool -id "@loader_path/../Resources/libgcrypt.20.dylib" ./libgcrypt.20.dylib
    install_name_tool -id "@loader_path/../Resources/libgpg-error.0.dylib" ./libgpg-error.0.dylib
    install_name_tool -change "/usr/local/lib/libgpg-error.0.dylib" "@loader_path/../Resources/libgpg-error.0.dylib" ./libgcrypt.20.dylib

7. Build the XCode-Project and execute the created bundle


Building the Debian Package
---------------------------

If you just need a `.deb`, simply do:

    sudo apt-get install debhelper
    fakeroot ./debian/rules binary

And you're done!  The `telegram-purple_….deb` and `telegram-purple-dbgsym_….deb` files
are in the parent directory.
To show some info about it, try this:

    dpkg --info telegram-purple_*.deb

Please note that installing the debugging symbols (`dbgsym`)
help a lot in troubleshooting, so please do install them, too!

#### Debian Maintainers ####

If you're a maintainer (if you're not sure, then you aren't a
maintainer), you need to produce a lot more files than that.

Here's how you can generate a `.orig.tar.gz`:

    make dist

The following command requires the original tar to exist,
and will build all further files,
specifically `.debian.tar.xz`, `.dsc`, `.deb`, and `.changes`:

    dpkg-buildpackage

If this fails with a cryptic error message,
first make sure that the `….orig.tar` really is in place.

For the upload, you should use `pbuilder` and similar to build the package
in a more minimalistic environment. That covers the official part of the work-flow.

Of course, you can call small parts of the build process directly, in order to avoid
overhead like rebuilding. For example, if you only need the `.debian.tar.xz`
and `.dsc` files, do this:

    make dist
    false # Move tar to parent directory, by hand
    dpkg-source -b .

Note that we no longer actively try to get it into the Debian repository.

Building the Windows Installer
---------------------------

You will need a Debian-ish operating system, and the following packages:

```
apt-get install build-essentials gcc-mingw-w64-i686 libgcrypt-mingw-w64-dev \
        libgpg-error-mingw-w64-dev libz-mingw-w64-dev \
        gettext libgcrypt20-dev libpurple-dev libwebp-dev \
        nsis
```

After that, run the build script:

```
./mkwindows.sh
```

This generates a file like `telegram-purple-1.3.1+gcb96ff77aa.exe`,
which contains everything the Windows users need.


Discussion / Help
-----------------

#### Custom pubkeys

As we want to avoid OpenSSL, it has become necessary to replace the PEM file format. This means that if you use a custom pubkey (which you really REALLY shouldn't be doing), you have to adapt, sorry.

We no longer read the public key of the Telegram servers from a file.
If you really need a different public key, and know what you're doing
(e.g., connecting to some kind of test environment internal to Telegram,
which also is a very bad idea), you need to find the call to `tgl_set_rsa_key_direct` in `telegram-purple.c`,
and provide the key directly by yourself.


FAQ
---

- How do I set telegram-purple up with Bitlbee?
  * A (easy): Use bitlbee-telegram instead.  It is made for bitlbee.
  * A (hard): Mainly just followed the wiki steps:
    - First install bitlbee with purple enabled.  In Arch, use the bitlbee-libpurple aur package.
    - Started the Bitlbee daemon, which runs with the bitlbee user:

          # systemctl start bitlbee.service

    - With any IRC client (e.g., irssi), connect to localhost with `/connect localhost`, then create the account with the commands:

          account add telegram <phone_number_with_region_prefix>
          account telegram on

    This was adapted from https://github.com/majn/telegram-purple/issues/461 . Thanks!

- I receive pictures in a chat, but they aren't showing up
  * A: Make sure that you don't have a plugin like "Conversation Colors" that strips HTML from messages and removes the pictures.

- I receive RPC_CALL_FAIL_401: SESSION REVOKED

  * A: This basically means your session has been terminated but the program
    doesn't handle terminated sessions properly yet. You have to clean the
    ~/.purple/telegram-purple/$PHONENUMBER directory to fix this issue.

    For Arch Linux users that use Bitlbee you can find this directory in
    `/var/lib/bitlbee/purple/telegram-purple/`

#### Group chat

Telegram group chat for telegram-purple or libtgl related discussions or questions:

https://bit.ly/2S539ia


Submitting Bug Reports
----------------------

**IMPORTANT**: if you report bugs PLEASE make sure to always **include as much information as possible**. This should always include **at least the telegram-purple version and (if possible) commit**, where you got telegram-purple from (Source build, package repository, etc.), the Pidgin version (if you use a different messenger please state that too!) and your OS Version.

If you describe some issue please be as precise as possible. Descriptions like "XY doesn't work" will not help me. Describe what you are doing what kind of issue you are experiencing: "If I click on X, Y happens, but instead I would expect Z to happen".

For error reports please include the application logs. To get Pidgin to print a log, [start it from command line, specifying the -d option](https://developer.pidgin.im/wiki/GetABacktrace#TheEasyWay). **ATTENTION**: This log will contain personal information like your phone number, message content or contact or chat names. If you plan on uploading it somewhere public mask those entries in the log.

Bug reports regarding crashes should include a backtrace if possible, there is extended documentation available on [how to get a backtrace for crashes](https://developer.pidgin.im/wiki/GetABacktrace)

Empathy / libtelepathy
----------------------

Empathy doesn't natively support libpurple plugins since its based on libtelepathy, but there is a compatibillity layer called telepathy-haze that can be used to execute libpurple
plugins. This means that you can basically run this plugin thanks to telepathy-haze but you will usually get less features and worse usability compared to real libpurple clients. If you use Empathy (or anything else based on libtelepathy) I recommend [telepathy-morse](https://projects.kde.org/projects/playground/network/telepathy/telepathy-morse/repository) which is a connection manager written specifically for your messenger.

Authors
-------

Telegram-Purple was written by:

    - Matthias Jentsch <mtthsjntsch@gmail.com>
    - Vitaly Valtman
    - Ben Wiederhake <BenWiederhake.GitHub@gmx.de>
    - Christopher Althaus <althaus.christopher@gmail.com>

Acknowledgements
----------------

This software is based on the library [Libtgl](https://github.com/vysheng/tgl), which was written by Vitaly Valtman <mail@vysheng.ru> and others, see (https://github.com/vysheng/tgl/)
