#/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */

#include "../src/defs.h"

#include <vga.h>
#include <vgagl.h>
#include <vgamouse.h>

/* option MECK indicates 16-color mode */
int MECK;

/* globals used by my painting stuff */  
static GraphicsContext offscreen, physicalscreen;
static uchar *offscreenmem, *ptorigin;
static int enablebackground;
static int ofscx1, ofscy1, ofscx2, ofscy2;
static int thegraphmode, oldgraphmode;
static int fontw, fonth, fonts;

/* Function prototypes for ugly font-scaling */
void preparefont(void); 
void closefont(void);
char* expandedfont=NULL;



int (*flip)(void)=vga_flip; 

/* #define DEBUGVGA */

/* debugging makros to report pixel warnings (does not go with PORTRAIT) */
/* #define DEBUGPIXEL */

#ifdef DEBUGPIXEL
#define CPT(apt,mess) \
     if(apt<VBUF || apt>=VBUF+vgaxdim*vgaydim ) \
     {pfprot("(ctp %s)\n",mess); exit(1);}

#define CXY(mess) \
      if(x2<=x1 || y2<=y1) \
        {pfprot("(cxy %s)\n",mess);}

#define CXW(mess) \
      if(w<0 || h<0) \
        {pfprot("(cxw %s)\n",mess);}\

#else /* no debugging */
#define CPT(apt,mess) 
#define CXW(mess) 
#define CXY(mess)
#endif





void vgaclose(void) {
  vga_setmode(oldgraphmode);
  closefont();
  gl_freecontext(&offscreen);                /* does not hurt if not allocated ? */
  if(!MECK) gl_freecontext(&physicalscreen); /* does not hurt if not allocated ? */
#ifndef VGAHASWAITIO
#ifdef LETSTRYGS
  pfprot("\n\
warning: display: use polling when rendering eps-figures due to 
  a compiletime-option. If your svgalib is above version 1.2.10,
  recompiling with \"VGAHASWAITIO\" defined may speed up rendering.\n\n"); 
#endif
#endif
}

void vgaerror(char* mssg)
{
   pfprot("\nfatal error: display: %s\n",mssg);   
   vgaclose();
   exit(1);
}

void vgaopen(void) {  
  vga_init();
  enablebackground=0;
  /* The svgalib doc marks the background stuff as "may work" */
  /* Actually, I dont use the "GOTOBACK" feature. But I've only */
  /* tested with svgalib versions which do support it.          */ 
  /* Anyway, in case of problems disable the backgound by */
  /* undefining LETSTRYBG */
#ifdef LETSTRYBG
#ifdef VGA_GOTOBACK 
  if(vga_runinbackground_version()==1)
      enablebackground=1;
#endif
#endif
}


void setpalette(void) {
  int i,gl;
  /* grey levels for antialising */
  for(i=0;i<COLORS_PER_GREY;i++) {
    gl=(i==0) ? 0: 63 * exp(GAMMA*log(i/(float) (COLORS_PER_GREY-1)));
    if(MECK)  vga_setpalette(COLORS_PER_GREY-1-i,gl,gl,gl);
    else      gl_setpalettecolor(COLORS_PER_GREY-1-i,gl,gl,gl);
  }
  /* other colors for markers, frames etc. */
  if(!MECK) {
    gl_setpalettecolor(SETPALTEXTCOL);           
    gl_setpalettecolor(SETPALTEXTBACKCOL);      
    gl_setpalettecolor(SETPALBORDERCOL);   
    gl_setpalettecolor(SETPALFRAMECOL);    
    gl_setpalettecolor(SETPALRECTCOL);     
    gl_setpalettecolor(SETPALTFMCOL);      
    gl_setpalettecolor(SETPALHREFCOL);     
    gl_setpalettecolor(SETPALMIXEDCOL);     
    gl_setpalettecolor(SETPALMARKSCOL);     
    gl_setpalettecolor(SETPALMARKHCOL);     
    gl_setpalettecolor(SETPALMARKDCOL);     
    gl_setpalettecolor(SETPALFOUNDCOL);     
  } else {
    vga_setpalette(8,PALDRED);   
    vga_setpalette(9,PALDGREEN);   
    vga_setpalette(10,PALDBLUE);   
    vga_setpalette(11,0,0,0);   /* not used */
    vga_setpalette(12,PALLRED);   
    vga_setpalette(13,PALLGREEN);  
    vga_setpalette(14,PALLBLUE);   
    vga_setpalette(15,PALLGREY);  
  }
}

void mysetclip(int x1, int y1, int x2, int y2) {
   if(x1<0) x1=0; if(y1<0) y1=0;
   if(x2>vgaxdim-1) x2=vgaxdim-1;
   if(y2>vgaydim-1) y2=vgaydim-1;
   if(x2<x1 || y2<y1) {
      CXY("clip") 
      x1=0;x2=0;x2=0;y1=0; /* dirty point? should not happen anyway */
   } 
   ofscx1=x1; 
   ofscy1=y1; 
   ofscx2=x2; 
   ofscy2=y2; 
}

void mysetclipof(void) {
   ofscx1=0; 
   ofscy1=0; 
   ofscx2=truevgaxdim-1; 
   ofscy2=truevgaydim-1; 
}


#ifndef PORTRAIT
void myupdate(int x1, int y1, int x2, int y2) {
   if(x1<0) x1=0; if(y1<0) y1=0;
   if(x2>truevgaxdim-1) x2=truevgaxdim-1;
   if(y2>truevgaydim-1) y2=truevgaydim-1;
   if(x2<x1 || y2<y1) return; 

   if(!MECK){
     gl_setcontext(&physicalscreen);
     gl_copyboxfromcontext(&offscreen,x1,y1,x2-x1+1,y2-y1+1,x1,y1);
     gl_setcontext(&offscreen);
   }else{
     x1=x1 & 0xfff8; x2=x2 | 0x0007;  /* make divisible by 8 */
     /* pfprot("(myupdate: vga_copytoplanar16 x1 %d y1 %d x2 %d y2 %d)",
            x1,y1,x2,y2); */
     vga_copytoplanar16(VBUF+y1*BYTEWIDTH+x1, BYTEWIDTH, 
                      (y1*truevgaxdim+x1)>>3, truevgaxdim>>3,
                      x2-x1+1, y2-y1+1);
   }
}
#else  /* portrait displays the other way around ... no MECK !! */
void myupdate(int x1, int y1, int x2, int y2) {
   if(x1<0) x1=0; if(y1<0) y1=0;
   if(x2>truevgaxdim-1) x2=truevgaxdim-1;
   if(y2>truevgaydim-1) y2=truevgaydim-1;
   if(x2<x1 || y2<y1) return; 

   /* pfprot("(myupdate, portrait coordinates x1 %d y1 %d x2 %d y2 %d\n",
            x1,y1,x2,y2); 
   pfprot("           physical coordinates x1 %d y1 %d w %d h %d\n",
            y1,truevgaydim-1-x2,y2-y1+1,x2-x1-1); */

   gl_setcontext(&physicalscreen);
   gl_copyboxfromcontext(&offscreen,y1,truevgaxdim-1-x2, /* (h,v) of topleft */
                                    y2-y1+1,x2-x1+1,     /* (width,height)   */
                                    y1,truevgaxdim-1-x2);/* (h,v) of topleft */
   gl_setcontext(&offscreen);
}
#endif


void vgagraph(void) {
  int n;
  n=0;
  if(vgaxdim==320 && vgaydim==200) n=5;
  if(vgaxdim==640 && vgaydim==480) n=10;
  if(vgaxdim==800 && vgaydim==600) n=11;
  if(vgaxdim==1024 && vgaydim==768) n=12;
  if (n==0 || !vga_hasmode(n)) { 
    n=vga_getdefaultmode();
    if((n!=5 && n!=10 && n!=11 && n!=12) || !vga_hasmode(n)) { 
      pfprot("\n\
warning: display: mode not supported on this machine. Now try -d640x480.
  Check your svgalib configuration.\n");
      n=10; 
    }
  }
  if(vga_hasmode(n)) {
    MECK=0;
  } else {
    MECK=1;
    pfprot("\n\
warning: display: mode -d640x480 not supported at 256 colors. Now try at 
  16 colors. This will reduce display quality and speed. Check your
  svgalib configuration.\n\n");
    n=4; 
    if(!vga_hasmode(n)) {
      pfprot("\n\
warning: display: mode -d640x480 not even supported at 16 colors.\n"); 
      vgaerror("Sorry.");
    }
  }
  thegraphmode=n;
  if(n==5)  {truevgaxdim=320; truevgaydim=200; vgaxdim=320; vgaydim=200;}
  if(n==10 || n==4) {truevgaxdim=640; truevgaydim=480; vgaxdim=640; vgaydim=480;}
  if(n==11) {truevgaxdim=800; truevgaydim=600; vgaxdim=800; vgaydim=600;}
  if(n==12) {truevgaxdim=1024; truevgaydim=768; vgaxdim=1024; vgaydim=768;}

  /* set up the "MECK-dependent-constants" which used to be makros */
  /* these are colors as bytes in the internal buffer */
  if(!MECK){
     COLORS_PER_GREY   =16;      /* should be 2^BITS_PER_GREY */
     WHITECOL          =0;
     BLACKCOL          =(COLORS_PER_GREY-1);
 /* use lots of different values, so you may design a rainbow tmview */     
     BORDERCOL         =COLORS_PER_GREY;
     TEXTCOL           =COLORS_PER_GREY+1;
     TEXTBACKCOL       =COLORS_PER_GREY+2;
     FRAMECOL	       =COLORS_PER_GREY+3;
     TFMCOL            =COLORS_PER_GREY+4;
     RECTCOL           =COLORS_PER_GREY+5;

     BACKCOLS          =COLORS_PER_GREY+16; /* start at least transparent */
     MARKSCOL          =COLORS_PER_GREY+17;
     MARKHCOL          =COLORS_PER_GREY+18;
     FOUNDCOL          =COLORS_PER_GREY+19;
     HREFCOL           =COLORS_PER_GREY+20;
     MARKDCOL          =COLORS_PER_GREY+21;
     MIXEDCOL          =COLORS_PER_GREY+22; /* mixed all                  */

     NUMBER_OF_COLORS  =COLORS_PER_GREY+23; /*number of colors */

  }else{
    /* Now here we are in 16-color mode, and less fexible.              */
    /* set up 8 greylevels, 3 solid colors, 3 transparent and one mixed */
    /* this is hardwired, cause there are no more colors left           */
    /* if you still want to change the colors, change the rgb tripels in*/
    /* the defssvga.h. That is, make PALDRED look yellow or so          */
     COLORS_PER_GREY   =8;               /* use only 8 of 16 greyscales */

     WHITECOL          =0;
     BLACKCOL          =7;
     TEXTCOL           =7; 
     TEXTBACKCOL       =15;  
     FRAMECOL	       =8;   /* dark red */
     BORDERCOL         =9;   /* dark green */
     TFMCOL            =10;  /* dark blue */
     RECTCOL           =10; 

     BACKCOLS          =11;  /* mixing modus only */
     MARKDCOL          =12;  /* light red */
     MARKHCOL          =13;  /* light green */
     FOUNDCOL          =13; 
     MARKSCOL          =14;  /* light blue */
     HREFCOL           =14;  
     MIXEDCOL          =15;  /* mixed all=light grey */

     NUMBER_OF_COLORS  =15;  /*number of colors */
  }

  oldgraphmode=vga_getcurrentmode();
#ifdef HASMOUSE
  vga_setmousesupport(1);
#endif
  /* init physical screen */
  vga_setmode(thegraphmode);
  if(!MECK){
    gl_setcontextvga(thegraphmode); 
    gl_getcontext(&physicalscreen);
    gl_disableclipping();
    setpalette();
    if(enablebackground){
      pfprot("vgaopen: background running enabled.\n");
      vga_runinbackground(1); 
    } else {
#ifdef LETSTRYBG
      pfprot("vgaopen: background running not supported.\n");
#else
      pfprot("vgaopen: background running disabled.\n");
#endif
    }
  }else{ /* MECK */
    setpalette();
  }
  /* init offscreen, always 256-colors */
  if(!MECK){
    if(gl_setcontextvgavirtual(thegraphmode) ==-1) /* this allocates mem */
      vgaerror("libgl: can't allocate virtual context");
    gl_getcontext(&offscreen);
  }else{
    allocmem(&offscreenmem,640L*480L);
    gl_setcontext(&offscreen); /* here, mem is allocated above */
    gl_setcontextvirtual(640,480,1,8,offscreenmem);
  }
  /* init logical screen, might be portrait modus */
#ifndef PORTRAIT
  ptorigin=VBUF;
  #define PTDELTAH (1)
  #define PTDELTAV (BYTEWIDTH)
#else /* Portait-mode : no MECK !!!*/
  if(MECK)
    vgaerror("PORTRAIT not supported in 16 colors mode. Check ./tmview/svga/defssvga.h");
  ptorigin=VBUF+BYTEWIDTH*(truevgaydim-1);
  #define PTDELTAH (-BYTEWIDTH)
  #define PTDELTAV (1)
  /* pfprot("portraitmodue: vbuf %ld origin %ld deltah %d deltav %d\n",
          VBUF,ptorigin,PTDELTAH,PTDELTAV); */
  vgaxdim=truevgaydim;
  vgaydim=truevgaxdim;
  truevgaxdim=vgaxdim;
  truevgaydim=vgaydim;
#endif

  mysetclip(0,0,vgaxdim-1,vgaydim-1);
  preparefont();
  vgastatushight=fonth+fonts;
  vgamaxstatuslines=truevgaydim/vgastatushight;
  vgastatuslen=(truevgaxdim-1)/fontw;
#ifdef HASMOUSE
  mouse_setxrange(-vgaxdim,2*vgaxdim);
  mouse_setyrange(-vgaydim,2*vgaydim);
  mouse_setwrap(MOUSE_NOWRAP);
#endif 
}

/**************************************************************************/
/* scrolling ..                                                           */
/*                                                                        */

#ifndef PORTRAIT
void vgaxscroll(short dx) {  
  if(abs(dx) >= vgaxdim) return;
  if(dx<0) 
    gl_copybox(-dx,0,vgaxdim+dx,vgaydim,0,0);
  else
    gl_copybox(0,0,vgaxdim-dx,vgaydim, dx,0);
}   
void vgayscroll(short dy) {
  if(abs(dy) >= vgaydim) return;   
  if(dy<0) 
    gl_copybox(0,-dy,vgaxdim,vgaydim+dy,0,0);
  else
    gl_copybox(0,0,vgaxdim, vgaydim-dy, 0,dy);
}   
#else /* portrait modus scrolls the other way round */
void vgayscroll(short dy) {  
  if(abs(dy) >= vgaydim) return;
  if(dy<0) 
    gl_copybox(-dy,0,vgaydim+dy,vgaxdim,0,0);
  else
    gl_copybox(0,0,vgaydim-dy,vgaxdim, dy,0);
}
void vgaxscroll(short dx) {
  if(abs(dx) >= vgaxdim) return;   
  if(dx>0) 
    gl_copybox(0,dx,vgaydim,vgaxdim-dx,0,0);
  else
    gl_copybox(0,0,vgaydim, vgaxdim+dx, 0,-dx);
}   
#endif


/**************************************************************************/
/* keys and mice ..                                                       */
/*                                                                        */


/* mini key queue, holds at most one key */
int mode2char=-1; 

int vgawaitio(fd_set * fdsetin, fd_set * fdsetout, struct timeval *timeout) {
#ifdef VGAHASWAITIO
  int sel;
  if(mode2char>=0) return(VGA_KEYEVENT);
  sel=vga_waitevent(VGA_KEYEVENT | VGA_MOUSEEVENT,
     fdsetin, fdsetout, NULL, timeout);
  return(sel);
#else
  return(select(FD_SETSIZE,fdsetin, fdsetout,NULL, timeout));
#endif
}

uchar vgagetchar(int mode) {  
  /*
    mode==0: get next key,  dont block
    mode==1: get next key,  wait
    mode==2: peek next key, dont block
  */
  uchar input,next1,next2,next3;
  uchar com=KEYNOP;
  if(mode2char>=0){
     com=mode2char;  
     if(mode!=2) mode2char=-1;
     return(com);
  }
#ifdef VGAHASWAITIO
  if(mode==1){   /* hang until event occurs */
    vga_waitevent(VGA_KEYEVENT | VGA_MOUSEEVENT, 
       NULL, NULL, NULL, NULL);
  }
#endif
  input = vga_getkey();
  if(input >= ' ' && input < 128) com= input;
  else switch(input) {
    case 9: com=KEYTAB; break;
    case 10: com=KEYRET; break;
    case 27:                           /* escape */
      next1=0; next2=0; next3=0;
      next1=vga_getkey();
      switch(next1) {
      case 91:  
        next2=vga_getkey();
        switch(next2) {
        case '6': com= KEYNEXT;   break; 
        case '5': com= KEYPREV;   break;
        case 'A': com= KEYUP;     break;
        case 'B': com= KEYDOWN;   break;
        case 'D': com= KEYLEFT;   break;
        case 'C': com= KEYRIGHT;  break;
        case 'G': com= KEYCENTER; break;
        case '1': com= KEYHOME;   break;
        case '4': com= KEYEND;    break;
        } 
      break;
      case 0: case 27: com= KEYESC; break; /* allow wild escape abuse */
      default:
      }
    break;
  }  
  /*if(input !=0 && input != 255)
    fprintf(prot,"(vgacommeand: %d %d %d %d)",input,next1,next2,next3);*/
  while(input !=0 && input != 255) input=vga_getkey();
  if(mode==2 && com!=KEYNOP)
    mode2char=com;
  return(com);
}

int omx, omy;

void vgasetmouse(int x, int y) {
  omx=x;
  omy=y;
#ifdef HASMOUSE
  mouse_setposition(x,y);
#endif
}  


void vgagetmouse(int *x, int *y, int *left, int* right) {
#ifdef HASMOUSE
  int button,nmx,nmy;
  mouse_update();
  nmx = mouse_getx();
  nmy = mouse_gety();
  if(abs(nmx-omx) > MOUSESPEED) *x=omx+MOUSESPEED*(nmx-omx);
  else *x=nmx;
  if(abs(nmy-omy) > MOUSESPEED) *y=omy+MOUSESPEED*(nmy-omy);
  else *y=nmy;
  vgasetmouse(*x,*y);
  button = mouse_getbutton();
  *left= (button & MOUSE_LEFTBUTTON);
  *right=(button & MOUSE_RIGHTBUTTON);
#endif
#ifndef HASMOUSE
  *x=omx;
  *y=omy;
  *left=0;
  *right=0;
#endif
}

void vgascreen(int son) {  
}

/**************************************************************************/
/*
   now the pixel copy stuff. 
   destination is allways the offscreen context  
*/

int mydimm(int color, int dimm) {
  return(color>>dimm);
}


void mycopybitsbw(int tx, int ty, int sw, int sh, void* src, int c) {
/* this is with self made clipping. no good  ? */
/* but it will do for all kind of BMUNIT       */
 
  int j,i,supi,supj,mini,minj,sx, skip;
  BMUNIT *srow, *sbmu;
  BMUNIT premask, firstpremask;
  register BMUNIT data, mask;
  short sbmu_wide;
  char *ydest, *xdest;
  uchar blackc;

  /*fprintf(prot,"(vgacopybitmap1 : tx %d ty %d sw %d sh %d, ...\n",
       tx,ty,sw, sh); */                             
  mini=minj=0;
  if(ty<ofscy1) {mini= ofscy1-ty; ty=ofscy1;} 
  if(tx<ofscx1) {minj= ofscx1-tx; tx=ofscx1;} 
  supi= MIN(sh,ofscy2+1-ty+mini);
  supj= MIN(sw,ofscx2+1-tx+minj);
  if(supi <= mini || supj <= minj) {
     /*fprintf(prot,"clipped all away. no drawings)\n"); */
     return;
  }
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;
  /* fprintf(prot,"clipped: tx %d ty %d mi %d si %d mj %d sj %d \n",
     tx,ty,mini,supi,minj,supj); */
  
  blackc=(*vgadimm)(BLACKCOL,c);
  sbmu_wide= ROUNDUP(sw,BITS_PER_BMUNIT);
  skip= minj & (BITS_PER_BMUNIT-1);
  sx= minj >> BITS_LOG2;
  premask = 1 << (BITS_PER_BMUNIT-1);
  firstpremask = premask >> skip;
  
  srow=((BMUNIT*)src)+mini*sbmu_wide+sx;
  for (i = mini;i<supi;i++) {
    xdest=ydest;
    mask = firstpremask;
    sbmu=srow;
    data=*sbmu;
    for (j = minj;j<supj;j++) {       
      CPT(xdest,"copybitbw") 
      if(!mask) {
        mask=premask;
        data= *(++sbmu);
      }
      if(data & mask) *xdest=blackc;
      mask >>= 1;
      xdest+=PTDELTAH;
    }
    srow+=sbmu_wide;
    sbmu=srow;
    ydest+=PTDELTAV;
  }
}



void mycopybitsgs(int tx, int ty, int sw, int sh, void* src, int c) { 
/* this is with self made clipping. no good  ? */
/* but it will do for all kind of BMUNIT       */
/* compatible to gl_putbox                     */

  int j,i,supi,supj,mini,minj,sx, skip;
  BMUNIT *srow, *sbmu;
  BMUNIT premask, firstpremask;
  BMUNIT data, mask;
  short sbmu_wide;
  int rs, firstrs;
  char *ydest, *xdest;
  char paintc, sourcec;

#ifdef DEBUGVGA
  pfprot("(mycopybitsgs : ptr 0x%x tx %d ty %d sw %d sh %d, ...",
       src,tx,ty,sw, sh);                             
  pfprot(" clipping : %d %d %d %d, ...\n",
       ofscx1,ofscy1,ofscx2,ofscy2);
#endif
  mini=minj=0;
  if(ty<ofscy1) {mini= ofscy1-ty; ty=ofscy1;} 
  if(tx<ofscx1) {minj= ofscx1-tx; tx=ofscx1;} 
  supi= MIN(sh,ofscy2+1-ty+mini);
  supj= MIN(sw,ofscx2+1-tx+minj);
  if(supi <= mini || supj <= minj) {
#ifdef DEBUGVGA
     pfprot("clipped all away. no drawings)"); 
#endif
     return;
  }
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;
  /* fprintf(prot,"clipped: tx %d ty %d mi %d si %d mj %d sj %d \n",
     tx,ty,mini,supi,minj,supj); */ 
  
  sbmu_wide= ROUNDUP(sw << GREYSCALE_LOG2,BITS_PER_BMUNIT);
  skip= minj & ((BITS_PER_BMUNIT>>GREYSCALE_LOG2)-1);
  sx= minj >> (BITS_LOG2-GREYSCALE_LOG2);
  premask = ((1<<GREYSCALE)-1) << (BITS_PER_BMUNIT-GREYSCALE);
  firstpremask = premask >> (skip<< GREYSCALE_LOG2);
  firstrs = BITS_PER_BMUNIT-GREYSCALE - skip*GREYSCALE;

  srow=((BMUNIT*)src)+mini*sbmu_wide+sx;
  for (i = mini;i<supi;i++) {
    xdest=ydest;
    mask = firstpremask;
    rs = firstrs;
    sbmu=srow;
    data=*sbmu;
    for (j = minj;j<supj;j++) {
      CPT(xdest,"copybitgs") 
      if(!mask) {
        mask=premask;
        rs=BITS_PER_BMUNIT-GREYSCALE;
        data= *(++sbmu); 
      }
      /* pfprot("- ptr 0x%x data %d -",xdest,((data &mask)>>rs));  */
#ifndef LETSTRYCOLOR
      (*xdest) |= ((data & mask) >> rs); /* sleezy but fast ..(rs+c)*/
#else
      if((paintc=(data & mask) >> (rs+c))){
        if((sourcec=(*xdest) & (COLORS_PER_GREY-1))){
          if((paintc+=sourcec)>COLORS_PER_GREY-1) paintc=COLORS_PER_GREY-1;
          (*xdest) &= ~(COLORS_PER_GREY-1);
	}
        (*xdest) |=paintc;
      }
#endif
      mask >>= GREYSCALE;
      rs-=GREYSCALE;
      xdest+=PTDELTAH;
    }
    srow+=sbmu_wide;
    sbmu=srow;
    ydest+=PTDELTAV;
  }
#ifdef DEBUGVGA
    pfprot("done)"); 
#endif
}


void mycopybits88(int tx, int ty, int sw, int sh, char* src) { 
/* this is with self made clipping. no good  ? */
/* copy bytes to bytes                         */
/* compatible to gl_putbox                     */

  int j,i,supi,supj,mini,minj;
  char *srow, *sbmu;
  char *ydest, *xdest;



  mini=minj=0;
  if(ty<ofscy1) {mini= ofscy1-ty; ty=ofscy1;} 
  if(tx<ofscx1) {minj= ofscx1-tx; tx=ofscx1;} 
  supi= MIN(sh,ofscy2+1-ty+mini);
  supj= MIN(sw,ofscx2+1-tx+minj);
  if(supi <= mini || supj <= minj) {
     /* fprintf(prot,"clipped all away. no drawings)\n"); */
     return;
  }
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;
  /* pfprot("(copy 88 clipped: tx %d ty %d mi %d si %d mj %d sj %d \n",
     tx,ty,mini,supi,minj,supj); */ 
  
  srow= src+mini*sw+minj;
  for (i = mini;i<supi;i++) {
    xdest=ydest;
    sbmu=srow;
    for (j = minj;j<supj;j++) {
      *xdest = *sbmu;
      xdest+=PTDELTAH;
      sbmu++;
    }
    srow+=sw;
    ydest+=PTDELTAV;
  }
  /* pfprot("(done 88)\n");*/
}


void myfillboxor(int tx, int ty, int w, int h, int c) {
 
  char *ydest, *xdest;
  char sourcec, paintc;
  int i;

  /*pfprot("(vgafillboxor : tx %d ty %d sw %d sh %d c %d, ...\n",
    tx,ty,w,h,c); */                             
  if(ty<ofscy1) {h-=ofscy1-ty;  ty=ofscy1;} 
  if(tx<ofscx1) {w-=ofscx1-tx; tx=ofscx1;} 
  if(ty+h>ofscy2+1) h=ofscy2+1-ty;
  if(tx+w>ofscx2+1) w=ofscx2+1-tx;
  if(w <= 0 || h<= 0 || c==0) {
     /*fprintf(prot,"clipped all away or white. no drawings)\n"); */
     return;
  }
  CXW("rector");
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;
  /* fprintf(prot,"clipped or box: tx %d ty %d w %d h %d   \n",
     tx,ty,w,h); */ 
  paintc=0;
  for (;h>0;h--) {
    xdest=ydest; 
    for (i=w;i>0;i--) {
       CPT(xdest,"rector")                
#ifndef LETSTRYCOLOR
       (*xdest)|=c; /* sleezy but fast    */
#else
       if((sourcec=(*xdest) & (COLORS_PER_GREY-1))){
         if((paintc =c+sourcec)>COLORS_PER_GREY-1) paintc=COLORS_PER_GREY-1;
         (*xdest) &= ~(COLORS_PER_GREY-1);
         (*xdest) |=paintc;
       } else {
         (*xdest) |=c;
       }
#endif
       xdest+=PTDELTAH;
    }
    ydest+=PTDELTAV;
  }
}

void myfillboxbg(int tx, int ty, int w, int h, int c) {
 
  char *ydest;
  int i;
  register char *xdest;
  register char xdc;
  /* fprintf(prot,"(vgafillboxor : tx %d ty %d w %d h %d, ...\n",
       tx,ty,w,h); */                              
  if(ty<ofscy1) {h-=ofscy1-ty;  ty=ofscy1;} 
  if(tx<ofscx1) {w-=ofscx1-tx; tx=ofscx1;} 
  if(ty+h>ofscy2+1) h=ofscy2+1-ty;
  if(tx+w>ofscx2+1) w=ofscx2+1-tx;
  if(tx+w>vgaxdim) w=vgaxdim-tx;
  if(w <= 0 || h<= 0) {
     /*fprintf(prot,"clipped all away. no drawings)\n"); */
     return;
  }
  CXW("rectbg");
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;

  /* fprintf(prot,"clipped bgbox : tx %d ty %d w %d h %d   \n",
     tx,ty,w,h); */

  for (;h>0;h--) {
    xdest=ydest;
    for (i=w;i>0;i--) {      
      CPT(xdest,"rectbg")
      xdc=*xdest; 
      if(xdc) {      
	/*if(xdc>c) *xdest=c;*/                   /* transparent modus */     
        if(xdc>BACKCOLS && xdc!= c) *xdest=MIXEDCOL;   /* mixing modus */  
      } else *xdest=c;
      xdest+=PTDELTAH;
    }
    ydest+=PTDELTAV;
  }
}


void myfillbox(int tx, int ty, int w, int h, int c) {
 
  char *ydest;
  int i;
  register char *xdest;
  /* fprintf(prot,"(vgafillbox : tx %d ty %d w %d h %d, ...\n",
       tx,ty,w,h); */                              
  if(ty<ofscy1) {h-=ofscy1-ty;  ty=ofscy1;} 
  if(tx<ofscx1) {w-=ofscx1-tx; tx=ofscx1;} 
  if(ty+h>ofscy2+1) h=ofscy2+1-ty;
  if(tx+w>ofscx2+1) w=ofscx2+1-tx;
  if(tx+w>vgaxdim) w=vgaxdim-tx;
  if(w <= 0 || h<= 0) {
     /*fprintf(prot,"clipped all away. no drawings)\n"); */
     return;
  }
  CXW("rectbg");
  ydest=ptorigin+ty*PTDELTAV+tx*PTDELTAH;

  /* pfprot("clipped box : tx %d ty %d w %d h %d   \n",
     tx,ty,w,h); */

  for (;h>0;h--) {
    xdest=ydest;
    for (i=w;i>0;i--) {      
      CPT(xdest,"rectbg")
      (*(xdest))=c; 
      xdest+=PTDELTAH;
    }     
    ydest+=PTDELTAV;
  }
}

  
int vgasetstatuslines(int n) {
  /* pfprot("(setstatus %d ... \n",n); */
  vgastatuslines=MAX(0,MIN(vgamaxstatuslines,n));
  vgaydim= truevgaydim- vgastatuslines* vgastatushight;
  vgaxdim= truevgaxdim;

  mysetclipof();   /* not clipped !! */
  if(vgastatuslines!=vgamaxstatuslines)
  myfillbox(0,vgaydim,truevgaxdim,vgastatuslines*vgastatushight,TEXTBACKCOL);
  else
  myfillbox(0,0,truevgaxdim,truevgaydim,TEXTBACKCOL);
  myupdate(0,0,vgaxdim-1,truevgaydim-1);
  mysetclip(0,0,vgaxdim-1,vgaydim-1);
  return(vgastatuslines);
  /* pfprot("... done setstatus)\n"); */
}

void vgaupdatestatus(void) {
  mysetclipof();
  myupdate(0, vgaydim,truevgaxdim-1,truevgaydim-1); 
  mysetclip(0,0,vgaxdim-1,vgaydim-1);
}


void vgadrawstatus(char chr, int line, int pos) {
  if(line>=vgastatuslines || line <0) return;
  if(pos>=vgastatuslen || pos <0) return;
  mysetclipof();
  /* chr=(line&0x0f)*16 + (pos&0x0f); *//* test charset */
  mycopybits88(pos*fontw+1, vgaydim+(line+1)* vgastatushight-fonth, 
        fontw, fonth, expandedfont + (unsigned char) chr *fonth*fontw);
  mysetclip(0,0,vgaxdim-1,vgaydim-1); 
  /* pfprot("(vgadrawstatus [%c] l %d p %d )",chr,line,pos); */ 
}



void (*vgaupdate)(int, int, int, int) = myupdate;
void (*vgasetclip)(int, int, int, int) = mysetclip;
void (*vgadrawrect)(int x, int y, int w, int h, int c) = myfillbox; 
void (*vgadrawrector)(int x, int y, int w, int h, int c) = myfillboxor; 
void (*vgadrawrectbg)(int x, int y, int w, int h, int c) = myfillboxbg; 
int  (*vgadimm)(int, int) = mydimm;
void (*vgacopybitmapgs)(int x,int y,int w,int h,void* src,int c)=mycopybitsgs; 
void (*vgacopybitmapbw)(int x,int y,int w,int h,void* src,int c)=mycopybitsbw;


/***************************************************************************/
/* now the font stuff ...                                                  */

/* #include "9x14thin.h" */
/* #include "gekl9x16.h" */
#include "font9x16.h" 

/* now the pronounced ugly fontscaling code: */

void preparefont(void) {
  long i;
  fonth=FONTH;
  fontw=FONTW;
  fonts=FONTS;
  allocmem(&expandedfont,256L*fontw*fonth);
  gl_expandfont(fontw,fonth,TEXTCOL,tmviewfont,expandedfont);
  for(i=0;i<256L*fontw*fonth;i++)
    if(expandedfont[i]==0) expandedfont[i]=TEXTBACKCOL;
}    

void closefont(void) {
  freemem(&expandedfont);
}


