/*
 *	HEADER FILE FOR TWCLOCK
 */

#ifndef TWCLOCK_H_INCLUDED
#define TWCLOCK_H_INCLUDED

#include "libCW.h"
#include <time.h> 
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/FileSB.h>
#include <Xm/DialogS.h>
#include <Xm/ToggleB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>
#include "../config.h"

#define MAKE_ICON  1

#define LOCAL_BTN  0
#define GMT_BTN    1
#define OTHERS_BTN 2
#define SET_TIMER_BTN 3
#define ID_NOW_BTN 4
#define HELP_BTN 5
#define QRT 6

#define ABOUT_DIAG  0
#define HELP_DIAG   1
#define CANCEL_BTN  1

/*
 * APPLICATION DEFINED RESOURCES
 */
#define XmNtzone           "tzone"
#define XmCTzone           "Tzone"

#define XmNblink           "blink"
#define XmCBlink           "Blink"

#define XmNbeep            "beep"
#define XmCBeep            "Beep"

#define XmNcwID            "cwID"
#define XmCCwID            "CwID"

#define XmNcwStr           "cwStr"
#define XmCCwStr           "CwStr"

#define XmNkeyMode         "keyMode"
#define XmCKeyMode         "KeyMode"

#define XmNcwSpeed         "cwSpeed"
#define XmCCwSpeed         "CwSpeed"

#define XmNcwTone          "cwTone"
#define XmCCwTone          "CwTone"

#define XmNautoReset       "autoReset"
#define XmCAutoReset       "AutoReset"

#define XmNautobeeps       "autobeeps"
#define XmCAutobeeps       "Autobeeps"

#define XmNflashColor      "flashColor"
#define XmCFlashColor      "FlashColor"

#define XmNminutes         "minutes"
#define XmCMinutes         "Minutes"

#define XmNseconds         "seconds"
#define XmCSeconds         "Seconds"

typedef struct
   {
      long    tzone;
      int     blink;
      int     beep;
      int     cwID;
      char    *cwStr;
		int     keyMode;
      int     cwSpeed;
      int     cwTone;
      int     autoReset;
      int     autobeeps;
      Pixel   flashColor;
      int     minutes;
      int     seconds;
   } AppRes;

/*
 * Globals and Forward Declarations
 */
XtAppContext app;
AppRes appRes;

int    post_from;
Widget clock_shell;
Widget call_toggleB;
Widget hr_scale;
Widget min_scale;
Widget sec_scale;
Widget date_label;

int doit;
int count;
int flashFlag;
int cwIDdone;
XtIntervalId alarm_id;
XtIntervalId auto_id;
XtIntervalId time_id;

void build_widgets (void);
void input_event (Widget, XtPointer, XEvent *, Boolean *);
void popup_cb (Widget, XtPointer, XtPointer);
void help_cas_cb (Widget w, XtPointer client_data, XtPointer cbs);
void popup_about (void);
void popup_help (void);
void TBchangeCB (Widget, XtPointer, XtPointer);
void optionsCB (Widget, XtPointer, XtPointer);
void scalesCB (Widget, XtPointer, XtPointer);
void alarm_timer (void);
void gettime (void);
void fsbOkCB (Widget , XtPointer, XtPointer);
void fsbCancelCB (Widget , XtPointer, XtPointer);
void timerOkCB (Widget , XtPointer, XtPointer);
void timerModVerCB (Widget , XtPointer, XtPointer);
void errorDiag (Widget, char *, int);
void errOkCB (Widget , XtPointer, XtPointer);
void errCancelCB (Widget , XtPointer, XtPointer);
void settimer (void);

#endif




