//
// Copyright 2023 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: rf_sync_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // SYNC_1_REG                         : 0x0 (ctrlport_to_i2c_sync_ctrl.v)
  // SYNC_2_REG                         : 0x4 (ctrlport_to_i2c_sync_ctrl.v)
  // SYNC_3_REG                         : 0x8 (ctrlport_to_i2c_sync_ctrl.v)
  // SYNC_4_REG                         : 0xC (ctrlport_to_i2c_sync_ctrl.v)
  // SYNC_5_REG                         : 0x10 (ctrlport_to_i2c_sync_ctrl.v)
  // RFS_EN_REG                         : 0x14 (ctrlport_to_i2c_sync_ctrl.v)
  // SETUP_REG/SETUP_STATUS_REG         : 0x18 (ctrlport_to_i2c_sync_ctrl.v, ctrlport_to_i2c_sync_ctrl.v)
  // CONFIG_IO_REG/CONFIG_IO_STATUS_REG : 0x1C (ctrlport_to_i2c_sync_ctrl.v, ctrlport_to_i2c_sync_ctrl.v)

//===============================================================================
// RegTypes
//===============================================================================

  // SYNC_SWITCH Type (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_SWITCH_SIZE = 32;
  localparam SYNC_SWITCH_MASK = 32'h7;
  localparam CONTROL_PIN_V1_SIZE = 1;  //SYNC_SWITCH:CONTROL_PIN_V1
  localparam CONTROL_PIN_V1_MSB  = 0;  //SYNC_SWITCH:CONTROL_PIN_V1
  localparam CONTROL_PIN_V1      = 0;  //SYNC_SWITCH:CONTROL_PIN_V1
  localparam CONTROL_PIN_V2_SIZE = 1;  //SYNC_SWITCH:CONTROL_PIN_V2
  localparam CONTROL_PIN_V2_MSB  = 1;  //SYNC_SWITCH:CONTROL_PIN_V2
  localparam CONTROL_PIN_V2      = 1;  //SYNC_SWITCH:CONTROL_PIN_V2
  localparam CONTROL_PIN_V3_SIZE = 1;  //SYNC_SWITCH:CONTROL_PIN_V3
  localparam CONTROL_PIN_V3_MSB  = 2;  //SYNC_SWITCH:CONTROL_PIN_V3
  localparam CONTROL_PIN_V3      = 2;  //SYNC_SWITCH:CONTROL_PIN_V3

//===============================================================================
// Register Group RF_SYNC_REGISTERS
//===============================================================================

  // Enumerated type IO_EXPANDER_REGISTER_ADRS
  localparam IO_EXPANDER_REGISTER_ADRS_SIZE = 8;
  localparam IO_EXP_INPUT_PORT0_REG    = 'h0;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_INPUT_PORT0_REG
  localparam IO_EXP_INPUT_PORT1_REG    = 'h1;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_INPUT_PORT1_REG
  localparam IO_EXP_OUTPUT_PORT0_REG   = 'h2;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_OUTPUT_PORT0_REG
  localparam IO_EXP_OUTPUT_PORT1_REG   = 'h3;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_OUTPUT_PORT1_REG
  localparam IO_EXP_POLARITY_INV0_REG  = 'h4;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_POLARITY_INV0_REG
  localparam IO_EXP_POLARITY_INV1_REG  = 'h5;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_POLARITY_INV1_REG
  localparam IO_EXP_CONFIG0_REG        = 'h6;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_CONFIG0_REG
  localparam IO_EXP_CONFIG1_REG        = 'h7;  // IO_EXPANDER_REGISTER_ADRS:IO_EXP_CONFIG1_REG

  // SYNC_1_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_1_REG = 'h0; // Register Offset
  localparam SYNC_1_REG_SIZE = 32;  // register width in bits

  // SYNC_2_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_2_REG = 'h4; // Register Offset
  localparam SYNC_2_REG_SIZE = 32;  // register width in bits

  // SYNC_3_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_3_REG = 'h8; // Register Offset
  localparam SYNC_3_REG_SIZE = 32;  // register width in bits

  // SYNC_4_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_4_REG = 'hC; // Register Offset
  localparam SYNC_4_REG_SIZE = 32;  // register width in bits

  // SYNC_5_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SYNC_5_REG = 'h10; // Register Offset
  localparam SYNC_5_REG_SIZE = 32;  // register width in bits

  // RFS_EN_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam RFS_EN_REG = 'h14; // Register Offset
  localparam RFS_EN_REG_SIZE = 32;  // register width in bits
  localparam RFS_EN_REG_MASK = 32'h1;
  localparam RFS_EN_PIN_SIZE = 1;  //RFS_EN_REG:RFS_EN_PIN
  localparam RFS_EN_PIN_MSB  = 0;  //RFS_EN_REG:RFS_EN_PIN
  localparam RFS_EN_PIN      = 0;  //RFS_EN_REG:RFS_EN_PIN

  // SETUP_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SETUP_REG = 'h18; // Register Offset
  localparam SETUP_REG_SIZE = 32;  // register width in bits
  localparam SETUP_REG_MASK = 32'h1;
  localparam SETUP_TRIG_SIZE = 1;  //SETUP_REG:SETUP_TRIG
  localparam SETUP_TRIG_MSB  = 0;  //SETUP_REG:SETUP_TRIG
  localparam SETUP_TRIG      = 0;  //SETUP_REG:SETUP_TRIG

  // SETUP_STATUS_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam SETUP_STATUS_REG = 'h18; // Register Offset
  localparam SETUP_STATUS_REG_SIZE = 32;  // register width in bits
  localparam SETUP_STATUS_REG_MASK = 32'h1;
  localparam SETUP_STATUS_SIZE = 1;  //SETUP_STATUS_REG:SETUP_STATUS
  localparam SETUP_STATUS_MSB  = 0;  //SETUP_STATUS_REG:SETUP_STATUS
  localparam SETUP_STATUS      = 0;  //SETUP_STATUS_REG:SETUP_STATUS

  // CONFIG_IO_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam CONFIG_IO_REG = 'h1C; // Register Offset
  localparam CONFIG_IO_REG_SIZE = 32;  // register width in bits
  localparam CONFIG_IO_REG_MASK = 32'h1;
  localparam CONFIG_IO_TRIG_SIZE = 1;  //CONFIG_IO_REG:CONFIG_IO_TRIG
  localparam CONFIG_IO_TRIG_MSB  = 0;  //CONFIG_IO_REG:CONFIG_IO_TRIG
  localparam CONFIG_IO_TRIG      = 0;  //CONFIG_IO_REG:CONFIG_IO_TRIG

  // CONFIG_IO_STATUS_REG Register (from ctrlport_to_i2c_sync_ctrl.v)
  localparam CONFIG_IO_STATUS_REG = 'h1C; // Register Offset
  localparam CONFIG_IO_STATUS_REG_SIZE = 32;  // register width in bits
  localparam CONFIG_IO_STATUS_REG_MASK = 32'h1;
  localparam CONFIG_IO_STATUS_SIZE = 1;  //CONFIG_IO_STATUS_REG:CONFIG_IO_STATUS
  localparam CONFIG_IO_STATUS_MSB  = 0;  //CONFIG_IO_STATUS_REG:CONFIG_IO_STATUS
  localparam CONFIG_IO_STATUS      = 0;  //CONFIG_IO_STATUS_REG:CONFIG_IO_STATUS
