/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : gksmc
 *
 * FILE     : annexe.h
 *
 * CONTENTS : This contains definitions for each legal Annex E item
 *	      number, so items can be referred to by name.
 *
 * DATE     : 17th March 1988
 *
 *----------------------------------------------------------------------
 */

/* E.5 Control items */
#define END_ITEM	0
#define CLEAR_WKS	1
#define REDRAW_SEGS	2
#define UPDATE_WKS	3
#define DEF_STATE	4
#define MESSAGE		5
#define ESCAPE		6

/* E.6 Items for output primitives */
#define POLYLINE	11
#define POLYMARKER	12
#define TEXT		13
#define FILL_AREA	14
#define CELL_ARRAY	15
#define GDP		16

/* E.7 Items for output primitive attributes */
#define LINE_INDEX	21
#define LINE_TYPE	22
#define LINE_WIDTH	23
#define LINE_COLOUR	24
#define MARKER_INDEX	25
#define MARKER_TYPE	26
#define MARKER_SIZE	27
#define MARKER_COLOUR	28
#define TEXT_INDEX	29
#define TEXT_FONT_PREC	30
#define CHAR_EXP	31
#define CHAR_SPACING	32
#define TEXT_COLOUR	33
#define CHAR_VECTORS	34
#define TEXT_PATH	35
#define TEXT_ALIGN	36
#define FILL_INDEX	37
#define FILL_INT_STYLE	38
#define FILL_STYLE_IND	39
#define FILL_COLOUR	40
#define PATT_VECTORS	41
#define PATT_REF_POINT	42
#define ASF		43
#define PICK_ID		44

/* E.8 Items for workstation attributes */
#define POLYLINE_REP	51
#define MARKER_REP	52
#define TEXT_REP	53
#define FILL_AREA_REP	54
#define PATT_REP	55
#define COLOUR_REP	56

/* E.9 Items for transformations */
#define CLIP_RECT	61
#define WKS_WINDOW	71
#define WKS_VIEWPORT	72

/* E.10 Items for segment manipulation */
#define CREATE_SEG	81
#define CLOSE_SEG	82
#define RENAME_SEG	83
#define DELETE_SEG	84

/* E.11 Items for segment attributes */
#define SET_SEG_TRANS	91
#define SET_VISIBILITY	92
#define SET_HIGHLIGHT	93
#define SET_SEG_PRI	94
#define SET_DETECT	95


