.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
gleidescope \- a tiled OpenGL kaleidescope
.SH SYNOPSIS
.B gleidescope
[\-\-display \fIhost:display.screen\fP]
[\-\-visual \fIvisual\fP]
[\-\-window]
[\-\-root]
[\-\-window\-id \fInumber\fP]
[-delay \fInumber\fP]
[-move]
[-rotate]
[-zoom]
[-image \fIfile\fP]
[-fps]
[-size \fInumber\fP]
[-duration \fInumber\fP]
.SH DESCRIPTION
A tiled kaleidescope using OpenGL.
.SH OPTIONS
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds.).
.TP 8
.B \-\-move
Move the camera.
.TP 8
.B \-\-rotate
Rotate the camera.
.TP 8
.B \-\-zoom
Zoom the camera in and out.
.TP 8
.B \-\-image \fIfile\fP
The texture map to use at the end of the kaleidescope.
.TP 8
.B \-\-fps
Display the current frame rate, CPU load, and polygon count.
.TP 8
.B \-\-size \fInumber\fP
The size of the hexagons being displayed [1(small)-10(large)]
.TP 8
.B \-\-duration \fInumber\fP
The time in seconds before another image is chosen.
.TP 8
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2003 by Andrew Dean  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Andrew Dean.
