/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name: filee.c
 * Abstract:    File extension word set
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include "yforth.h"
#include "file.h"
#include "filee.h"

/**************************************************************************/
/* VARIABLES **************************************************************/
/**************************************************************************/

extern Char file_name[];

/**************************************************************************/
/* WORDS ******************************************************************/
/**************************************************************************/

void _file_status() {
	register FILE *f;
	get_file_name();
	f = fopen(file_name, "rb");
	*--sp = 0;
	if (f) {
		*--sp = 0;
		fclose(f);
	} else *--sp = errno;
}

void _flush_file() {
	register FILE *f = (FILE *) *sp;
	if (fflush(f)) sp[0] = errno;
	else sp[0] = 0;
}

void _rename_file() {
	register Char *file_name2;
	get_file_name();
	file_name2 = (Char *) malloc(strlen(file_name) + 1);
	if (file_name2) {
		strcpy(file_name2, file_name);
		get_file_name();
		if (rename(file_name, file_name2)) *--sp = errno;
		else *--sp = 0;
		free(file_name2);
	} else *--sp = errno;
}


