" Vim syntax file
" Language:	Lynx configuration file (lynx.cfg)
" Maintainer:	Doug Kearns <dougkearns@gmail.com>
" URL:		http://gus.gscit.monash.edu.au/~djkea2/vim/syntax/lynx.vim
" Last Change:	2007 Mar 20

" Lynx 2.8.5

if exists("b:current_syntax")
  finish
endif

let s:cpo_save = &cpo
set cpo&vim

syn match   lynxLeadingWS  "^\s*" transparent nextgroup=lynxOption

syn match   lynxComment    "\(^\|\s\+\)#.*$" contains=lynxTodo

syn keyword lynxTodo	   TODO NOTE FIXME XXX contained

syn match   lynxDelimiter  ":" contained nextgroup=lynxBoolean,lynxNumber

syn case ignore
syn keyword lynxBoolean    TRUE FALSE contained
syn case match

syn match   lynxNumber	   "-\=\<\d\+\>" contained

syn case ignore
syn keyword lynxOption ACCEPT_ALL_COOKIES ALERTSECS ALWAYS_RESUBMIT_POSTS ALWAYS_TRUSTED_EXEC ASSUME_CHARSET
		     \ ASSUMED_COLOR ASSUMED_DOC_CHARSET_CHOICE ASSUME_LOCAL_CHARSET ASSUME_UNREC_CHARSET AUTO_UNCACHE_DIRLISTS
		     \ BIBP_BIBHOST BIBP_GLOBAL_SERVER BLOCK_MULTI_BOOKMARKS BOLD_H1 BOLD_HEADERS
		     \ BOLD_NAME_ANCHORS CASE_SENSITIVE_ALWAYS_ON CHARACTER_SET CHARSETS_DIRECTORY CHARSET_SWITCH_RULES
		     \ CHECKMAIL COLLAPSE_BR_TAGS COLOR CONNECT_TIMEOUT COOKIE_ACCEPT_DOMAINS
		     \ COOKIE_FILE COOKIE_LOOSE_INVALID_DOMAINS COOKIE_QUERY_INVALID_DOMAINS COOKIE_REJECT_DOMAINS COOKIE_SAVE_FILE
		     \ COOKIE_STRICT_INVALID_DOMAINS CSO_PROXY CSWING_PATH DEBUGSECS DEFAULT_BOOKMARK_FILE
		     \ DEFAULT_CACHE_SIZE DEFAULT_EDITOR DEFAULT_INDEX_FILE DEFAULT_KEYPAD_MODE DEFAULT_KEYPAD_MODE_IS_NUMBERS_AS_ARROWS
		     \ DEFAULT_USER_MODE DEFAULT_VIRTUAL_MEMORY_SIZE DIRED_MENU DISPLAY_CHARSET_CHOICE DOWNLOADER
		     \ EMACS_KEYS_ALWAYS_ON ENABLE_LYNXRC ENABLE_SCROLLBACK EXTERNAL FINGER_PROXY
		     \ FOCUS_WINDOW FORCE_8BIT_TOUPPER FORCE_COOKIE_PROMPT FORCE_EMPTY_HREFLESS_A FORCE_SSL_COOKIES_SECURE
		     \ FORCE_SSL_PROMPT FORMS_OPTIONS FTP_PASSIVE FTP_PROXY GLOBAL_EXTENSION_MAP
		     \ GLOBAL_MAILCAP GOPHER_PROXY GOTOBUFFER HELPFILE HIDDEN_LINK_MARKER
		     \ HISTORICAL_COMMENTS HTMLSRC_ATTRNAME_XFORM HTMLSRC_TAGNAME_XFORM HTTP_PROXY HTTPS_PROXY
		     \ INCLUDE INFOSECS JUMPBUFFER JUMPFILE JUMP_PROMPT
		     \ JUSTIFY JUSTIFY_MAX_VOID_PERCENT KEYBOARD_LAYOUT KEYMAP LEFTARROW_IN_TEXTFIELD_PROMPT
		     \ LIST_FORMAT LIST_NEWS_DATES LIST_NEWS_NUMBERS LOCAL_DOMAIN LOCALE_CHARSET
		     \ LOCAL_EXECUTION_LINKS_ALWAYS_ON LOCAL_EXECUTION_LINKS_ON_BUT_NOT_REMOTE LOCALHOST_ALIAS LYNXCGI_DOCUMENT_ROOT LYNXCGI_ENVIRONMENT
		     \ LYNX_HOST_NAME LYNX_SIG_FILE MAIL_ADRS MAIL_SYSTEM_ERROR_LOGGING MAKE_LINKS_FOR_ALL_IMAGES
		     \ MAKE_PSEUDO_ALTS_FOR_INLINES MESSAGESECS MINIMAL_COMMENTS MULTI_BOOKMARK_SUPPORT NCR_IN_BOOKMARKS
		     \ NEWS_CHUNK_SIZE NEWS_MAX_CHUNK NEWS_POSTING NEWSPOST_PROXY NEWS_PROXY
		     \ NEWSREPLY_PROXY NNTP_PROXY NNTPSERVER NO_DOT_FILES NO_FILE_REFERER
		     \ NO_FORCED_CORE_DUMP NO_FROM_HEADER NO_ISMAP_IF_USEMAP NONRESTARTING_SIGWINCH NO_PROXY
		     \ NO_REFERER_HEADER NO_TABLE_CENTER NUMBER_FIELDS_ON_LEFT NUMBER_LINKS_ON_LEFT OUTGOING_MAIL_CHARSET
		     \ PARTIAL PARTIAL_THRES PERSISTENT_COOKIES PERSONAL_EXTENSION_MAP PERSONAL_MAILCAP
		     \ PREFERRED_CHARSET PREFERRED_LANGUAGE PREPEND_BASE_TO_SOURCE PREPEND_CHARSET_TO_SOURCE PRETTYSRC
		     \ PRETTYSRC_SPEC PRETTYSRC_VIEW_NO_ANCHOR_NUMBERING PRINTER QUIT_DEFAULT_YES REFERER_WITH_QUERY
		     \ REPLAYSECS REUSE_TEMPFILES RULE RULESFILE SAVE_SPACE
		     \ SCAN_FOR_BURIED_NEWS_REFS SCREEN_SIZE SCROLLBAR SCROLLBAR_ARROW SEEK_FRAG_AREA_IN_CUR
		     \ SEEK_FRAG_MAP_IN_CUR SET_COOKIES SHOW_CURSOR SHOW_KB_NAME SHOW_KB_RATE
		     \ SNEWSPOST_PROXY SNEWS_PROXY SNEWSREPLY_PROXY SOFT_DQUOTES SOURCE_CACHE
		     \ SOURCE_CACHE_FOR_ABORTED STARTFILE STRIP_DOTDOT_URLS SUBSTITUTE_UNDERSCORES SUFFIX
		     \ SUFFIX_ORDER SYSTEM_EDITOR SYSTEM_MAIL SYSTEM_MAIL_FLAGS TAGSOUP
		     \ TEXTFIELDS_NEED_ACTIVATION TIMEOUT TRIM_INPUT_FIELDS TRUSTED_EXEC TRUSTED_LYNXCGI
		     \ UNDERLINE_LINKS UPLOADER URL_DOMAIN_PREFIXES URL_DOMAIN_SUFFIXES USE_FIXED_RECORDS
		     \ USE_MOUSE USE_SELECT_POPUPS VERBOSE_IMAGES VIEWER VI_KEYS_ALWAYS_ON
		     \ WAIS_PROXY XLOADIMAGE_COMMAND contained nextgroup=lynxDelimiter
syn keyword lynxOption BZIP2_PATH CHMOD_PATH COMPRESS_PATH COPY_PATH GZIP_PATH
		     \ INSTALL_PATH MKDIR_PATH MV_PATH RLOGIN_PATH RMDIR_PATH
		     \ RM_PATH TAR_PATH TELNET_PATH TN3270_PATH TOUCH_PATH
		     \ UNCOMPRESS_PATH UNZIP_PATH UUDECODE_PATH ZCAT_PATH ZIP_PATH contained nextgroup=lynxDelimiter
syn case match

" NOTE: set this if you want the cfg2html.pl formatting directives to be highlighted
if exists("lynx_formatting_directives")
  syn match lynxFormatDir  "^\.\(h1\|h2\)\s.*$"
  syn match lynxFormatDir  "^\.\(ex\|nf\)\(\s\+\d\+\)\=$"
  syn match lynxFormatDir  "^\.fi$"
endif

hi def link lynxBoolean		Boolean
hi def link lynxComment		Comment
hi def link lynxDelimiter	Special
hi def link lynxFormatDir	Special
hi def link lynxNumber		Number
hi def link lynxOption		Identifier
hi def link lynxTodo		Todo

let b:current_syntax = "lynx"

let &cpo = s:cpo_save
unlet s:cpo_save

" vim: ts=8
