#!/usr/bin/perl

# sortmirrors.pl v0.2
# Judd Vinet <jvinet@zeroflux.org>
#
# A quick n' dirty perl script to re-prioritize the mirror lists
# in /etc/pacman.conf.
#
# It requires the "netselect" program, you can find it in Extra.
#
# If you have repositories listed in /etc/pacman.conf, run this:
# 
#   sortmirrors.pl </etc/pacman.conf >pacman.conf.new
#   mv pacman.conf.new /etc/pacman.conf
#
# If you have repositories defined in /etc/pacman.d/, run this:
#
#   for i in /etc/pacman.d/*; do
#     sortmirrors.pl <$i >$i.new
#     mv $i.new $i
#   done
#   
#

if(!-x "/usr/bin/netselect") {
	print STDERR "Install the netselect package first.\n";
	exit(1);
}

sub sortservers {
	$cmdstr = '';
	$ct = 0;
	foreach $key (keys %servers) {
		$cmdstr .= "$key ";
		$ct++;
	}
	if(!($cmdstr eq '')) {
		$cmdout = `netselect -v -s $ct $cmdstr | awk '{print \$2}'`;
		foreach $host (split /\n/, $cmdout) {
			if($servers{$host}) {
				print "$servers{$host}\n";
			}
		}
	}
	foreach $key (@noise) {
		print $key;
	}
}


$inblock = 0;
while($ln = <STDIN>) {
	if($inblock == 0) {
		print $ln;
	} else {
		if($ln =~ /^[Ss][Ee][Rr][Vv][Ee][Rr]\s*=\s*.*$/) {
			if($ln =~ /file:\/\//) {
				# output the "file://" servers first
				print $ln;
			} else {
				$host = $ln;
				$host =~ s/^[Ss][Ee][Rr][Vv][Ee][Rr]\s*=\s*[a-z]+:\/\///;
				$host =~ s/\/.*$//;
				chomp($ln);
				chomp($host);
				$servers{$host} = $ln;
			}
		} else {
			if(!($ln =~ /^\[.+\]$/)) {
				@noise = (@noise, $ln);
			}
		}
	}
	if($ln =~ /^\[.+\]$/) {
		if($inblock == 1) {
			sortservers;
			$inblock = 0;
			print $ln;
		}
		$inblock = 1;
		%servers = ();
		@noise = ();
		print STDERR ":: PROCESSING $ln";
	}
}

if($inblock == 1) {
	sortservers;
}


# vim: set ts=2 sw=2 noet:
