#!/bin/bash
#
# firmware loader
#

. /etc/sysconfig/hardware/scripts/functions

FIRMWARE_DIRS="/lib/firmware /usr/local/lib/firmware"

if [ ! -e /sys/$DEVPATH/loading ]; then
    info_mesg "firmware loader misses sysfs directory"
    exit 0
fi

for DIR in $FIRMWARE_DIRS; do
    [ -e "$DIR/$FIRMWARE" ] || continue
    info_mesg "loading $DIR/$FIRMWARE"
    echo 1 > /sys/$DEVPATH/loading
    cat "$DIR/$FIRMWARE" > /sys/$DEVPATH/data
    echo 0 > /sys/$DEVPATH/loading
    exit
done

echo -1 > /sys/$DEVPATH/loading
err_mesg "Cannot find  firmware file '$FIRMWARE'"
exit 1
