require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_GENERIC_DMA_MAPPING_H)) {
    eval 'sub _ASM_GENERIC_DMA_MAPPING_H {1;}' unless defined(&_ASM_GENERIC_DMA_MAPPING_H);
    require 'linux/config.ph';
    if(defined(&CONFIG_PCI)) {
	require 'linux/pci.ph';
	require 'linux/mm.ph';
	eval 'sub dma_supported {
	    my($dev,$mask) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_dma_supported( &to_pci_dev($dev), $mask); });
	}' unless defined(&dma_supported);
	eval 'sub dma_set_mask {
	    my($dev,$dma_mask) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_set_dma_mask( &to_pci_dev($dev), $dma_mask); });
	}' unless defined(&dma_set_mask);
	eval 'sub dma_alloc_coherent {
	    my($dev,$size,$dma_handle,$flag) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_alloc_consistent( &to_pci_dev($dev), $size, $dma_handle); });
	}' unless defined(&dma_alloc_coherent);
	eval 'sub dma_free_coherent {
	    my($dev,$size,$cpu_addr,$dma_handle) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_free_consistent( &to_pci_dev($dev), $size, $cpu_addr, $dma_handle); });
	}' unless defined(&dma_free_coherent);
	eval 'sub dma_map_single {
	    my($dev,$cpu_addr,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_map_single( &to_pci_dev, $cpu_addr, $size, $direction); });
	}' unless defined(&dma_map_single);
	eval 'sub dma_unmap_single {
	    my($dev,$dma_addr,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_unmap_single( &to_pci_dev, $dma_addr, $size, $direction); });
	}' unless defined(&dma_unmap_single);
	eval 'sub dma_map_page {
	    my($dev,$page,$offset,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_map_page( &to_pci_dev, $page, $offset, $size, $direction); });
	}' unless defined(&dma_map_page);
	eval 'sub dma_unmap_page {
	    my($dev,$dma_address,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_unmap_page( &to_pci_dev, $dma_address, $size, $direction); });
	}' unless defined(&dma_unmap_page);
	eval 'sub dma_map_sg {
	    my($dev,$sg,$nents,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_map_sg( &to_pci_dev, $sg, $nents, $direction); });
	}' unless defined(&dma_map_sg);
	eval 'sub dma_unmap_sg {
	    my($dev,$sg,$nhwentries,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_unmap_sg( &to_pci_dev, $sg, $nhwentries, $direction); });
	}' unless defined(&dma_unmap_sg);
	eval 'sub dma_sync_single_for_cpu {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_dma_sync_single_for_cpu( &to_pci_dev, $dma_handle, $size, $direction); });
	}' unless defined(&dma_sync_single_for_cpu);
	eval 'sub dma_sync_single_for_device {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_dma_sync_single_for_device( &to_pci_dev, $dma_handle, $size, $direction); });
	}' unless defined(&dma_sync_single_for_device);
	eval 'sub dma_sync_sg_for_cpu {
	    my($dev,$sg,$nelems,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_dma_sync_sg_for_cpu( &to_pci_dev, $sg, $nelems, $direction); });
	}' unless defined(&dma_sync_sg_for_cpu);
	eval 'sub dma_sync_sg_for_device {
	    my($dev,$sg,$nelems,$direction) = @_;
    	    eval q({  &BUG_ON( ($dev->{bus}) !=  &pci_bus_type);  &pci_dma_sync_sg_for_device( &to_pci_dev, $sg, $nelems, $direction); });
	}' unless defined(&dma_sync_sg_for_device);
	eval 'sub dma_mapping_error {
	    my($dma_addr) = @_;
    	    eval q({  &pci_dma_mapping_error($dma_addr); });
	}' unless defined(&dma_mapping_error);
    } else {
	eval 'sub dma_supported {
	    my($dev,$mask) = @_;
    	    eval q({ 0; });
	}' unless defined(&dma_supported);
	eval 'sub dma_set_mask {
	    my($dev,$dma_mask) = @_;
    	    eval q({  &BUG(); 0; });
	}' unless defined(&dma_set_mask);
	eval 'sub dma_alloc_coherent {
	    my($dev,$size,$dma_handle,$flag) = @_;
    	    eval q({  &BUG();  &NULL; });
	}' unless defined(&dma_alloc_coherent);
	eval 'sub dma_free_coherent {
	    my($dev,$size,$cpu_addr,$dma_handle) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_free_coherent);
	eval 'sub dma_map_single {
	    my($dev,$cpu_addr,$size,$direction) = @_;
    	    eval q({  &BUG(); 0; });
	}' unless defined(&dma_map_single);
	eval 'sub dma_unmap_single {
	    my($dev,$dma_addr,$size,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_unmap_single);
	eval 'sub dma_map_page {
	    my($dev,$page,$offset,$size,$direction) = @_;
    	    eval q({  &BUG(); 0; });
	}' unless defined(&dma_map_page);
	eval 'sub dma_unmap_page {
	    my($dev,$dma_address,$size,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_unmap_page);
	eval 'sub dma_map_sg {
	    my($dev,$sg,$nents,$direction) = @_;
    	    eval q({  &BUG(); 0; });
	}' unless defined(&dma_map_sg);
	eval 'sub dma_unmap_sg {
	    my($dev,$sg,$nhwentries,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_unmap_sg);
	eval 'sub dma_sync_single_for_cpu {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_sync_single_for_cpu);
	eval 'sub dma_sync_single_for_device {
	    my($dev,$dma_handle,$size,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_sync_single_for_device);
	eval 'sub dma_sync_sg_for_cpu {
	    my($dev,$sg,$nelems,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_sync_sg_for_cpu);
	eval 'sub dma_sync_sg_for_device {
	    my($dev,$sg,$nelems,$direction) = @_;
    	    eval q({  &BUG(); });
	}' unless defined(&dma_sync_sg_for_device);
	eval 'sub dma_error {
	    my($dma_addr) = @_;
    	    eval q({ 0; });
	}' unless defined(&dma_error);
    }
    eval 'sub dma_alloc_noncoherent {
        my($d, $s, $h, $f) = @_;
	    eval q( &dma_alloc_coherent($d, $s, $h, $f));
    }' unless defined(&dma_alloc_noncoherent);
    eval 'sub dma_free_noncoherent {
        my($d, $s, $v, $h) = @_;
	    eval q( &dma_free_coherent($d, $s, $v, $h));
    }' unless defined(&dma_free_noncoherent);
    eval 'sub dma_is_consistent {
        my($d) = @_;
	    eval q((1));
    }' unless defined(&dma_is_consistent);
    eval 'sub dma_get_cache_alignment {
        my($void) = @_;
	    eval q({ (1<<  &INTERNODE_CACHE_SHIFT); });
    }' unless defined(&dma_get_cache_alignment);
    eval 'sub dma_sync_single_range_for_cpu {
        my($dev,$dma_handle,$offset,$size,$direction) = @_;
	    eval q({  &dma_sync_single_for_cpu($dev, $dma_handle, $offset+$size, $direction); });
    }' unless defined(&dma_sync_single_range_for_cpu);
    eval 'sub dma_sync_single_range_for_device {
        my($dev,$dma_handle,$offset,$size,$direction) = @_;
	    eval q({  &dma_sync_single_for_device($dev, $dma_handle, $offset+$size, $direction); });
    }' unless defined(&dma_sync_single_range_for_device);
    eval 'sub dma_cache_sync {
        my($vaddr,$size,$direction) = @_;
	    eval q({  &BUG(); });
    }' unless defined(&dma_cache_sync);
}
1;
